/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.ai.improvements.ai;

import com.builtbroken.ai.improvements.overrides.instances.EntityOverrideAttackOnCollide;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EntityAIAttackOnCollideOverride
extends EntityAIBase {
    public final World worldObj;
    public final EntityCreature attacker;
    public int attackTimeTrigger = 20;
    public double speedTowardsTarget;
    public boolean longMemory;
    public Class classTarget;
    private int pathUpdateTimer;
    private double targetX;
    private double targetY;
    private double targetZ;
    private PathEntity entityPathEntity;
    private int attackTick;
    private int failedPathFindingPenalty;

    public EntityAIAttackOnCollideOverride(EntityCreature host, Class classToAttack, double moveSpeed, boolean longMemory) {
        this(host, moveSpeed, longMemory);
        this.classTarget = classToAttack;
    }

    public EntityAIAttackOnCollideOverride(EntityCreature host, double moveSpeed, boolean longMemory) {
        this.attacker = host;
        this.worldObj = host.field_70170_p;
        this.speedTowardsTarget = moveSpeed;
        this.longMemory = longMemory;
        this.func_75248_a(3);
    }

    public EntityAIAttackOnCollideOverride(EntityCreature entity, EntityOverrideAttackOnCollide.AttackSettings settings) {
        this(entity, settings.classTarget, settings.speedTowardsTarget, settings.longMemory);
        this.attackTimeTrigger = settings.attackTimeTrigger;
    }

    public boolean func_75250_a() {
        EntityLivingBase entitylivingbase = this.attacker.func_70638_az();
        if (this.isTargetValid()) {
            if (--this.pathUpdateTimer <= 0) {
                this.entityPathEntity = this.attacker.func_70661_as().func_75494_a((Entity)entitylivingbase);
                this.pathUpdateTimer = 4 + this.attacker.func_70681_au().nextInt(7);
                return this.entityPathEntity != null;
            }
            return true;
        }
        return false;
    }

    public boolean func_75253_b() {
        EntityLivingBase entitylivingbase = this.attacker.func_70638_az();
        return !this.isTargetValid() ? false : (!this.longMemory ? !this.attacker.func_70661_as().func_75500_f() : this.attacker.func_110176_b(MathHelper.func_76128_c((double)entitylivingbase.field_70165_t), MathHelper.func_76128_c((double)entitylivingbase.field_70163_u), MathHelper.func_76128_c((double)entitylivingbase.field_70161_v)));
    }

    public void func_75249_e() {
        this.attacker.func_70661_as().func_75484_a(this.entityPathEntity, this.speedTowardsTarget);
        this.pathUpdateTimer = 0;
    }

    public boolean isTargetValid() {
        EntityLivingBase entitylivingbase = this.attacker.func_70638_az();
        if (entitylivingbase == null) {
            return false;
        }
        if (!entitylivingbase.func_70089_S()) {
            return false;
        }
        return this.classTarget == null || this.classTarget.isAssignableFrom(entitylivingbase.getClass());
    }

    public void func_75251_c() {
        this.attacker.func_70661_as().func_75499_g();
    }

    public void func_75246_d() {
        EntityLivingBase entitylivingbase = this.attacker.func_70638_az();
        if (this.isTargetValid()) {
            if (this.lookAtTargetWhileAttacking()) {
                this.attacker.func_70671_ap().func_75651_a((Entity)entitylivingbase, 30.0f, 30.0f);
            }
            double distance = this.attacker.func_70092_e(entitylivingbase.field_70165_t, entitylivingbase.field_70121_D.field_72338_b, entitylivingbase.field_70161_v);
            --this.pathUpdateTimer;
            if ((this.longMemory || this.attacker.func_70635_at().func_75522_a((Entity)entitylivingbase)) && this.pathUpdateTimer <= 0 && (this.targetX == 0.0 && this.targetY == 0.0 && this.targetZ == 0.0 || entitylivingbase.func_70092_e(this.targetX, this.targetY, this.targetZ) >= 1.0 || this.attacker.func_70681_au().nextFloat() < 0.05f)) {
                PathPoint finalPathPoint;
                this.targetX = entitylivingbase.field_70165_t;
                this.targetY = entitylivingbase.field_70121_D.field_72338_b;
                this.targetZ = entitylivingbase.field_70161_v;
                this.pathUpdateTimer = this.failedPathFindingPenalty + 4 + this.attacker.func_70681_au().nextInt(7);
                this.failedPathFindingPenalty = this.attacker.func_70661_as().func_75505_d() != null ? ((finalPathPoint = this.attacker.func_70661_as().func_75505_d().func_75870_c()) != null && entitylivingbase.func_70092_e((double)finalPathPoint.field_75839_a, (double)finalPathPoint.field_75837_b, (double)finalPathPoint.field_75838_c) < 1.0 ? 0 : (this.failedPathFindingPenalty += 10)) : (this.failedPathFindingPenalty += 10);
                if (distance > 1024.0) {
                    this.pathUpdateTimer += 10;
                } else if (distance > 256.0) {
                    this.pathUpdateTimer += 5;
                }
                if (!this.attacker.func_70661_as().func_75497_a((Entity)entitylivingbase, this.speedTowardsTarget)) {
                    this.pathUpdateTimer += 15;
                }
            }
            this.attackTick = Math.max(this.attackTick - 1, 0);
            if (distance <= this.getAttackDistanceSQ() && this.attackTick <= 0) {
                this.attackTick = this.attackTimeTrigger;
                if (this.attacker.func_70694_bm() != null) {
                    this.attacker.func_71038_i();
                }
                this.attacker.func_70652_k((Entity)entitylivingbase);
            }
        }
    }

    protected boolean lookAtTargetWhileAttacking() {
        return true;
    }

    protected double getAttackDistanceSQ() {
        if (this.attacker.func_70638_az() != null) {
            return this.attacker.field_70130_N * 2.0f * this.attacker.field_70130_N * 2.0f + this.attacker.func_70638_az().field_70130_N;
        }
        return 1.0;
    }
}

