/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.ai.improvements.overrides;

import com.builtbroken.ai.improvements.AIImprovements;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;

public class EntityOverride {
    public final String id;
    public String description;
    public boolean enabled = true;
    protected Configuration configuration;
    protected List<String> entityByIdToEffect = new ArrayList<String>();

    public EntityOverride(String id, String description) {
        this.id = id;
        this.description = description;
    }

    public void applyChanges(Entity entity) {
    }

    public void loadSettings(Configuration configuration) {
        this.configuration = configuration;
        this.configuration.load();
        this.loadOverAllSettings();
        Set ids = EntityList.func_151515_b();
        for (String id : ids) {
            if (!this.canAffectEntity(id)) continue;
            this.loadEntitySettings(id);
        }
        this.configuration.save();
    }

    public boolean canAffectEntity(String id) {
        if (this.entityByIdToEffect.contains(id)) {
            return true;
        }
        try {
            Entity entity = EntityOverride.createEntityByName(id, AIImprovements.fakeWorld);
            if (entity != null) {
                return this.canAffectEntity(entity);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static Entity createEntityByName(String id, World world) {
        Entity entity = null;
        Class oclass = (Class)EntityList.field_75625_b.get(id);
        try {
            if (oclass != null) {
                Constructor constructor = oclass.getConstructor(World.class);
                constructor.setAccessible(true);
                if (constructor != null) {
                    entity = (Entity)constructor.newInstance(world);
                }
            }
        }
        catch (NoSuchMethodException e) {
            AIImprovements.LOGGER.error("EntityOverride: Couldn't find constructor 'Entity(World)' for entity[" + id + ", " + oclass + "] in order to test for AI tasks");
            if (e.getCause() != null) {
                e.getCause().printStackTrace();
            }
        }
        catch (InstantiationException e) {
            AIImprovements.LOGGER.error("EntityOverride: Failed to use constructor 'Entity(World)' for entity[" + id + ", " + oclass + "] in order to test for AI tasks");
            if (e.getCause() != null) {
                e.getCause().printStackTrace();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return entity;
    }

    public boolean canAffectEntity(Entity entity) {
        return false;
    }

    public void loadOverAllSettings() {
    }

    public void loadEntitySettings(String id) {
    }
}

