/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.ai.improvements.overrides;

import com.builtbroken.ai.improvements.AIImprovements;
import com.builtbroken.ai.improvements.overrides.EntityOverride;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.File;
import java.util.HashMap;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;

public class OverrideHandler {
    public static final OverrideHandler INSTANCE = new OverrideHandler();
    public static HashMap<String, EntityOverride> globalList = new HashMap();

    public static void registerOverride(EntityOverride override) {
        if (globalList.containsKey(override.id)) {
            AIImprovements.LOGGER.warn("OverrideHandler: replacing existing override [id=" + override.id + " value=" + globalList.get(override.id) + "] with " + override);
        }
        globalList.put(override.id, override);
    }

    public void init(Configuration configuration) {
        for (EntityOverride override : globalList.values()) {
            if (override == null) continue;
            override.enabled = configuration.getBoolean(override.id, "enable_override_handlers", override.enabled, override.description);
        }
        for (EntityOverride override : globalList.values()) {
            if (override == null || !override.enabled) continue;
            override.loadSettings(new Configuration(new File(AIImprovements.configFolder, "overrides/" + override.id + ".cfg")));
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        for (EntityOverride override : globalList.values()) {
            if (override == null || !override.enabled) continue;
            override.applyChanges(event.entity);
        }
    }
}

