/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.ai.improvements.overrides.instances;

import com.builtbroken.ai.improvements.AIImprovements;
import com.builtbroken.ai.improvements.ai.EntityAIArrowAttackOverride;
import com.builtbroken.ai.improvements.overrides.EntityOverride;
import java.util.HashMap;
import java.util.ListIterator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.ai.EntityAIArrowAttack;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.world.World;

public class EntityOverrideArrowAttack
extends EntityOverride {
    HashMap<String, ArrowAttackSettings> arrowAttackSettings = new HashMap();

    public EntityOverrideArrowAttack() {
        super("minecraft.attack.arrow", "Allows overriding default settings for arrow range attacks used by skeleton. Might work on modded entities but depends on implementation by each mod.");
    }

    @Override
    public void applyChanges(Entity entity) {
        ArrowAttackSettings settings;
        String id;
        if (entity instanceof IRangedAttackMob && entity instanceof EntityLivingBase && this.arrowAttackSettings.containsKey(id = EntityList.func_75621_b((Entity)entity)) && (settings = this.arrowAttackSettings.get(id)) != null) {
            ListIterator it = ((EntityCreature)entity).field_70714_bg.field_75782_a.listIterator();
            while (it.hasNext()) {
                EntityAITasks.EntityAITaskEntry obj = (EntityAITasks.EntityAITaskEntry)it.next();
                if (obj.field_75733_a.getClass() != EntityAIArrowAttack.class) continue;
                obj.field_75733_a = new EntityAIArrowAttackOverride((IRangedAttackMob)entity, settings);
            }
        }
    }

    @Override
    public void loadOverAllSettings() {
    }

    @Override
    public void loadEntitySettings(String id) {
        for (int i = 0; i < 2 && !this.arrowAttackSettings.containsKey(id); ++i) {
            Entity entity = EntityList.func_75620_a((String)id, (World)AIImprovements.fakeWorld);
            if (!(entity instanceof EntityCreature)) continue;
            ArrowAttackSettings settings = null;
            if (i == 1) {
                ((EntityLiving)entity).func_110161_a(null);
            }
            for (EntityAITasks.EntityAITaskEntry obj : ((EntityCreature)entity).field_70714_bg.field_75782_a) {
                if (obj.field_75733_a.getClass() != EntityAIArrowAttack.class) continue;
                if (settings == null) {
                    EntityAIArrowAttack action = (EntityAIArrowAttack)obj.field_75733_a;
                    settings = new ArrowAttackSettings();
                    settings.entityMoveSpeed = action.field_75321_e;
                    settings.minRangedAttackTime = action.field_96561_g;
                    settings.maxRangedAttackTime = action.field_75325_h;
                    settings.attackRange = action.field_96562_i;
                    continue;
                }
                AIImprovements.LOGGER.warn("Entity[" + id + "] contains more than one instance of EntityAIArrowAttack when only 1 can run at a time. This will cause issue with the AI and result in all being replaced by the same data. This is likely a bug or an oversight by the entity's developer and should be reported as a potential bug.");
                break;
            }
            if (settings == null) continue;
            String category = id + "#rangedAttack";
            settings.minRangedAttackTime = this.configuration.getInt("minAttackTime", category, settings.minRangedAttackTime, 0, 1200, "Shortest time in ticks (20 ticks a second) between attacks");
            settings.maxRangedAttackTime = this.configuration.getInt("maxAttackTime", category, settings.maxRangedAttackTime, 0, 1200, "Longest time in ticks (20 ticks a second) between attacks, scaled using (((distanceToTargetSQ / attackRange) * (maxTime - minTime)) + minTime) resulting in faster attacks the closer a target gets.");
            settings.entityMoveSpeed = this.configuration.getFloat("moveSpeedTowardsTarget", category, (float)settings.entityMoveSpeed, 0.0f, 2.0f, "Speed of the entity when moving closer to the target.");
            settings.attackRange = this.configuration.getFloat("range", category, settings.attackRange, 0.0f, 400.0f, "Range to attack targets, is limited by power of an arrow and target selector range");
            if (!this.configuration.getBoolean("enable", category, false, "allows enabling replacement for the entity class's attack AI and settings")) continue;
            this.arrowAttackSettings.put(id, settings);
        }
    }

    @Override
    public boolean canAffectEntity(Entity entity) {
        return entity instanceof IRangedAttackMob && entity instanceof EntityLivingBase;
    }

    public final class ArrowAttackSettings {
        public double entityMoveSpeed;
        public int minRangedAttackTime;
        public int maxRangedAttackTime;
        public float attackRange;
    }
}

