/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.ai.improvements.overrides.instances;

import com.builtbroken.ai.improvements.AIImprovements;
import com.builtbroken.ai.improvements.ai.EntityAIAttackOnCollideOverride;
import com.builtbroken.ai.improvements.overrides.EntityOverride;
import java.util.HashMap;
import java.util.ListIterator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.world.World;

public class EntityOverrideAttackOnCollide
extends EntityOverride {
    HashMap<String, HashMap<Class, AttackSettings>> settings = new HashMap();

    public EntityOverrideAttackOnCollide() {
        super("minecraft.attack.collide", "Allows overriding default settings for close range attacks used by zombies, pig zombies, or any melee monster. Might work on modded entities but depends on implementation by each mod.");
    }

    @Override
    public void applyChanges(Entity entity) {
        HashMap<Class, AttackSettings> settingsHashMap;
        String id;
        if (entity instanceof EntityCreature && this.settings.containsKey(id = EntityList.func_75621_b((Entity)entity)) && (settingsHashMap = this.settings.get(id)) != null && !settingsHashMap.isEmpty()) {
            ListIterator it = ((EntityCreature)entity).field_70714_bg.field_75782_a.listIterator();
            while (it.hasNext()) {
                Class attackClass;
                EntityAITasks.EntityAITaskEntry obj = (EntityAITasks.EntityAITaskEntry)it.next();
                if (obj.field_75733_a.getClass() != EntityAIAttackOnCollide.class || !settingsHashMap.containsKey(attackClass = ((EntityAIAttackOnCollide)obj.field_75733_a).field_75444_h)) continue;
                AttackSettings settings = settingsHashMap.get(attackClass);
                obj.field_75733_a = new EntityAIAttackOnCollideOverride((EntityCreature)entity, settings);
            }
        }
    }

    @Override
    public void loadOverAllSettings() {
    }

    @Override
    public void loadEntitySettings(String id) {
        Entity entity = EntityList.func_75620_a((String)id, (World)AIImprovements.fakeWorld);
        if (entity instanceof EntityCreature) {
            HashMap<Class, AttackSettings> settingsHashMap = new HashMap<Class, AttackSettings>();
            for (EntityAITasks.EntityAITaskEntry obj : ((EntityCreature)entity).field_70714_bg.field_75782_a) {
                if (obj.field_75733_a.getClass() != EntityAIAttackOnCollide.class) continue;
                EntityAIAttackOnCollide action = (EntityAIAttackOnCollide)obj.field_75733_a;
                AttackSettings settings = new AttackSettings();
                settings.classTarget = action.field_75444_h;
                settings.attackTimeTrigger = 20;
                settings.speedTowardsTarget = action.field_75440_e;
                settings.longMemory = action.field_75437_f;
                if (settingsHashMap.containsKey(settings.classTarget)) continue;
                settingsHashMap.put(settings.classTarget, settings);
            }
            HashMap<Class, AttackSettings> actualSettingMap = new HashMap<Class, AttackSettings>();
            for (AttackSettings settings : settingsHashMap.values()) {
                String class_id;
                String category = id + "#attacking#";
                category = settings.classTarget != null ? ((class_id = (String)EntityList.field_75626_c.get(settings.classTarget)) != null ? category + class_id : category + "[" + settings.classTarget.toString().replace("class", "").replace(".", "_").trim() + "]") : category + "any";
                settings.attackTimeTrigger = this.configuration.getInt("attackTime", category, settings.attackTimeTrigger, 0, 1200, "Time in ticks (20 ticks a second) between attacks");
                settings.speedTowardsTarget = this.configuration.getFloat("moveSpeedTowardsTarget", category, (float)settings.speedTowardsTarget, 0.0f, 2.0f, "Speed of the entity when moving closer to the target.");
                settings.longMemory = this.configuration.getBoolean("useLongMemory", category, settings.longMemory, "Allows the entity to keep tracking a target even if it can't walk to the target.");
                if (!this.configuration.getBoolean("enable", category, false, "allows enabling replacement for the entity class's attack AI and settings")) continue;
                actualSettingMap.put(settings.classTarget, settings);
            }
            if (!actualSettingMap.isEmpty()) {
                this.settings.put(id, actualSettingMap);
            }
        }
    }

    @Override
    public boolean canAffectEntity(Entity entity) {
        return entity instanceof EntityCreature;
    }

    public final class AttackSettings {
        public int attackTimeTrigger;
        public double speedTowardsTarget;
        public boolean longMemory;
        public Class classTarget;
    }
}

