/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.interfaces.cc.providers;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.IPeripheralProvider;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import openmods.Log;
import openmods.reflection.ReflectionHelper;
import openmods.utils.CachedFactory;
import openperipheral.adapter.TileEntityBlacklist;
import openperipheral.adapter.composed.IndexedMethodMap;
import openperipheral.api.adapter.GenerationFailedException;
import openperipheral.api.architecture.cc.ICustomPeripheralProvider;
import openperipheral.api.peripheral.ExposeInterface;
import openperipheral.api.peripheral.IOpenPeripheral;
import openperipheral.interfaces.cc.ModuleComputerCraft;
import openperipheral.interfaces.cc.providers.IPeripheralFactory;
import openperipheral.interfaces.cc.providers.SafePeripheralFactory;
import openperipheral.interfaces.cc.wrappers.AdapterPeripheral;
import openperipheral.interfaces.cc.wrappers.ProxyAdapterPeripheral;

public class PeripheralProvider
implements IPeripheralProvider {
    private static final IPeripheralFactory<TileEntity> NULL_FACTORY = new IPeripheralFactory<TileEntity>(){

        @Override
        public IPeripheral getPeripheral(TileEntity obj, int side) {
            return null;
        }
    };
    private static final IPeripheralFactory<TileEntity> PROVIDER_ADAPTER = new SafePeripheralFactory(){

        @Override
        protected IPeripheral createPeripheral(TileEntity tile, int side) {
            return ((ICustomPeripheralProvider)tile).createPeripheral(side);
        }
    };
    private static final CachedFactory<Class<? extends TileEntity>, IPeripheralFactory<TileEntity>> ADAPTED_CLASSES = new CachedFactory<Class<? extends TileEntity>, IPeripheralFactory<TileEntity>>(){

        protected IPeripheralFactory<TileEntity> create(Class<? extends TileEntity> targetCls) {
            try {
                if (IPeripheral.class.isAssignableFrom(targetCls)) {
                    return NULL_FACTORY;
                }
                if (ICustomPeripheralProvider.class.isAssignableFrom(targetCls)) {
                    return PROVIDER_ADAPTER;
                }
                if (TileEntityBlacklist.INSTANCE.isBlacklisted(targetCls)) {
                    return NULL_FACTORY;
                }
                IndexedMethodMap methods = PeripheralProvider.getMethodsForClass(targetCls);
                if (methods.isEmpty()) {
                    return NULL_FACTORY;
                }
                Set proxyClasses = PeripheralProvider.getProxyClasses(targetCls);
                return proxyClasses.isEmpty() ? PeripheralProvider.createDirectFactory(methods) : PeripheralProvider.createProxyFactory(methods, targetCls, proxyClasses);
            }
            catch (Exception e) {
                Log.warn((Throwable)e, (String)"Failed to create factory for %s", (Object[])new Object[]{targetCls});
                return SafePeripheralFactory.BROKEN_FACTORY;
            }
        }
    };

    private static IPeripheralFactory<TileEntity> createDirectFactory(final IndexedMethodMap methods) {
        return new SafePeripheralFactory(){

            @Override
            protected IPeripheral createPeripheral(TileEntity target, int side) {
                return new AdapterPeripheral(methods, target);
            }
        };
    }

    private static IPeripheralFactory<TileEntity> createProxyFactory(final IndexedMethodMap methods, Class<?> cls, Set<Class<?>> proxyClasses) {
        Set<Class<?>> interfaces = PeripheralProvider.appendCommonInterfaces(proxyClasses);
        final Constructor<? extends IPeripheral> ctor = PeripheralProvider.getProxyConstructor(cls, interfaces);
        ctor.setAccessible(true);
        return new SafePeripheralFactory(){

            @Override
            public IPeripheral createPeripheral(TileEntity tile, int side) throws Exception {
                ProxyAdapterPeripheral handler = new ProxyAdapterPeripheral(methods, tile);
                return (IPeripheral)ctor.newInstance(handler);
            }
        };
    }

    private static Set<Class<?>> appendCommonInterfaces(Set<Class<?>> proxyClasses) {
        HashSet interfaces = Sets.newHashSet(proxyClasses);
        interfaces.add(IPeripheral.class);
        interfaces.add(IOpenPeripheral.class);
        return interfaces;
    }

    private static Constructor<? extends IPeripheral> getProxyConstructor(Class<?> cls, Set<Class<?>> interfaces) {
        Class[] tmp = interfaces.toArray(new Class[interfaces.size()]);
        try {
            Class<?> proxyCls = Proxy.getProxyClass(cls.getClassLoader(), tmp);
            return proxyCls.getConstructor(InvocationHandler.class);
        }
        catch (Throwable t) {
            throw new RuntimeException(String.format("Failed to create proxy class for %s", cls), t);
        }
    }

    private static IndexedMethodMap getMethodsForClass(Class<?> cls) {
        return ModuleComputerCraft.PERIPHERAL_METHODS_FACTORY.getAdaptedClass(cls);
    }

    private static IPeripheralFactory<TileEntity> getFactoryForClass(Class<? extends TileEntity> teClass) {
        return (IPeripheralFactory)ADAPTED_CLASSES.getOrCreate(teClass);
    }

    public static IPeripheral createAdaptedPeripheralWrapped(Object target) {
        Preconditions.checkNotNull((Object)target, (Object)"Null target");
        try {
            return PeripheralProvider.createAdaptedPeripheral(target);
        }
        catch (Throwable t) {
            throw new GenerationFailedException(String.format("%s (%s)", target, target.getClass()), t);
        }
    }

    private static Set<Class<?>> getProxyClasses(Class<?> target) {
        ExposeInterface proxyAnn = target.getAnnotation(ExposeInterface.class);
        if (proxyAnn == null) {
            return ImmutableSet.of();
        }
        Set implemented = ReflectionHelper.getAllInterfaces(target);
        ImmutableSet whitelist = ImmutableSet.copyOf((Object[])proxyAnn.value());
        Sets.SetView proxied = Sets.intersection((Set)implemented, (Set)whitelist);
        return ImmutableSet.copyOf((Collection)proxied);
    }

    public static IPeripheral createAdaptedPeripheral(Object target) {
        Class<?> targetClass = target.getClass();
        IndexedMethodMap methods = PeripheralProvider.getMethodsForClass(targetClass);
        if (methods.isEmpty()) {
            return null;
        }
        Set<Class<?>> proxied = PeripheralProvider.getProxyClasses(targetClass);
        if (proxied.isEmpty()) {
            return new AdapterPeripheral(methods, target);
        }
        Set<Class<?>> allImplemented = PeripheralProvider.appendCommonInterfaces(proxied);
        ProxyAdapterPeripheral handler = new ProxyAdapterPeripheral(methods, target);
        Class[] interfaces = allImplemented.toArray(new Class[allImplemented.size()]);
        return (IPeripheral)Proxy.newProxyInstance(targetClass.getClassLoader(), interfaces, (InvocationHandler)handler);
    }

    public IPeripheral getPeripheral(World world, int x, int y, int z, int side) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te == null) {
            return null;
        }
        IPeripheralFactory<TileEntity> factory = PeripheralProvider.getFactoryForClass(te.getClass());
        IPeripheral peripheral = factory.getPeripheral(te, side);
        return peripheral;
    }
}

