/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.meta;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import openmods.Log;
import openperipheral.api.meta.IEntityMetaProvider;
import openperipheral.api.meta.IItemStackMetaProvider;
import openperipheral.api.meta.IMetaProvider;

public class MetaProvidersRegistry<P extends IMetaProvider<?>> {
    public static final MetaProvidersRegistry<IEntityMetaProvider<?>> ENITITES = MetaProvidersRegistry.create(Entity.class, "entity");
    public static final MetaProvidersRegistry<IItemStackMetaProvider<?>> ITEMS = MetaProvidersRegistry.create(Item.class, "item");
    private final Multimap<Class<?>, P> directProviders = ArrayListMultimap.create();
    private final Map<Class<?>, Map<String, P>> providersCache = Maps.newHashMap();
    private final String type;
    private final Class<?> baseClass;

    private static <T extends IMetaProvider<?>> MetaProvidersRegistry<T> create(Class<?> baseCls, String type) {
        return new MetaProvidersRegistry(type, baseCls);
    }

    public MetaProvidersRegistry(String type, Class<?> baseClass) {
        this.type = type;
        this.baseClass = baseClass;
    }

    public void addProvider(P provider) {
        Class targetClass = provider.getTargetClass();
        Preconditions.checkArgument((targetClass.isInterface() || this.baseClass.isAssignableFrom(targetClass) ? 1 : 0) != 0, (String)"Invalid type: %s", (Object[])new Object[]{targetClass});
        this.directProviders.put(targetClass, provider);
        Log.trace((String)"Registering %s metadata provider '%s' for '%s'", (Object[])new Object[]{this.type, provider.getClass(), targetClass});
        this.providersCache.clear();
    }

    public Map<String, P> getProviders(Class<?> cls) {
        HashMap providerMap = this.providersCache.get(cls);
        if (providerMap == null) {
            Set<P> providers = this.collectAllProviders(cls);
            providerMap = Maps.newHashMap();
            for (IMetaProvider provider : providers) {
                String key = provider.getKey();
                IMetaProvider previous = providerMap.put(key, provider);
                Preconditions.checkState((previous == null ? 1 : 0) != 0, (String)"Duplicate meta provider for key %s on class %s: %s -> %s", (Object[])new Object[]{key, cls, previous, provider});
            }
            providerMap = ImmutableMap.copyOf((Map)providerMap);
            this.providersCache.put(cls, providerMap);
        }
        return providerMap;
    }

    private Set<P> collectAllProviders(Class<?> targetCls) {
        Set providers = Sets.newIdentityHashSet();
        for (Class<?> cls : MetaProvidersRegistry.getAllImplementedClasses(targetCls)) {
            providers.addAll(this.directProviders.get(cls));
        }
        return providers;
    }

    private static Set<Class<?>> getAllImplementedClasses(Class<?> targetCls) {
        HashSet classes = Sets.newHashSet();
        LinkedList queue = Lists.newLinkedList();
        queue.add(targetCls);
        while (!queue.isEmpty()) {
            Class cls = (Class)queue.poll();
            classes.add(cls);
            Class superclass = cls.getSuperclass();
            if (superclass != null) {
                queue.add(superclass);
            }
            queue.addAll(Arrays.asList(cls.getInterfaces()));
        }
        return classes;
    }
}

