/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.the_aether;

import com.gildedgames.the_aether.AetherConfig;
import com.gildedgames.the_aether.blocks.BlocksAether;
import com.gildedgames.the_aether.blocks.portal.BlockAetherPortal;
import com.gildedgames.the_aether.entities.EntitiesAether;
import com.gildedgames.the_aether.entities.bosses.EntityValkyrie;
import com.gildedgames.the_aether.entities.passive.mountable.EntityAerbunny;
import com.gildedgames.the_aether.entities.passive.mountable.EntityFlyingCow;
import com.gildedgames.the_aether.items.ItemsAether;
import com.gildedgames.the_aether.items.dungeon.ItemDungeonKey;
import com.gildedgames.the_aether.items.util.EnumSkyrootBucketType;
import com.gildedgames.the_aether.items.weapons.ItemSkyrootSword;
import com.gildedgames.the_aether.network.AetherNetwork;
import com.gildedgames.the_aether.network.packets.PacketSendEternalDay;
import com.gildedgames.the_aether.network.packets.PacketSendShouldCycle;
import com.gildedgames.the_aether.player.PlayerAether;
import com.gildedgames.the_aether.registry.achievements.AchievementsAether;
import com.gildedgames.the_aether.world.AetherData;
import com.gildedgames.the_aether.world.AetherWorldProvider;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.ObfuscationReflectionHelper;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.stats.StatBase;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.entity.EntityStruckByLightningEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.EntityInteractEvent;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;

public class AetherEventHandler {
    @SubscribeEvent
    public void checkBlockBannedEvent(PlayerInteractEvent event) {
        if (event.action == PlayerInteractEvent.Action.LEFT_CLICK_BLOCK) {
            return;
        }
        EntityPlayer player = event.entityPlayer;
        ItemStack currentStack = player.func_71045_bC();
        if (player.field_71093_bK == AetherConfig.getAetherDimensionID()) {
            if (currentStack != null) {
                if (currentStack.func_77973_b() == Items.field_151033_d || currentStack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150478_aa) || currentStack.func_77973_b() == Items.field_151059_bz) {
                    for (int i = 0; i < 10; ++i) {
                        event.world.func_72869_a("smoke", (double)event.x, (double)event.y, (double)event.z, 0.0, 0.0, 0.0);
                    }
                    event.setCanceled(true);
                }
            } else if (event.world.func_147439_a(event.x, event.y, event.z) == Blocks.field_150324_C) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onEntityInteract(EntityInteractEvent event) {
        EntityPlayer player;
        ItemStack heldItem;
        EntityAgeable entityageable;
        Class<?> oclass;
        ItemStack itemstack;
        if (event.target instanceof EntityAgeable && (itemstack = event.entityPlayer.field_71071_by.func_70448_g()) != null && itemstack.func_77973_b() == ItemsAether.aether_spawn_egg && !event.entityPlayer.field_70170_p.field_72995_K && (oclass = EntitiesAether.getClassFromID(itemstack.func_77960_j())) != null && oclass.isAssignableFrom(this.getClass()) && (entityageable = ((EntityAgeable)event.target).func_90011_a((EntityAgeable)event.target)) != null) {
            entityageable.func_70873_a(-24000);
            entityageable.func_70012_b(event.target.field_70165_t, event.target.field_70163_u, event.target.field_70161_v, 0.0f, 0.0f);
            event.entityPlayer.field_70170_p.func_72838_d((Entity)entityageable);
            if (itemstack.func_82837_s()) {
                entityageable.func_94058_c(itemstack.func_82833_r());
            }
            if (!event.entityPlayer.field_71075_bZ.field_75098_d) {
                --itemstack.field_77994_a;
                if (itemstack.field_77994_a <= 0) {
                    event.entityPlayer.field_71071_by.func_70299_a(event.entityPlayer.field_71071_by.field_70461_c, (ItemStack)null);
                }
            }
        }
        if ((event.target instanceof EntityCow || event.target instanceof EntityFlyingCow) && (heldItem = (player = event.entityPlayer).func_71045_bC()) != null && heldItem.func_77973_b() == ItemsAether.skyroot_bucket && EnumSkyrootBucketType.getType(heldItem.func_77960_j()) == EnumSkyrootBucketType.Empty) {
            if (!player.field_71075_bZ.field_75098_d) {
                --heldItem.field_77994_a;
            }
            if (heldItem.field_77994_a <= 0) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, new ItemStack(ItemsAether.skyroot_bucket, 1, EnumSkyrootBucketType.Milk.meta));
            } else if (!player.field_71071_by.func_70441_a(new ItemStack(ItemsAether.skyroot_bucket, 1, EnumSkyrootBucketType.Milk.meta))) {
                player.func_71019_a(new ItemStack(ItemsAether.skyroot_bucket, 1, EnumSkyrootBucketType.Milk.meta), false);
            }
        }
    }

    @SubscribeEvent
    public void onFillBucket(FillBucketEvent event) {
        boolean validDimension;
        World worldObj = event.world;
        MovingObjectPosition target = event.target;
        ItemStack stack = event.current;
        EntityPlayer player = event.entityPlayer;
        boolean isWater = !AetherConfig.activateOnlyWithSkyroot() && stack.func_77973_b() == Items.field_151131_as || stack.func_77973_b() == ItemsAether.skyroot_bucket && stack.func_77960_j() == 1;
        boolean isLava = stack.func_77973_b() == Items.field_151129_at;
        boolean bl = validDimension = player.field_71093_bK == AetherConfig.getTravelDimensionID() || player.field_71093_bK == AetherConfig.getAetherDimensionID();
        if (target != null && target.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && validDimension) {
            int i = target.field_72311_b;
            int j = target.field_72312_c;
            int k = target.field_72309_d;
            if (target.field_72310_e == 0) {
                --j;
            }
            if (target.field_72310_e == 1) {
                ++j;
            }
            if (target.field_72310_e == 2) {
                --k;
            }
            if (target.field_72310_e == 3) {
                ++k;
            }
            if (target.field_72310_e == 4) {
                --i;
            }
            if (isWater && ((BlockAetherPortal)BlocksAether.aether_portal).trySpawnPortal(worldObj, i, j, k)) {
                if (!player.field_71075_bZ.field_75098_d) {
                    if (stack.func_77973_b() == ItemsAether.skyroot_bucket && stack.func_77960_j() == 1) {
                        event.result = new ItemStack(ItemsAether.skyroot_bucket);
                    }
                    if (stack.func_77973_b() == Items.field_151131_as) {
                        event.result = new ItemStack(Items.field_151133_ar);
                    }
                }
                event.setResult(Event.Result.ALLOW);
            }
            if (isLava && player.field_71093_bK == AetherConfig.getAetherDimensionID()) {
                if (player.field_71075_bZ.field_75098_d && player.func_70093_af()) {
                    return;
                }
                if (worldObj.func_147437_c(i, j, k)) {
                    worldObj.func_147449_b(i, j, k, BlocksAether.aerogel);
                    if (!player.field_71075_bZ.field_75098_d) {
                        event.result = new ItemStack(Items.field_151133_ar);
                    }
                }
                event.setResult(Event.Result.ALLOW);
            }
        }
    }

    @SubscribeEvent
    public void onCrafting(PlayerEvent.ItemCraftedEvent event) {
        if (this.isGravititeTool(event.crafting.func_77973_b())) {
            event.player.func_71029_a((StatBase)AchievementsAether.grav_tools);
        } else if (event.crafting.func_77973_b() == Item.func_150898_a((Block)BlocksAether.enchanter)) {
            event.player.func_71029_a((StatBase)AchievementsAether.enchanter);
        }
    }

    @SubscribeEvent
    public void onEntityDropLoot(LivingDropsEvent event) {
        if (event.source instanceof EntityDamageSource) {
            EntityLivingBase entity = event.entityLiving;
            EntityDamageSource source = (EntityDamageSource)event.source;
            if (source.func_76346_g() instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)source.func_76346_g();
                ItemStack currentItem = player.field_71071_by.func_70448_g();
                if (currentItem != null && currentItem.func_77973_b() instanceof ItemSkyrootSword && !(entity instanceof EntityPlayer) && !(entity instanceof EntityWither) && !(entity instanceof EntityValkyrie)) {
                    for (EntityItem items : event.drops) {
                        ItemStack stack = items.func_92059_d();
                        if (stack.func_77973_b() instanceof ItemDungeonKey || stack.func_77973_b() == ItemsAether.victory_medal || stack.func_77973_b() == Items.field_151144_bL) continue;
                        EntityItem item = new EntityItem(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, items.func_92059_d());
                        entity.field_70170_p.func_72838_d((Entity)item);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onEntityStruckByLightning(EntityStruckByLightningEvent event) {
        if (event.entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entity;
            if (player.field_71071_by.func_70448_g() != null && (player.field_71071_by.func_70448_g().func_77973_b() == ItemsAether.lightning_sword || player.field_71071_by.func_70448_g().func_77973_b() == ItemsAether.lightning_knife)) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onEntityDamage(LivingAttackEvent event) {
        EntityAerbunny aerbunny;
        if (event.entityLiving instanceof EntityAerbunny && (aerbunny = (EntityAerbunny)event.entityLiving).func_70115_ae() && aerbunny.field_70154_o instanceof EntityPlayer) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onEntityAttack(AttackEntityEvent event) {
        if (event.entityPlayer.func_70694_bm() != null) {
            String s;
            if (event.entityPlayer.func_70694_bm().func_77973_b() == ItemsAether.flaming_sword) {
                if (event.target.func_70075_an() && !event.target.func_85031_j((Entity)event.entityPlayer) && event.target instanceof EntityLivingBase) {
                    int defaultTime = 30;
                    int fireAspectModifier = EnchantmentHelper.func_90036_a((EntityLivingBase)event.entityPlayer);
                    if (fireAspectModifier > 0) {
                        defaultTime += fireAspectModifier * 4;
                    }
                    event.target.func_70015_d(defaultTime);
                }
            } else if (event.entityPlayer.func_70694_bm().func_77973_b() == ItemsAether.pig_slayer && (s = EntityList.func_75621_b((Entity)event.target)) != null && (s.toLowerCase().contains("pig") || s.toLowerCase().contains("phyg") || s.toLowerCase().contains("taegore") || event.target.func_110124_au().toString().equals("1d680bb6-2a9a-4f25-bf2f-a1af74361d69")) && event.target.field_70170_p.field_72995_K) {
                for (int j = 0; j < 20; ++j) {
                    Random itemRand = new Random();
                    double d = itemRand.nextGaussian() * 0.02;
                    double d1 = itemRand.nextGaussian() * 0.02;
                    double d2 = itemRand.nextGaussian() * 0.02;
                    double d3 = 5.0;
                    event.target.field_70170_p.func_72869_a("flame", event.target.field_70165_t + (double)(itemRand.nextFloat() * event.target.field_70130_N * 2.0f) - (double)event.target.field_70130_N - d * d3, event.target.field_70163_u + (double)(itemRand.nextFloat() * event.target.field_70131_O) - d1 * d3, event.target.field_70161_v + (double)(itemRand.nextFloat() * event.target.field_70130_N * 2.0f) - (double)event.target.field_70130_N - d2 * d3, d, d1, d2);
                }
            }
        }
    }

    public boolean isGravititeTool(Item stackID) {
        return stackID == ItemsAether.gravitite_shovel || stackID == ItemsAether.gravitite_axe || stackID == ItemsAether.gravitite_pickaxe;
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (!event.world.field_72995_K) {
            AetherData data = AetherData.getInstance(event.world);
            WorldProvider provider = event.world.field_73011_w;
            if (provider instanceof AetherWorldProvider) {
                AetherWorldProvider providerAether = (AetherWorldProvider)provider;
                providerAether.setIsEternalDay(data.isEternalDay());
                AetherNetwork.sendToAll(new PacketSendEternalDay(providerAether.getIsEternalDay()));
                providerAether.setShouldCycleCatchup(data.isShouldCycleCatchup());
                AetherNetwork.sendToAll(new PacketSendShouldCycle(providerAether.getShouldCycleCatchup()));
            }
        }
        for (Object entity : event.world.field_72996_f) {
            EntityItem entityItem;
            if (!(entity instanceof EntityItem) || (entityItem = (EntityItem)entity).func_92059_d().func_77973_b() != ItemsAether.dungeon_key) continue;
            ObfuscationReflectionHelper.setPrivateValue(Entity.class, (Object)entityItem, (Object)true, (String[])new String[]{"invulnerable", "field_83001_bt"});
        }
    }

    @SubscribeEvent
    public void onPlayerSleepInBed(PlayerWakeUpEvent event) {
        World world = event.entityPlayer.field_70170_p;
        if (!world.field_72995_K && event.entityPlayer.field_71093_bK == AetherConfig.getAetherDimensionID()) {
            MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
            WorldServer worldServer = server.func_71218_a(0);
            if (worldServer.field_73010_i.size() > 0) {
                if (worldServer.func_73056_e()) {
                    this.performTimeSet(event, world, worldServer);
                }
            } else {
                this.performTimeSet(event, world, worldServer);
            }
        }
    }

    @SubscribeEvent
    public void onFall(LivingFallEvent event) {
        PlayerAether playerAether;
        if (event.entityLiving instanceof EntityPlayer && ((playerAether = PlayerAether.get((EntityPlayer)event.entityLiving)).getAccessoryInventory().wearingArmor(new ItemStack(ItemsAether.sentry_boots)) || playerAether.getAccessoryInventory().isWearingGravititeSet() || playerAether.getAccessoryInventory().isWearingValkyrieSet())) {
            event.setCanceled(true);
        }
    }

    private void performTimeSet(PlayerWakeUpEvent event, World world, WorldServer worldServer) {
        if (world.func_82736_K().func_82766_b("doDaylightCycle") && event.entityPlayer.func_71026_bH()) {
            long i = worldServer.func_72912_H().func_76073_f() + 24000L;
            worldServer.func_72912_H().func_76068_b(i - i % 24000L);
            PlayerAether.get(event.entityPlayer).setBedLocation(event.entityPlayer.getBedLocation(AetherConfig.getAetherDimensionID()));
        }
    }
}

