/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.the_aether.client;

import com.gildedgames.the_aether.AetherConfig;
import com.gildedgames.the_aether.client.AetherKeybinds;
import com.gildedgames.the_aether.client.AetherMovementInput;
import com.gildedgames.the_aether.client.gui.AetherLoadingScreen;
import com.gildedgames.the_aether.client.gui.GuiCustomizationScreen;
import com.gildedgames.the_aether.client.gui.GuiEnterAether;
import com.gildedgames.the_aether.client.gui.button.GuiAccessoryButton;
import com.gildedgames.the_aether.client.gui.button.GuiCapeButton;
import com.gildedgames.the_aether.client.gui.button.GuiCustomizationScreenButton;
import com.gildedgames.the_aether.client.gui.inventory.GuiAccessories;
import com.gildedgames.the_aether.client.gui.menu.AetherMainMenu;
import com.gildedgames.the_aether.client.gui.menu.GuiMenuToggleButton;
import com.gildedgames.the_aether.client.renders.entity.PlayerAetherRenderer;
import com.gildedgames.the_aether.entities.EntitiesAether;
import com.gildedgames.the_aether.items.ItemAetherSpawnEgg;
import com.gildedgames.the_aether.items.ItemsAether;
import com.gildedgames.the_aether.items.armor.ItemAetherArmor;
import com.gildedgames.the_aether.network.AetherNetwork;
import com.gildedgames.the_aether.network.packets.PacketCapeChanged;
import com.gildedgames.the_aether.network.packets.PacketExtendedAttack;
import com.gildedgames.the_aether.network.packets.PacketOpenContainer;
import com.gildedgames.the_aether.player.PlayerAether;
import com.gildedgames.the_aether.player.perks.AetherRankings;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.ObfuscationReflectionHelper;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.InputEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.GuiDownloadTerrain;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiOptions;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScreenChatOptions;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiContainerCreative;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import org.lwjgl.input.Mouse;

public class AetherClientEvents {
    private static boolean wasInAether = false;
    private static final GuiAccessoryButton ACCESSORY_BUTTON = new GuiAccessoryButton(0, 0);
    private static final GuiMenuToggleButton MAIN_MENU_BUTTON = new GuiMenuToggleButton(0, 0);
    private static int previousSelectedTabIndex = -1;
    private static boolean shouldRemoveButton = false;

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) throws Exception {
        Minecraft mc = Minecraft.func_71410_x();
        TickEvent.Phase phase = event.phase;
        TickEvent.Type type = event.type;
        if (phase == TickEvent.Phase.END && type.equals((Object)TickEvent.Type.CLIENT)) {
            if (!AetherConfig.triviaDisabled() && !(mc.field_71461_s instanceof AetherLoadingScreen)) {
                mc.field_71461_s = new AetherLoadingScreen(mc);
            }
            if (mc.field_71439_g != null && !(mc.field_71439_g.field_71158_b instanceof AetherMovementInput)) {
                mc.field_71439_g.field_71158_b = new AetherMovementInput(mc, mc.field_71474_y);
            }
            this.handleExtendedReach(mc);
        }
        if (phase == TickEvent.Phase.START && type.equals((Object)TickEvent.Type.CLIENT) && (mc.field_71462_r == null || mc.field_71462_r.field_146291_p) && !mc.field_71439_g.func_71039_bw() && GameSettings.func_100015_a((KeyBinding)mc.field_71474_y.field_74322_I)) {
            this.sendPickupPacket(mc);
        }
    }

    private void handleExtendedReach(Minecraft mc) {
        ItemStack stack;
        EntityClientPlayerMP player = mc.field_71439_g;
        if (player != null && Mouse.getEventButton() == 0 && Mouse.getEventButtonState() && (stack = player.func_70694_bm()) != null && this.isValkyrieItem(stack.func_77973_b())) {
            Vec3 playerVision = player.func_70040_Z();
            AxisAlignedBB reachDistance = player.field_70121_D.func_72314_b(10.0, 10.0, 10.0);
            List locatedEntities = player.field_70170_p.func_72872_a(Entity.class, reachDistance);
            Entity found = null;
            double foundLen = 0.0;
            for (Object o : locatedEntities) {
                double dot;
                Vec3 vec;
                double len;
                Entity ent;
                if (o == player || !(ent = (Entity)o).func_70067_L() && !(ent instanceof EntityDragon) || (len = (vec = Vec3.func_72443_a((double)(ent.field_70165_t - player.field_70165_t), (double)(ent.field_70121_D.field_72338_b + (double)(ent.field_70131_O / 2.0f) - player.field_70163_u - (double)player.func_70047_e()), (double)(ent.field_70161_v - player.field_70161_v))).func_72433_c()) > 8.0 || (dot = playerVision.func_72430_b(vec = vec.func_72432_b())) < 1.0 - 0.125 / len || !player.func_70685_l(ent) || foundLen != 0.0 && !(len < foundLen)) continue;
                found = ent;
                foundLen = len;
            }
            if (found != null && player.field_70154_o != found) {
                stack.func_77972_a(1, (EntityLivingBase)player);
                AetherNetwork.sendToServer(new PacketExtendedAttack(found.func_145782_y()));
            }
        }
    }

    public boolean isValkyrieItem(Item stackID) {
        return stackID == ItemsAether.valkyrie_shovel || stackID == ItemsAether.valkyrie_axe || stackID == ItemsAether.valkyrie_pickaxe || stackID == ItemsAether.valkyrie_lance;
    }

    @SubscribeEvent
    public void onOpenGui(GuiOpenEvent event) {
        Minecraft mc = FMLClientHandler.instance().getClient();
        if (mc.field_71439_g != null && event.gui instanceof GuiDownloadTerrain) {
            GuiEnterAether enterAether = new GuiEnterAether(true);
            GuiEnterAether exitAether = new GuiEnterAether(false);
            if (mc.field_71439_g.field_71093_bK == AetherConfig.getAetherDimensionID()) {
                event.gui = enterAether;
                wasInAether = true;
            } else if (wasInAether) {
                event.gui = exitAether;
                wasInAether = false;
            }
        }
    }

    private void sendPickupPacket(Minecraft mc) {
        if (mc.field_71476_x != null) {
            if (!this.onPickEntity(mc.field_71476_x, (EntityPlayer)mc.field_71439_g, (World)mc.field_71441_e)) {
                return;
            }
            if (mc.field_71439_g.field_71075_bZ.field_75098_d) {
                int index = mc.field_71439_g.field_71069_bz.field_75151_b.size() - 9 + mc.field_71439_g.field_71071_by.field_70461_c;
                mc.field_71442_b.func_78761_a(mc.field_71439_g.field_71071_by.func_70301_a(mc.field_71439_g.field_71071_by.field_70461_c), index);
            }
        }
    }

    private boolean onPickEntity(MovingObjectPosition target, EntityPlayer player, World world) {
        int id;
        ItemStack result = null;
        boolean isCreative = player.field_71075_bZ.field_75098_d;
        if (!isCreative) {
            return false;
        }
        if (target.field_72308_g != null && (id = EntitiesAether.getEntityID(target.field_72308_g)) >= 0 && ItemAetherSpawnEgg.entityEggs.containsKey(id)) {
            result = new ItemStack(ItemsAether.aether_spawn_egg, 1, id);
        }
        if (result == null) {
            return false;
        }
        for (int x = 0; x < 9; ++x) {
            ItemStack stack = player.field_71071_by.func_70301_a(x);
            if (stack == null || !stack.func_77969_a(result) || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)result)) continue;
            player.field_71071_by.field_70461_c = x;
            return true;
        }
        int slot = player.field_71071_by.func_70447_i();
        if (slot < 0 || slot >= 9) {
            slot = player.field_71071_by.field_70461_c;
        }
        player.field_71071_by.func_70299_a(slot, result);
        player.field_71071_by.field_70461_c = slot;
        return true;
    }

    @SubscribeEvent
    public void onBowPulled(FOVUpdateEvent event) {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        if (player == null || player != null && player.func_71045_bC() == null) {
            return;
        }
        Item item = player.func_71045_bC().func_77973_b();
        if (item == ItemsAether.phoenix_bow) {
            int i = player.func_71057_bx();
            float f1 = (float)i / 20.0f;
            f1 = f1 > 1.0f ? 1.0f : (f1 *= f1);
            float original = event.fov;
            event.newfov = original *= 1.0f - f1 * 0.15f;
        }
    }

    @SubscribeEvent
    public void onGuiOpened(GuiScreenEvent.InitGuiEvent.Post event) {
        if (event.gui instanceof GuiContainer) {
            EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
            int guiLeft = (Integer)ObfuscationReflectionHelper.getPrivateValue(GuiContainer.class, (Object)((GuiContainer)event.gui), (String[])new String[]{"guiLeft", "field_147003_i"});
            int guiTop = (Integer)ObfuscationReflectionHelper.getPrivateValue(GuiContainer.class, (Object)((GuiContainer)event.gui), (String[])new String[]{"guiTop", "field_147009_r"});
            int xSize = (Integer)ObfuscationReflectionHelper.getPrivateValue(GuiContainer.class, (Object)((GuiContainer)event.gui), (String[])new String[]{"xSize", "field_146999_f"});
            int ySize = (Integer)ObfuscationReflectionHelper.getPrivateValue(GuiContainer.class, (Object)((GuiContainer)event.gui), (String[])new String[]{"ySize", "field_147000_g"});
            if (player.field_71075_bZ.field_75098_d) {
                if (event.gui instanceof GuiContainerCreative && ((GuiContainerCreative)event.gui).func_147056_g() == CreativeTabs.field_78036_m.func_78021_a()) {
                    event.buttonList.add(ACCESSORY_BUTTON.setPosition(guiLeft + 28, guiTop + 38));
                    previousSelectedTabIndex = CreativeTabs.field_78036_m.func_78021_a();
                }
            } else if (event.gui instanceof GuiInventory) {
                int xSizeOriginal = 176;
                int ySizeOriginal = 166;
                event.buttonList.add(ACCESSORY_BUTTON.setPosition((xSize - xSizeOriginal) / 2 + guiLeft + 26, (ySize - ySizeOriginal) / 2 + guiTop + 65));
            }
            if (event.gui instanceof GuiAccessories) {
                if (!shouldRemoveButton) {
                    event.buttonList.add(ACCESSORY_BUTTON.setPosition(guiLeft + 8, guiTop + 65));
                } else {
                    shouldRemoveButton = false;
                }
            }
        }
        if (AetherConfig.config.get("Misc", "Enables the Aether Menu toggle button", false).getBoolean() && event.gui instanceof GuiMainMenu) {
            event.buttonList.add(MAIN_MENU_BUTTON.setPosition(event.gui.field_146294_l - 24, 4));
        }
        if (AetherConfig.config.get("Misc", "Enables the Aether Menu", false).getBoolean() && event.gui.getClass() == GuiMainMenu.class) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new AetherMainMenu());
        }
        if (event.gui instanceof GuiOptions && Minecraft.func_71410_x().field_71439_g != null && AetherRankings.isRankedPlayer(Minecraft.func_71410_x().field_71439_g.func_110124_au())) {
            event.buttonList.add(new GuiCustomizationScreenButton(545, event.gui.field_146294_l / 2 - 155, event.gui.field_146295_m / 6 + 48 - 6, 150, 20, I18n.func_135052_a((String)"gui.options.perk_customization", (Object[])new Object[0])));
        }
        if (event.gui instanceof ScreenChatOptions && Minecraft.func_71410_x().field_71439_g != null) {
            int i = 13;
            event.buttonList.add(new GuiCapeButton(event.gui.field_146294_l / 2 - 155 + i % 2 * 160, event.gui.field_146295_m / 6 + 24 * (i >> 1)));
        }
    }

    @SubscribeEvent
    public void onMouseClicked(GuiScreenEvent.DrawScreenEvent.Post event) {
        GuiContainerCreative guiScreen;
        if (Minecraft.func_71410_x().field_71462_r instanceof GuiContainerCreative && previousSelectedTabIndex != (guiScreen = (GuiContainerCreative)Minecraft.func_71410_x().field_71462_r).func_147056_g()) {
            List buttonList = (List)ObfuscationReflectionHelper.getPrivateValue(GuiScreen.class, (Object)guiScreen, (int)4);
            if (guiScreen.func_147056_g() == CreativeTabs.field_78036_m.func_78021_a() && !buttonList.contains((Object)ACCESSORY_BUTTON)) {
                int guiLeft = (Integer)ObfuscationReflectionHelper.getPrivateValue(GuiContainer.class, (Object)guiScreen, (String[])new String[]{"guiLeft", "field_147003_i"});
                int guiTop = (Integer)ObfuscationReflectionHelper.getPrivateValue(GuiContainer.class, (Object)guiScreen, (String[])new String[]{"guiTop", "field_147009_r"});
                buttonList.add(ACCESSORY_BUTTON.setPosition(guiLeft + 28, guiTop + 38));
            } else if (previousSelectedTabIndex == CreativeTabs.field_78036_m.func_78021_a()) {
                buttonList.remove((Object)ACCESSORY_BUTTON);
            }
            previousSelectedTabIndex = guiScreen.func_147056_g();
        }
    }

    @SubscribeEvent
    public void onDrawGui(GuiScreenEvent.DrawScreenEvent.Pre event) {
        if (!AetherConfig.config.get("Misc", "Enables the Aether Menu", false).getBoolean() && event.gui instanceof AetherMainMenu) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiMainMenu());
        }
    }

    @SubscribeEvent
    public void onButtonPressed(GuiScreenEvent.ActionPerformedEvent.Pre event) {
        if ((event.gui instanceof GuiInventory || event.gui instanceof GuiContainerCreative) && event.button.field_146127_k == 18067) {
            AetherNetwork.sendToServer(new PacketOpenContainer(1));
        }
        if (event.button instanceof GuiCustomizationScreenButton) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiCustomizationScreen(event.gui));
        }
        if (event.button instanceof GuiCapeButton) {
            boolean enableCape;
            PlayerAether player = PlayerAether.get((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
            player.shouldRenderCape = enableCape = !player.shouldRenderCape;
            AetherNetwork.sendToServer(new PacketCapeChanged(player.getEntity().func_145782_y(), player.shouldRenderCape));
        }
    }

    @SubscribeEvent
    public void onRenderInvisibility(RenderPlayerEvent.Pre event) {
        EntityPlayer player = event.entityPlayer;
        PlayerAether playerAether = PlayerAether.get(player);
        if (playerAether != null && playerAether.getAccessoryInventory().wearingAccessory(new ItemStack(ItemsAether.invisibility_cape))) {
            event.setCanceled(true);
        }
        PlayerAetherRenderer.instance().setPartialTicks(event.partialRenderTick);
    }

    @SubscribeEvent
    public void onRenderAetherCape(RenderPlayerEvent.Specials.Pre event) {
        event.renderCape = !PlayerAetherRenderer.instance().isCapeRendering();
    }

    @SubscribeEvent
    public void onRenderAetherArmor(RenderPlayerEvent.SetArmorModel event) {
        if (event.stack != null && event.stack.func_77973_b() instanceof ItemAetherArmor) {
            event.result = PlayerAetherRenderer.instance().renderAetherArmor(PlayerAether.get(event.entityPlayer), event.renderer, event.stack, 3 - event.slot);
        }
    }

    @SubscribeEvent
    public void onRenderAccessories(RenderLivingEvent.Post event) {
        if (event.entity instanceof EntityPlayer) {
            PlayerAether playerAether = PlayerAether.get((EntityPlayer)event.entity);
            if (event.renderer instanceof RenderPlayer) {
                PlayerAetherRenderer.instance().renderAccessories(playerAether, (RenderPlayer)event.renderer, event.x, event.y, event.z, PlayerAetherRenderer.instance().getPartialTicks());
            }
        }
    }

    @SubscribeEvent
    public void onKeyInputEvent(InputEvent.KeyInputEvent event) {
        if (Minecraft.func_71410_x().field_71439_g != null && AetherKeybinds.keyBindingAccessories.func_151468_f() && Minecraft.func_71410_x().field_71462_r == null) {
            AetherNetwork.sendToServer(new PacketOpenContainer(1));
            shouldRemoveButton = true;
        }
    }
}

