/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.the_aether.entities;

import com.gildedgames.the_aether.Aether;
import com.gildedgames.the_aether.entities.block.EntityFloatingBlock;
import com.gildedgames.the_aether.entities.block.EntityTNTPresent;
import com.gildedgames.the_aether.entities.bosses.EntityFireMinion;
import com.gildedgames.the_aether.entities.bosses.EntityValkyrie;
import com.gildedgames.the_aether.entities.bosses.slider.EntitySlider;
import com.gildedgames.the_aether.entities.bosses.sun_spirit.EntitySunSpirit;
import com.gildedgames.the_aether.entities.bosses.valkyrie_queen.EntityValkyrieQueen;
import com.gildedgames.the_aether.entities.effects.PotionInebriation;
import com.gildedgames.the_aether.entities.hostile.EntityAechorPlant;
import com.gildedgames.the_aether.entities.hostile.EntityCockatrice;
import com.gildedgames.the_aether.entities.hostile.EntityMimic;
import com.gildedgames.the_aether.entities.hostile.EntitySentry;
import com.gildedgames.the_aether.entities.hostile.EntityWhirlwind;
import com.gildedgames.the_aether.entities.hostile.EntityZephyr;
import com.gildedgames.the_aether.entities.passive.EntityAerwhale;
import com.gildedgames.the_aether.entities.passive.EntityMiniCloud;
import com.gildedgames.the_aether.entities.passive.EntitySheepuff;
import com.gildedgames.the_aether.entities.passive.mountable.EntityAerbunny;
import com.gildedgames.the_aether.entities.passive.mountable.EntityFlyingCow;
import com.gildedgames.the_aether.entities.passive.mountable.EntityMoa;
import com.gildedgames.the_aether.entities.passive.mountable.EntityParachute;
import com.gildedgames.the_aether.entities.passive.mountable.EntityPhyg;
import com.gildedgames.the_aether.entities.passive.mountable.EntitySwet;
import com.gildedgames.the_aether.entities.projectile.EntityHammerProjectile;
import com.gildedgames.the_aether.entities.projectile.EntityLightningKnife;
import com.gildedgames.the_aether.entities.projectile.EntityPhoenixArrow;
import com.gildedgames.the_aether.entities.projectile.EntityPoisonNeedle;
import com.gildedgames.the_aether.entities.projectile.EntityZephyrSnowball;
import com.gildedgames.the_aether.entities.projectile.crystals.EntityCrystal;
import com.gildedgames.the_aether.entities.projectile.darts.EntityDartEnchanted;
import com.gildedgames.the_aether.entities.projectile.darts.EntityDartGolden;
import com.gildedgames.the_aether.entities.projectile.darts.EntityDartPoison;
import com.gildedgames.the_aether.entities.util.AetherMoaTypes;
import com.gildedgames.the_aether.entities.util.EntityAetherItem;
import com.gildedgames.the_aether.items.ItemAetherSpawnEgg;
import cpw.mods.fml.common.registry.EntityRegistry;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EntitiesAether {
    public static Map<Class<?>, String> classToStringMapping = new HashMap();
    public static Map<Integer, Class<?>> IDtoClassMapping = new HashMap();
    private static Map<Class<?>, Integer> classToIDMapping = new HashMap();
    private static Map<String, Integer> stringToIDMapping = new HashMap<String, Integer>();
    private static final Logger logger = LogManager.getLogger();

    public static void initialization() {
        EntitiesAether.register(EntityMoa.class, "moa", 0, 8896495, 0x7A7A7A);
        EntitiesAether.register(EntityPhyg.class, "phyg", 1, 16761296, 16767289);
        EntitiesAether.register(EntityFlyingCow.class, "flying_cow", 2, 0xD8D8D8, 16767289);
        EntitiesAether.register(EntitySheepuff.class, "sheepuff", 3, 14875903, 13340816);
        EntitiesAether.register(EntityAerbunny.class, "aerbunny", 4, 14875903, 0xFFDFF9);
        EntitiesAether.register(EntityAerwhale.class, "aerwhale", 5, 7976913, 14733916);
        EntitiesAether.register(EntitySwet.class, "swet", 6, 13490767, 5222874);
        EntitiesAether.register(EntityCockatrice.class, "cockatrice", 7, 7123292, 7100317);
        EntitiesAether.register(EntitySentry.class, "sentry", 8, 8621210, 2449850);
        EntitiesAether.register(EntityZephyr.class, "zephyr", 9, 0xDFDFDF, 10080232);
        EntitiesAether.register(EntityAechorPlant.class, "aechor_plant", 10, 483704, 4966046);
        EntitiesAether.register(EntityMimic.class, "mimic", 11, 11632946, 6314574);
        EntitiesAether.register(EntitySlider.class, "slider", 12, 80, 3, true);
        EntitiesAether.register(EntityValkyrieQueen.class, "valkyrie_queen", 13, 80, 3, true);
        EntitiesAether.register(EntitySunSpirit.class, "sun_spirit", 14, 80, 3, true);
        EntitiesAether.register(EntityDartGolden.class, "golden_dart", 15, 64, 20, false);
        EntitiesAether.register(EntityDartPoison.class, "poison_dart", 16, 64, 20, false);
        EntitiesAether.register(EntityDartEnchanted.class, "enchanted_dart", 17, 64, 20, false);
        EntitiesAether.register(EntityPoisonNeedle.class, "poison_needle", 18, 64, 20, false);
        EntitiesAether.register(EntityCrystal.class, "crystal", 19, 64, 4, false);
        EntitiesAether.register(EntityWhirlwind.class, "whirlwind", 20, 80, 3, false);
        EntitiesAether.register(EntityValkyrie.class, "valkyrie", 22, 80, 3, true);
        EntitiesAether.register(EntityFireMinion.class, "fire_minion", 23, 80, 3, true);
        EntitiesAether.register(EntityMiniCloud.class, "mini_cloud", 24, 80, 3, false);
        EntitiesAether.register(EntityFloatingBlock.class, "floating_block", 25, 160, 20, true);
        EntitiesAether.register(EntityTNTPresent.class, "tnt_present", 26, 160, 20, true);
        EntitiesAether.register(EntityPhoenixArrow.class, "phoenix_arrow", 27, 64, 20, false);
        EntitiesAether.register(EntityZephyrSnowball.class, "zephyr_snowball", 28, 64, 20, false);
        EntitiesAether.register(EntityHammerProjectile.class, "hammer_projectile", 29, 64, 20, false);
        EntitiesAether.register(EntityLightningKnife.class, "lightning_knife", 30, 64, 10, true);
        EntitiesAether.register(EntityParachute.class, "parachute", 31, 160, 20, true);
        EntitiesAether.register(EntityAetherItem.class, "aether_item", 32, 160, 20, true);
        AetherMoaTypes.initialization();
        PotionInebriation.initialization();
    }

    public static void register(Class<? extends Entity> entityClass, String entityName, int entityID, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates) {
        EntityRegistry.registerModEntity(entityClass, (String)entityName, (int)entityID, (Object)Aether.instance, (int)trackingRange, (int)updateFrequency, (boolean)sendsVelocityUpdates);
    }

    public static void register(Class<? extends Entity> entityClass, String entityName, int entityID, int primaryEggColor, int secondaryEggColor) {
        EntitiesAether.addMapping(entityClass, entityName, entityID, primaryEggColor, secondaryEggColor);
        EntityRegistry.registerModEntity(entityClass, (String)entityName, (int)entityID, (Object)Aether.instance, (int)80, (int)3, (boolean)true);
    }

    private static void addMapping(Class<?> entityClass, String entityName, int entityID, int primaryEggColor, int secondaryEggColor) {
        if (IDtoClassMapping.containsKey(entityID)) {
            throw new IllegalArgumentException("ID is already registered: " + entityID);
        }
        classToStringMapping.put(entityClass, entityName);
        IDtoClassMapping.put(entityID, entityClass);
        classToIDMapping.put(entityClass, entityID);
        stringToIDMapping.put(entityName, entityID);
        ItemAetherSpawnEgg.entityEggs.put(entityID, new AetherEggInfo(entityID, primaryEggColor, secondaryEggColor));
    }

    public static Entity createEntityByID(int id, World p_75616_1_) {
        Entity entity = null;
        try {
            Class<?> oclass = EntitiesAether.getClassFromID(id);
            if (oclass != null) {
                entity = (Entity)oclass.getConstructor(World.class).newInstance(p_75616_1_);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (entity == null) {
            logger.warn("Skipping Aether Entity with id " + id);
        }
        return entity;
    }

    public static int getEntityID(Entity p_75619_0_) {
        Class<?> oclass = p_75619_0_.getClass();
        return classToIDMapping.containsKey(oclass) ? classToIDMapping.get(oclass) : -1;
    }

    public static Class<?> getClassFromID(int p_90035_0_) {
        return IDtoClassMapping.get(p_90035_0_);
    }

    public static String getStringFromID(int p_75617_0_) {
        Class<?> oclass = EntitiesAether.getClassFromID(p_75617_0_);
        return oclass != null ? classToStringMapping.get(oclass) : null;
    }

    public static class AetherEggInfo {
        public final int spawnedID;
        public final int primaryColor;
        public final int secondaryColor;

        public AetherEggInfo(int spawnedID, int primaryColor, int secondaryColor) {
            this.spawnedID = spawnedID;
            this.primaryColor = primaryColor;
            this.secondaryColor = secondaryColor;
        }
    }
}

