/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.the_aether.entities.hostile;

import com.gildedgames.the_aether.AetherConfig;
import com.gildedgames.the_aether.entities.passive.mountable.EntityMoa;
import com.gildedgames.the_aether.entities.projectile.EntityPoisonNeedle;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class EntityCockatrice
extends EntityMob {
    public float wingRotation;
    public float destPos;
    public float prevDestPos;
    public float prevWingRotation;
    public int shootTime;
    public int ticksUntilFlap;

    public EntityCockatrice(World world) {
        super(world);
        this.field_70138_W = 1.0f;
        this.func_70105_a(1.0f, 2.0f);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMoveTowardsTarget((EntityCreature)this, 1.0, 8.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(35.0);
        this.func_70606_j(10.0f);
    }

    public boolean func_70601_bi() {
        return this.field_70146_Z.nextInt(AetherConfig.getCockatriceSpawnrate()) == 0 && super.func_70601_bi();
    }

    public boolean func_70687_e(PotionEffect effect) {
        return effect.func_76456_a() == Potion.field_76436_u.field_76415_H ? false : super.func_70687_e(effect);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_70777_m() != null) {
            if (this.func_70638_az() instanceof EntityPlayer && ((EntityPlayer)this.func_70638_az()).field_71075_bZ.field_75098_d) {
                this.func_70624_b(null);
            } else {
                double d = this.func_70777_m().field_70165_t - this.field_70165_t;
                double d1 = this.func_70777_m().field_70161_v - this.field_70161_v;
                this.func_70671_ap().func_75651_a(this.func_70777_m(), 30.0f, 30.0f);
                if (this.shootTime >= 20 && this.func_70685_l(this.func_70777_m())) {
                    this.shootTarget();
                    this.shootTime = -60;
                }
                if (this.shootTime < 20) {
                    this.shootTime += 2;
                }
                this.field_70177_z = (float)(Math.atan2(d1, d) * 180.0 / 3.1415927410125732) - 90.0f;
            }
        }
        this.updateWingRotation();
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.field_73013_u == EnumDifficulty.PEACEFUL) {
            this.func_70106_y();
        }
    }

    public void shootTarget() {
        if (this.field_70170_p.field_73013_u == EnumDifficulty.PEACEFUL) {
            return;
        }
        EntityPoisonNeedle entityarrow = new EntityPoisonNeedle(this.field_70170_p, (EntityLiving)this, 1.0f);
        this.func_85030_a("random.bow", 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
        this.field_70170_p.func_72838_d((Entity)entityarrow);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70122_E && this.field_70181_x < 0.0) {
            this.field_70181_x *= 0.6;
        }
    }

    public void updateWingRotation() {
        if (!this.field_70122_E) {
            if (this.ticksUntilFlap == 0) {
                this.field_70170_p.func_72956_a((Entity)this, "mob.bat.takeoff", 0.15f, MathHelper.func_76131_a((float)this.field_70146_Z.nextFloat(), (float)0.7f, (float)1.0f) + MathHelper.func_76131_a((float)this.field_70146_Z.nextFloat(), (float)0.0f, (float)0.3f));
                this.ticksUntilFlap = 8;
            } else {
                --this.ticksUntilFlap;
            }
        }
        this.prevWingRotation = this.wingRotation;
        this.prevDestPos = this.destPos;
        this.destPos = (float)((double)this.destPos + 0.2);
        this.destPos = EntityMoa.minMax(0.01f, 1.0f, this.destPos);
        if (this.field_70122_E) {
            this.destPos = 0.0f;
        }
        this.wingRotation += 1.233f;
    }

    public void func_70069_a(float distance) {
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.func_76346_g() != null && source.func_76346_g() instanceof EntityLivingBase) {
            this.func_70624_b((EntityLivingBase)source.func_76346_g());
        }
        return super.func_70097_a(source, amount);
    }

    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
    }

    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
    }

    protected String func_70639_aQ() {
        return "aether_legacy:aemob.moa.say";
    }

    protected String func_70621_aR() {
        return "aether_legacy:aemob.moa.say";
    }

    protected String func_70673_aS() {
        return "aether_legacy:aemob.moa.say";
    }

    protected void func_70628_a(boolean var1, int var2) {
        this.func_145779_a(Items.field_151008_G, 1 + this.field_70146_Z.nextInt(4));
    }
}

