/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.the_aether.entities.passive.mountable;

import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class EntityParachute
extends Entity
implements IEntityAdditionalSpawnData {
    private EntityPlayer ridingPlayer;
    public boolean isGoldenParachute;

    public EntityParachute(World world) {
        super(world);
        this.func_70105_a(1.0f, 1.0f);
    }

    public EntityParachute(World world, EntityPlayer player, boolean isGolden) {
        this(world);
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        this.ridingPlayer = player;
        this.isGoldenParachute = isGolden;
        this.moveToEntityUsing();
        this.spawnExplosionParticle();
    }

    protected void func_70088_a() {
    }

    public void spawnExplosionParticle() {
        if (this.field_70170_p.field_72995_K) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            double d3 = 10.0;
            this.field_70170_p.func_72869_a("explode", this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N - d0 * d3, this.field_70163_u - 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O) - d1 * d3, this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N - d2 * d3, d0, d1, d2);
        } else {
            this.field_70170_p.func_72960_a((Entity)this, (byte)20);
        }
    }

    public void func_70071_h_() {
        if (this.field_70128_L || this.ridingPlayer == null) {
            this.func_70106_y();
            return;
        }
        if (this.field_70163_u < 0.0) {
            this.func_70106_y();
            return;
        }
        if (this.ridingPlayer != null) {
            if (this.ridingPlayer.field_70181_x < -0.25) {
                this.ridingPlayer.field_70181_x = -0.25;
            }
            this.ridingPlayer.field_70143_R = 0.0f;
            this.moveToEntityUsing();
            this.spawnExplosionParticle();
        }
    }

    private void moveToEntityUsing() {
        this.func_70080_a(this.ridingPlayer.field_70165_t, this.ridingPlayer.field_70121_D.field_72338_b - (double)(this.field_70131_O / 2.0f) - 0.5, this.ridingPlayer.field_70161_v, this.ridingPlayer.field_70177_z, this.ridingPlayer.field_70125_A);
        this.field_70159_w = this.ridingPlayer.field_70159_w;
        this.field_70181_x = this.ridingPlayer.field_70181_x;
        this.field_70179_y = this.ridingPlayer.field_70179_y;
        this.field_70177_z = this.ridingPlayer.field_70177_z;
        if (this.isCollided()) {
            this.die();
        }
    }

    private boolean isCollided() {
        int size = 0;
        List list = this.field_70170_p.func_72945_a((Entity)this, this.field_70121_D);
        if (size < list.size()) {
            if (size == 0 && list.size() == 0) {
                return false;
            }
            AxisAlignedBB collision_list = (AxisAlignedBB)list.get(size);
            return collision_list != this.ridingPlayer.field_70121_D;
        }
        return this.field_70170_p.func_72830_b(this.field_70121_D, Material.field_151586_h);
    }

    public void func_70100_b_(EntityPlayer entityplayer) {
    }

    public void die() {
        if (this.ridingPlayer != null) {
            this.spawnExplosionParticle();
        }
        this.ridingPlayer = null;
        this.field_70128_L = true;
    }

    public static boolean entityHasRoomForCloud(World world, EntityPlayer player) {
        AxisAlignedBB boundingBox = player.field_70121_D;
        return world.func_72945_a((Entity)player, boundingBox).size() == 0 && !world.func_72830_b(boundingBox, Material.field_151586_h);
    }

    public boolean func_70112_a(double d) {
        if (this.ridingPlayer != null) {
            return this.ridingPlayer.func_70112_a(d);
        }
        return super.func_70112_a(d);
    }

    public boolean func_70067_L() {
        return true;
    }

    protected void func_70037_a(NBTTagCompound compound) {
    }

    protected void func_70014_b(NBTTagCompound compound) {
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeBoolean(this.isGoldenParachute);
        buffer.writeInt(this.ridingPlayer.func_145782_y());
    }

    public void readSpawnData(ByteBuf buffer) {
        this.isGoldenParachute = buffer.readBoolean();
        this.ridingPlayer = (EntityPlayer)this.field_70170_p.func_73045_a(buffer.readInt());
    }
}

