/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.the_aether.entities.passive.mountable;

import com.gildedgames.the_aether.AetherConfig;
import com.gildedgames.the_aether.entities.util.EntitySaddleMount;
import com.gildedgames.the_aether.items.ItemsAether;
import com.gildedgames.the_aether.registry.achievements.AchievementsAether;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.world.World;

public class EntityPhyg
extends EntitySaddleMount {
    public float wingFold;
    public float wingAngle;
    private float aimingForFold;
    public int maxJumps = 1;
    public int jumpsRemaining = 0;
    public int ticks;

    public EntityPhyg(World world) {
        super(world);
        this.field_70138_W = 1.0f;
        this.field_70158_ak = true;
        this.canJumpMidAir = true;
        this.func_70105_a(0.9f, 1.3f);
        this.func_70661_as().func_75491_a(true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 1.25));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.25, ItemsAether.blueberry, false));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIFollowParent((EntityAnimal)this, 1.1));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
    }

    public boolean func_70601_bi() {
        return this.field_70146_Z.nextInt(AetherConfig.getPhygSpawnrate()) == 0 && super.func_70601_bi();
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.isOnGround()) {
            this.wingAngle *= 0.8f;
            this.aimingForFold = 0.1f;
            this.jumpsRemaining = this.maxJumps;
        } else {
            this.aimingForFold = 1.0f;
        }
        if (this.field_70153_n instanceof EntityPlayer) {
            ((EntityPlayer)this.field_70153_n).func_71029_a((StatBase)AchievementsAether.flying_pig);
        }
        ++this.ticks;
        this.wingAngle = this.wingFold * (float)Math.sin((float)this.ticks / 31.830988f);
        this.wingFold += (this.aimingForFold - this.wingFold) / 5.0f;
        this.field_70143_R = 0.0f;
        this.fall();
    }

    protected String func_70639_aQ() {
        return "mob.pig.say";
    }

    protected String func_70621_aR() {
        return "mob.pig.say";
    }

    protected String func_70673_aS() {
        return "mob.pig.death";
    }

    public double func_70042_X() {
        return 0.65;
    }

    @Override
    public float getMountedMoveSpeed() {
        return 0.3f;
    }

    protected void func_70664_aZ() {
        if (this.field_70153_n == null) {
            super.func_70664_aZ();
        }
    }

    @Override
    protected void func_70628_a(boolean recentlyHit, int lootLevel) {
        int k;
        int j = this.field_70146_Z.nextInt(3) + 1 + this.field_70146_Z.nextInt(1 + lootLevel);
        for (k = 0; k < j; ++k) {
            this.func_145779_a(Items.field_151008_G, 1);
        }
        for (k = 0; k < j; ++k) {
            if (this.func_70027_ad()) {
                this.func_145779_a(Items.field_151157_am, 1);
                continue;
            }
            this.func_145779_a(Items.field_151147_al, 1);
        }
        super.func_70628_a(recentlyHit, lootLevel);
    }

    private void fall() {
        if (this.field_70181_x < 0.0 && !this.isRiderSneaking()) {
            this.field_70181_x *= 0.6;
        }
        if (!this.isOnGround() && !this.field_70703_bu && this.isOnGround() && !this.field_70170_p.field_72995_K) {
            this.jumpsRemaining = this.maxJumps;
        }
    }

    @Override
    protected double getMountJumpStrength() {
        return 5.0;
    }

    @Override
    protected void func_145780_a(int p_145780_1_, int p_145780_2_, int p_145780_3_, Block p_145780_4_) {
        this.func_85030_a("mob.pig.step", 0.15f, 1.0f);
    }

    @Override
    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.maxJumps = nbttagcompound.func_74765_d("Jumps");
        this.jumpsRemaining = nbttagcompound.func_74765_d("Remaining");
    }

    @Override
    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74777_a("Jumps", (short)this.maxJumps);
        nbttagcompound.func_74777_a("Remaining", (short)this.jumpsRemaining);
    }

    public EntityAgeable func_90011_a(EntityAgeable entityageable) {
        return new EntityPhyg(this.field_70170_p);
    }
}

