/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.the_aether.entities.passive.mountable;

import com.gildedgames.the_aether.AetherConfig;
import com.gildedgames.the_aether.api.AetherAPI;
import com.gildedgames.the_aether.api.player.IPlayerAether;
import com.gildedgames.the_aether.blocks.BlocksAether;
import com.gildedgames.the_aether.entities.hostile.swet.EnumSwetType;
import com.gildedgames.the_aether.entities.util.EntityMountable;
import com.gildedgames.the_aether.items.ItemsAether;
import com.gildedgames.the_aether.network.AetherNetwork;
import com.gildedgames.the_aether.network.packets.PacketSwetJump;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class EntitySwet
extends EntityMountable {
    public boolean wasOnGround;
    public boolean midJump;
    public int jumpTimer;
    public float swetHeight;
    public float swetWidth;
    private int jumpDelay;
    private int jumps = 0;
    private float chosenDegrees;

    public EntitySwet(World world) {
        super(world);
        this.func_70105_a(0.8f, 0.8f);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.swetHeight = 1.0f;
        this.swetWidth = 1.0f;
    }

    @Override
    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(21, (Object)((byte)this.field_70146_Z.nextInt(EnumSwetType.values().length)));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(1.5);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(25.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(25.0);
        this.func_70606_j(25.0f);
    }

    protected void func_82167_n(Entity entityIn) {
        super.func_82167_n(entityIn);
        if (!this.hasPrey() && entityIn instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityIn;
            if (this.func_70638_az() != null && this.func_70638_az() == player && !player.field_71075_bZ.field_75098_d) {
                this.capturePrey((EntityPlayer)entityIn);
            }
        }
    }

    public boolean func_70085_c(EntityPlayer player) {
        if (!this.field_70170_p.field_72995_K && !this.hasPrey() && this.isPlayerFriendly(player)) {
            this.capturePrey(player);
        }
        return true;
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (this.func_70638_az() instanceof EntityPlayer && (this.isPlayerFriendly((EntityPlayer)this.func_70638_az()) || this.isFriendly())) {
            this.func_70624_b(null);
        }
    }

    public void capturePrey(EntityPlayer entity) {
        this.field_70170_p.func_72980_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, "mob.attack", 0.5f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f, false);
        this.field_70169_q = this.field_70165_t = entity.field_70165_t;
        this.field_70167_r = this.field_70163_u = entity.field_70163_u + 0.01;
        this.field_70166_s = this.field_70161_v = entity.field_70161_v;
        this.field_70126_B = this.field_70177_z = entity.field_70177_z;
        this.field_70127_C = this.field_70125_A = entity.field_70125_A;
        this.field_70159_w = entity.field_70159_w;
        this.field_70181_x = entity.field_70181_x;
        this.field_70179_y = entity.field_70179_y;
        this.func_70105_a(entity.field_70130_N, entity.field_70131_O);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        entity.func_70078_a((Entity)this);
        this.field_70177_z = this.field_70146_Z.nextFloat() * 360.0f;
    }

    @Override
    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.field_73013_u == EnumDifficulty.PEACEFUL) {
            this.field_70128_L = true;
        }
        if (this.func_70072_I()) {
            this.dissolveSwet();
        }
        super.func_70071_h_();
        if (!this.hasPrey()) {
            for (int i = 0; i < 5; ++i) {
                double d = (float)this.field_70165_t + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.3f;
                double d1 = (float)this.field_70163_u + this.field_70131_O;
                double d2 = (float)this.field_70161_v + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.3f;
                this.field_70170_p.func_72869_a("splash", d, d1 - 0.25, d2, 0.0, 0.0, 0.0);
            }
        }
        if (this.field_70122_E && !this.wasOnGround) {
            this.field_70170_p.func_72980_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, "mob.slime.small", 0.5f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f, false);
        }
        if (!this.field_70170_p.field_72995_K) {
            this.midJump = !this.field_70122_E;
            AetherNetwork.sendToAll(new PacketSwetJump(this.func_145782_y(), !this.field_70122_E));
        }
        if (this.field_70170_p.field_72995_K) {
            this.jumpTimer = this.midJump ? ++this.jumpTimer : 0;
            if (this.field_70122_E) {
                this.swetHeight = this.swetHeight < 1.0f ? (this.swetHeight = this.swetHeight + 0.25f) : 1.0f;
                this.swetWidth = this.swetWidth > 1.0f ? (this.swetWidth = this.swetWidth - 0.25f) : 1.0f;
            } else {
                this.swetHeight = 1.425f;
                this.swetWidth = 0.875f;
                if (this.getJumpTimer() > 3) {
                    float scale = Math.min(this.getJumpTimer(), 10);
                    this.swetHeight -= 0.05f * scale;
                    this.swetWidth += 0.05f * scale;
                }
            }
        }
        this.wasOnGround = this.field_70122_E;
    }

    @Override
    public void func_70612_e(float strafe, float forward) {
        EntityPlayer rider;
        IPlayerAether aetherRider;
        if (this.hasPrey() && this.isFriendly() && (aetherRider = AetherAPI.get(rider = (EntityPlayer)this.field_70153_n)).isJumping() && this.field_70122_E) {
            this.func_70664_aZ();
            this.field_70122_E = false;
            this.field_70181_x = 1.0;
        }
        super.func_70612_e(strafe, forward);
    }

    protected void func_70626_be() {
        this.func_70623_bb();
        EntityPlayer entityplayer = this.field_70170_p.func_72856_b((Entity)this, 25.0);
        if (!(entityplayer == null || !entityplayer.func_70089_S() || entityplayer.field_71075_bZ.field_75102_a || this.isPlayerFriendly(entityplayer) || this.isFriendly() || this.hasPrey())) {
            this.func_70624_b((EntityLivingBase)entityplayer);
            this.func_70625_a((Entity)entityplayer, 10.0f, 20.0f);
        }
        if (this.field_70122_E && this.jumpDelay-- <= 0) {
            this.jumpDelay = this.getJumpDelay();
            if (entityplayer != null) {
                this.jumpDelay /= 3;
            }
            this.field_70703_bu = true;
            this.func_85030_a(this.getJumpSound(), this.func_70599_aP(), ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f) * 0.8f);
            this.field_70702_br = 1.0f - this.field_70146_Z.nextFloat() * 2.0f;
            this.field_70701_bs = 1.0f;
        } else {
            this.field_70703_bu = false;
            if (this.field_70122_E) {
                this.field_70701_bs = 0.0f;
                this.field_70702_br = 0.0f;
            }
        }
        if (this.hasPrey() && this.field_70153_n instanceof EntityPlayer && !this.isPlayerFriendly((EntityPlayer)this.field_70153_n) && this.jumps <= 3) {
            if (this.field_70122_E) {
                this.func_85030_a("mob.slime.small", 1.0f, ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f) * 0.8f);
                this.chosenDegrees = this.field_70146_Z.nextInt(360);
                if (this.jumps == 0) {
                    this.field_70181_x += 0.6499999940395356;
                } else if (this.jumps == 1) {
                    this.field_70181_x += 0.7499999880790711;
                } else if (this.jumps == 2) {
                    this.field_70181_x += 1.55;
                } else {
                    if (this.field_70153_n instanceof EntityPlayer) {
                        ((EntityPlayer)this.field_70153_n).func_110145_l((Entity)this);
                    }
                    this.dissolveSwet();
                }
                if (!this.midJump) {
                    ++this.jumps;
                }
            }
            if (!this.wasOnGround && this.getJumpTimer() < 6) {
                if (this.jumps == 1) {
                    this.moveXY(0.0f, 0.2f, this.chosenDegrees);
                } else if (this.jumps == 2) {
                    this.moveXY(0.0f, 0.3f, this.chosenDegrees);
                } else if (this.jumps == 3) {
                    this.moveXY(0.0f, 0.6f, this.chosenDegrees);
                }
            }
        }
    }

    public void moveXY(float strafe, float forward, float rotation) {
        float f = strafe * strafe + forward * forward;
        if ((f = MathHelper.func_76129_c((float)f)) < 1.0f) {
            f = 1.0f;
        }
        float f1 = MathHelper.func_76126_a((float)(rotation * ((float)Math.PI / 180)));
        float f2 = MathHelper.func_76134_b((float)(rotation * ((float)Math.PI / 180)));
        this.field_70159_w += (double)((strafe *= f) * f2 - (forward *= f) * f1);
        this.field_70179_y += (double)(forward * f2 + strafe * f1);
    }

    public void func_70069_a(float distance) {
        if (!this.isFriendly()) {
            super.func_70069_a(distance);
        }
    }

    protected void func_70664_aZ() {
        this.field_70181_x = 0.42f;
        this.field_70160_al = true;
    }

    public int getJumpTimer() {
        return this.jumpTimer;
    }

    public int getJumpDelay() {
        if (this.isFriendly()) {
            return 2;
        }
        return this.field_70146_Z.nextInt(20) + 10;
    }

    public int func_70646_bf() {
        return 0;
    }

    public void func_70653_a(Entity entityIn, float strength, double xRatio, double zRatio) {
        if (!this.hasPrey()) {
            super.func_70653_a(entityIn, strength, xRatio, zRatio);
        }
    }

    public boolean hasPrey() {
        return this.field_70153_n != null;
    }

    public boolean isPlayerFriendly(EntityPlayer player) {
        IPlayerAether iPlayerAether = AetherAPI.get(player);
        return iPlayerAether.getAccessoryInventory().wearingAccessory(new ItemStack(ItemsAether.swet_cape));
    }

    public boolean isFriendly() {
        return this.hasPrey() && this.field_70153_n instanceof EntityPlayer && this.isPlayerFriendly((EntityPlayer)this.field_70153_n);
    }

    public void dissolveSwet() {
        for (int i = 0; i < 50; ++i) {
            float f = this.field_70146_Z.nextFloat() * 3.141593f * 2.0f;
            float f1 = this.field_70146_Z.nextFloat() * 0.5f + 0.25f;
            float f2 = MathHelper.func_76126_a((float)f) * f1;
            float f3 = MathHelper.func_76134_b((float)f) * f1;
            this.field_70170_p.func_72869_a("splash", this.field_70165_t + (double)f2, this.field_70121_D.field_72338_b + 1.25, this.field_70161_v + (double)f3, (double)f2 * 1.5 + this.field_70159_w, 4.0, (double)f3 * 1.5 + this.field_70179_y);
        }
        if (this.func_70673_aS() != null) {
            this.func_85030_a(this.func_70673_aS(), this.func_70599_aP(), this.func_70647_i());
        }
        this.func_70106_y();
    }

    public float func_70047_e() {
        return 0.625f * this.field_70131_O;
    }

    protected void func_70628_a(boolean recentlyHit, int lootLevel) {
        int count = this.field_70146_Z.nextInt(2);
        if (lootLevel > 0) {
            count += this.field_70146_Z.nextInt(lootLevel + 1);
        }
        if (this.getType() == EnumSwetType.GOLDEN) {
            this.func_70099_a(new ItemStack(Blocks.field_150426_aN, count), 1.0f);
        } else {
            this.func_70099_a(new ItemStack(BlocksAether.aercloud, count, 1), 1.0f);
            this.func_70099_a(new ItemStack(ItemsAether.swet_ball, count), 1.0f);
        }
    }

    protected float func_70599_aP() {
        return 0.6f;
    }

    public EntityAgeable func_90011_a(EntityAgeable entityageable) {
        return null;
    }

    protected String getJumpSound() {
        return "mob.slime.small";
    }

    protected String func_70621_aR() {
        return "mob.slime.small";
    }

    protected String func_70673_aS() {
        return "mob.slime.small";
    }

    public EnumSwetType getType() {
        byte id = this.field_70180_af.func_75683_a(21);
        return EnumSwetType.get(id);
    }

    public void setType(int id) {
        this.field_70180_af.func_75692_b(21, (Object)((byte)id));
    }

    public boolean func_70601_bi() {
        return this.field_70146_Z.nextInt(AetherConfig.getSwetSpawnrate()) == 0 && super.func_70601_bi();
    }

    public int func_70641_bl() {
        return 3;
    }

    public boolean func_70692_ba() {
        return this.isFriendly();
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("SwetType", this.getType().getId());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setType(compound.func_74762_e("SwetType"));
    }
}

