/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.the_aether.entities.projectile.darts;

import cpw.mods.fml.common.registry.IThrowableEntity;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S2BPacketChangeGameState;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class EntityDartBase
extends EntityArrow
implements IProjectile,
IThrowableEntity {
    private int tileX = -1;
    private int tileY = -1;
    private int tileZ = -1;
    private Block inTile;
    private int inData;
    private boolean wasInGround;
    private boolean inGround;
    public int dartShake;
    private int ticksInGround;
    private int ticksInAir;
    private double damage = 2.0;
    private float gravityVelocity;

    public EntityDartBase(World world) {
        super(world);
        this.field_70155_l = 10.0;
        this.func_70105_a(0.5f, 0.5f);
    }

    public EntityDartBase(World world, double x, double y, double z) {
        super(world);
        this.field_70155_l = 10.0;
        this.func_70105_a(0.5f, 0.5f);
        this.func_70107_b(x, y, z);
        this.field_70129_M = 0.0f;
    }

    public EntityDartBase(World world, EntityLivingBase shooter, EntityLivingBase target, float velocity, float inaccuracy) {
        super(world);
        this.field_70155_l = 10.0;
        this.field_70250_c = shooter;
        if (shooter instanceof EntityPlayer) {
            this.field_70251_a = 1;
        }
        this.field_70163_u = shooter.field_70163_u + (double)shooter.func_70047_e() - (double)0.1f;
        double d0 = target.field_70165_t - shooter.field_70165_t;
        double d1 = target.field_70121_D.field_72338_b + (double)(target.field_70131_O / 3.0f) - this.field_70163_u;
        double d2 = target.field_70161_v - shooter.field_70161_v;
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        if (d3 >= 1.0E-7) {
            float f2 = (float)(Math.atan2(d2, d0) * 180.0 / Math.PI) - 90.0f;
            float f3 = (float)(-(Math.atan2(d1, d3) * 180.0 / Math.PI));
            double d4 = d0 / d3;
            double d5 = d2 / d3;
            this.func_70012_b(shooter.field_70165_t + d4, this.field_70163_u, shooter.field_70161_v + d5, f2, f3);
            this.field_70129_M = 0.0f;
            float f4 = (float)d3 * 0.2f;
            this.func_70186_c(d0, d1 + (double)f4, d2, velocity, inaccuracy);
        }
    }

    public EntityDartBase(World world, EntityLivingBase shooter, float velocity) {
        super(world);
        this.field_70155_l = 10.0;
        this.field_70250_c = shooter;
        if (shooter instanceof EntityPlayer) {
            this.field_70251_a = 1;
        }
        this.func_70105_a(0.5f, 0.5f);
        this.func_70012_b(shooter.field_70165_t, shooter.field_70163_u + (double)shooter.func_70047_e(), shooter.field_70161_v, shooter.field_70177_z, shooter.field_70125_A);
        this.field_70165_t -= (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        this.field_70163_u -= (double)0.1f;
        this.field_70161_v -= (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.field_70129_M = 0.0f;
        this.field_70159_w = -MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.field_70179_y = MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.field_70181_x = -MathHelper.func_76126_a((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.func_70186_c(this.field_70159_w, this.field_70181_x, this.field_70179_y, velocity * 1.5f, 1.0f);
    }

    protected void func_70088_a() {
    }

    public void func_70186_c(double x, double y, double z, float velocity, float inaccuracy) {
        float f2 = MathHelper.func_76133_a((double)(x * x + y * y + z * z));
        x /= (double)f2;
        y /= (double)f2;
        z /= (double)f2;
        x += this.field_70146_Z.nextGaussian() * (double)(this.field_70146_Z.nextBoolean() ? -1 : 1) * (double)0.0075f * (double)inaccuracy;
        y += this.field_70146_Z.nextGaussian() * (double)(this.field_70146_Z.nextBoolean() ? -1 : 1) * (double)0.0075f * (double)inaccuracy;
        z += this.field_70146_Z.nextGaussian() * (double)(this.field_70146_Z.nextBoolean() ? -1 : 1) * (double)0.0075f * (double)inaccuracy;
        this.field_70159_w = x *= (double)velocity;
        this.field_70181_x = y *= (double)velocity;
        this.field_70179_y = z *= (double)velocity;
        float f3 = MathHelper.func_76133_a((double)(x * x + z * z));
        this.field_70126_B = this.field_70177_z = (float)(Math.atan2(x, z) * 180.0 / Math.PI);
        this.field_70127_C = this.field_70125_A = (float)(Math.atan2(y, f3) * 180.0 / Math.PI);
        this.ticksInGround = 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70056_a(double x, double y, double z, float yaw, float pitch, int type) {
        this.func_70107_b(x, y, z);
        this.func_70101_b(yaw, pitch);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70016_h(double x, double y, double z) {
        this.field_70159_w = x;
        this.field_70181_x = y;
        this.field_70179_y = z;
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(x * x + z * z));
            this.field_70126_B = this.field_70177_z = (float)(Math.atan2(x, z) * 180.0 / Math.PI);
            this.field_70127_C = this.field_70125_A = (float)(Math.atan2(y, f) * 180.0 / Math.PI);
            this.field_70127_C = this.field_70125_A;
            this.field_70126_B = this.field_70177_z;
            this.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
            this.ticksInGround = 0;
        }
    }

    public void func_70071_h_() {
        Block block;
        super.func_70030_z();
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70126_B = this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
            this.field_70127_C = this.field_70125_A = (float)(Math.atan2(this.field_70181_x, f) * 180.0 / Math.PI);
        }
        if ((block = this.field_70170_p.func_147439_a(this.tileX, this.tileY, this.tileZ)).func_149688_o() != Material.field_151579_a) {
            block.func_149719_a((IBlockAccess)this.field_70170_p, this.tileX, this.tileY, this.tileZ);
            AxisAlignedBB axisalignedbb = block.func_149668_a(this.field_70170_p, this.tileX, this.tileY, this.tileZ);
            if (axisalignedbb != null && axisalignedbb.func_72318_a(Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v))) {
                this.inGround = true;
                this.wasInGround = true;
            }
        }
        if (this.dartShake > 0) {
            --this.dartShake;
        }
        if (this.inGround) {
            int j = this.field_70170_p.func_72805_g(this.tileX, this.tileY, this.tileZ);
            if (block == this.inTile && j == this.inData) {
                ++this.ticksInGround;
                if (this.ticksInGround == 1200) {
                    this.func_70106_y();
                }
            } else {
                this.inGround = false;
                this.field_70159_w *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.field_70181_x *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.field_70179_y *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.ticksInGround = 0;
                this.ticksInAir = 0;
            }
        } else {
            float f1;
            ++this.ticksInAir;
            Vec3 vec31 = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
            Vec3 vec3 = Vec3.func_72443_a((double)(this.field_70165_t + this.field_70159_w), (double)(this.field_70163_u + this.field_70181_x), (double)(this.field_70161_v + this.field_70179_y));
            MovingObjectPosition movingobjectposition = this.field_70170_p.func_147447_a(vec31, vec3, false, true, false);
            vec31 = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
            vec3 = Vec3.func_72443_a((double)(this.field_70165_t + this.field_70159_w), (double)(this.field_70163_u + this.field_70181_x), (double)(this.field_70161_v + this.field_70179_y));
            if (movingobjectposition != null) {
                vec3 = Vec3.func_72443_a((double)movingobjectposition.field_72307_f.field_72450_a, (double)movingobjectposition.field_72307_f.field_72448_b, (double)movingobjectposition.field_72307_f.field_72449_c);
            }
            Entity entity = null;
            List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72314_b(1.0, 1.0, 1.0));
            double d0 = 0.0;
            for (int i = 0; i < list.size(); ++i) {
                double d1;
                AxisAlignedBB axisalignedbb1;
                MovingObjectPosition movingobjectposition1;
                Entity entity1 = (Entity)list.get(i);
                if (!entity1.func_70067_L() || entity1 == this.field_70250_c && this.ticksInAir < 5 || (movingobjectposition1 = (axisalignedbb1 = entity1.field_70121_D.func_72314_b((double)(f1 = 0.3f), (double)f1, (double)f1)).func_72327_a(vec31, vec3)) == null || !((d1 = vec31.func_72438_d(movingobjectposition1.field_72307_f)) < d0) && d0 != 0.0) continue;
                entity = entity1;
                d0 = d1;
            }
            if (entity != null) {
                movingobjectposition = new MovingObjectPosition(entity);
            }
            if (movingobjectposition != null && movingobjectposition.field_72308_g != null && movingobjectposition.field_72308_g instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)movingobjectposition.field_72308_g;
                if (entityplayer.field_71075_bZ.field_75102_a || this.field_70250_c instanceof EntityPlayer && !((EntityPlayer)this.field_70250_c).func_96122_a(entityplayer)) {
                    movingobjectposition = null;
                }
            }
            if (movingobjectposition != null) {
                this.onDartHit(movingobjectposition);
            }
            this.field_70165_t += this.field_70159_w;
            this.field_70163_u += this.field_70181_x;
            this.field_70161_v += this.field_70179_y;
            float f2 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
            this.field_70125_A = (float)(Math.atan2(this.field_70181_x, f2) * 180.0 / Math.PI);
            while (this.field_70125_A - this.field_70127_C < -180.0f) {
                this.field_70127_C -= 360.0f;
            }
            while (this.field_70125_A - this.field_70127_C >= 180.0f) {
                this.field_70127_C += 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B < -180.0f) {
                this.field_70126_B -= 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B >= 180.0f) {
                this.field_70126_B += 360.0f;
            }
            this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
            this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
            float f3 = 0.99f;
            f1 = 0.05f;
            if (this.func_70090_H()) {
                for (int l = 0; l < 4; ++l) {
                    float f4 = 0.25f;
                    this.field_70170_p.func_72869_a("bubble", this.field_70165_t - this.field_70159_w * (double)f4, this.field_70163_u - this.field_70181_x * (double)f4, this.field_70161_v - this.field_70179_y * (double)f4, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                }
                f3 = 0.8f;
            }
            if (this.func_70026_G()) {
                this.func_70066_B();
            }
            this.field_70159_w *= (double)f3;
            this.field_70181_x *= (double)f3;
            this.field_70179_y *= (double)f3;
            if (this.wasInGround) {
                this.field_70181_x -= this.wasInGround ? (double)f1 : (double)this.getGravityVelocity();
            }
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            this.func_145775_I();
        }
        if (this.ticksInAir == 500) {
            this.func_70106_y();
        }
    }

    public void onDartHit(MovingObjectPosition movingobjectposition) {
        if (movingobjectposition.field_72308_g != null) {
            float f2 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
            int k = MathHelper.func_76143_f((double)((double)f2 * this.damage));
            DamageSource damagesource = null;
            damagesource = this.field_70250_c == null ? EntityDartBase.causeDartDamage(this, (Entity)this) : EntityDartBase.causeDartDamage(this, this.field_70250_c);
            if (this.func_70027_ad() && !(movingobjectposition.field_72308_g instanceof EntityEnderman)) {
                movingobjectposition.field_72308_g.func_70015_d(5);
            }
            if (movingobjectposition.field_72308_g.func_70097_a(damagesource, (float)k)) {
                if (movingobjectposition.field_72308_g instanceof EntityLivingBase) {
                    float f4;
                    EntityLivingBase entitylivingbase = (EntityLivingBase)movingobjectposition.field_72308_g;
                    if (!this.field_70170_p.field_72995_K) {
                        entitylivingbase.func_85034_r(entitylivingbase.func_85035_bI() + 1);
                    }
                    if ((f4 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y))) > 0.0f) {
                        movingobjectposition.field_72308_g.func_70024_g(this.field_70159_w * (double)0.6f / (double)f4, 0.1, this.field_70179_y * (double)0.6f / (double)f4);
                    }
                    if (this.field_70250_c != null && this.field_70250_c instanceof EntityLivingBase) {
                        EnchantmentHelper.func_151384_a((EntityLivingBase)entitylivingbase, (Entity)this.field_70250_c);
                        EnchantmentHelper.func_151385_b((EntityLivingBase)((EntityLivingBase)this.field_70250_c), (Entity)entitylivingbase);
                    }
                    if (this.field_70250_c != null && movingobjectposition.field_72308_g != this.field_70250_c && movingobjectposition.field_72308_g instanceof EntityPlayer && this.field_70250_c instanceof EntityPlayerMP) {
                        ((EntityPlayerMP)this.field_70250_c).field_71135_a.func_147359_a((Packet)new S2BPacketChangeGameState(6, 0.0f));
                    }
                }
                this.func_85030_a("random.bowhit", 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
                if (!(movingobjectposition.field_72308_g instanceof EntityEnderman)) {
                    this.func_70106_y();
                }
            } else {
                this.field_70159_w *= -0.1;
                this.field_70181_x *= -0.1;
                this.field_70179_y *= -0.1;
                this.field_70177_z += 180.0f;
                this.field_70126_B += 180.0f;
                this.ticksInAir = 0;
            }
        } else {
            this.tileX = movingobjectposition.field_72311_b;
            this.tileY = movingobjectposition.field_72312_c;
            this.tileZ = movingobjectposition.field_72309_d;
            this.inTile = this.field_70170_p.func_147439_a(this.tileX, this.tileY, this.tileZ);
            this.inData = this.field_70170_p.func_72805_g(this.tileX, this.tileY, this.tileZ);
            this.field_70159_w = (float)(movingobjectposition.field_72307_f.field_72450_a - this.field_70165_t);
            this.field_70181_x = (float)(movingobjectposition.field_72307_f.field_72448_b - this.field_70163_u);
            this.field_70179_y = (float)(movingobjectposition.field_72307_f.field_72449_c - this.field_70161_v);
            float f2 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
            this.field_70165_t -= this.field_70159_w / (double)f2 * 0.05;
            this.field_70163_u -= this.field_70181_x / (double)f2 * 0.05;
            this.field_70161_v -= this.field_70179_y / (double)f2 * 0.05;
            this.func_85030_a("random.bowhit", 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
            this.inGround = true;
            this.wasInGround = true;
            this.dartShake = 7;
            if (this.inTile.func_149688_o() != Material.field_151579_a) {
                this.inTile.func_149670_a(this.field_70170_p, this.tileX, this.tileY, this.tileZ, (Entity)this);
            }
        }
        if (movingobjectposition.field_72308_g != null && movingobjectposition.field_72313_a != null && this.field_70250_c != null) {
            if (movingobjectposition.field_72308_g != this.field_70250_c && movingobjectposition.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY && movingobjectposition.field_72308_g != this.field_70250_c.field_70153_n) {
                this.func_70106_y();
            } else {
                this.setGravityVelocity(0.03f);
            }
        }
    }

    protected float getGravityVelocity() {
        return this.gravityVelocity;
    }

    public void setGravityVelocity(float gravityVelocity) {
        this.gravityVelocity = gravityVelocity;
    }

    public void func_70014_b(NBTTagCompound p_70014_1_) {
        p_70014_1_.func_74777_a("xTile", (short)this.tileX);
        p_70014_1_.func_74777_a("yTile", (short)this.tileY);
        p_70014_1_.func_74777_a("zTile", (short)this.tileZ);
        p_70014_1_.func_74777_a("life", (short)this.ticksInGround);
        p_70014_1_.func_74774_a("inTile", (byte)Block.func_149682_b((Block)this.inTile));
        p_70014_1_.func_74774_a("inData", (byte)this.inData);
        p_70014_1_.func_74774_a("shake", (byte)this.dartShake);
        p_70014_1_.func_74774_a("inGround", (byte)(this.inGround ? 1 : 0));
        p_70014_1_.func_74774_a("wasInGround", (byte)(this.wasInGround ? 1 : 0));
        p_70014_1_.func_74774_a("pickup", (byte)this.field_70251_a);
        p_70014_1_.func_74780_a("damage", this.damage);
    }

    public void func_70037_a(NBTTagCompound p_70037_1_) {
        this.tileX = p_70037_1_.func_74765_d("xTile");
        this.tileY = p_70037_1_.func_74765_d("yTile");
        this.tileZ = p_70037_1_.func_74765_d("zTile");
        this.ticksInGround = p_70037_1_.func_74765_d("life");
        this.inTile = Block.func_149729_e((int)(p_70037_1_.func_74771_c("inTile") & 0xFF));
        this.inData = p_70037_1_.func_74771_c("inData") & 0xFF;
        this.dartShake = p_70037_1_.func_74771_c("shake") & 0xFF;
        this.inGround = p_70037_1_.func_74771_c("inGround") == 1;
        boolean bl = this.wasInGround = p_70037_1_.func_74771_c("wasInGround") == 1;
        if (p_70037_1_.func_150297_b("damage", 99)) {
            this.damage = p_70037_1_.func_74769_h("damage");
        }
        if (p_70037_1_.func_150297_b("pickup", 99)) {
            this.field_70251_a = p_70037_1_.func_74771_c("pickup");
        } else if (p_70037_1_.func_150297_b("player", 99)) {
            this.field_70251_a = p_70037_1_.func_74767_n("player") ? 1 : 0;
        }
    }

    public void func_70100_b_(EntityPlayer player) {
        if (!this.field_70170_p.field_72995_K && this.inGround && this.dartShake <= 0) {
            boolean flag;
            boolean bl = flag = this.field_70251_a == 1 || this.field_70251_a == 2 && player.field_71075_bZ.field_75098_d;
            if (this.field_70251_a == 1 && !player.field_71071_by.func_70441_a(this.getStack())) {
                flag = false;
            }
            if (flag) {
                this.func_85030_a("random.pop", 0.2f, ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                player.func_71001_a((Entity)this, 1);
                this.func_70106_y();
            }
        }
    }

    protected abstract ItemStack getStack();

    public void func_70239_b(double p_70239_1_) {
        this.damage = p_70239_1_;
    }

    public double func_70242_d() {
        return this.damage;
    }

    public void setThrower(Entity entity) {
        this.field_70250_c = entity;
    }

    public Entity getThrower() {
        return this.field_70250_c;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public float func_70053_R() {
        return 0.0f;
    }

    public boolean func_70075_an() {
        return false;
    }

    public static DamageSource causeDartDamage(EntityDartBase dart, Entity thrower) {
        return new EntityDamageSourceIndirect("aether_legacy.dart", (Entity)dart, thrower).func_76349_b();
    }

    public void func_70243_d(boolean p_70243_1_) {
    }

    public boolean func_70241_g() {
        return false;
    }
}

