/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.the_aether.player;

import com.gildedgames.the_aether.AetherConfig;
import com.gildedgames.the_aether.api.player.IPlayerAether;
import com.gildedgames.the_aether.api.player.util.IAccessoryInventory;
import com.gildedgames.the_aether.api.player.util.IAetherAbility;
import com.gildedgames.the_aether.api.player.util.IAetherBoss;
import com.gildedgames.the_aether.blocks.BlocksAether;
import com.gildedgames.the_aether.entities.passive.mountable.EntityParachute;
import com.gildedgames.the_aether.inventory.InventoryAccessories;
import com.gildedgames.the_aether.items.ItemsAether;
import com.gildedgames.the_aether.items.tools.ItemValkyrieTool;
import com.gildedgames.the_aether.network.AetherNetwork;
import com.gildedgames.the_aether.network.packets.PacketCapeChanged;
import com.gildedgames.the_aether.network.packets.PacketPerkChanged;
import com.gildedgames.the_aether.network.packets.PacketPortalItem;
import com.gildedgames.the_aether.network.packets.PacketSendPoisonTime;
import com.gildedgames.the_aether.network.packets.PacketSendSeenDialogue;
import com.gildedgames.the_aether.network.packets.PacketUpdateLifeShardCount;
import com.gildedgames.the_aether.player.abilities.AbilityAccessories;
import com.gildedgames.the_aether.player.abilities.AbilityArmor;
import com.gildedgames.the_aether.player.abilities.AbilityFlight;
import com.gildedgames.the_aether.player.abilities.AbilityRepulsion;
import com.gildedgames.the_aether.player.perks.AetherRankings;
import com.gildedgames.the_aether.player.perks.util.DonatorMoaSkin;
import com.gildedgames.the_aether.player.perks.util.EnumAetherPerkType;
import com.gildedgames.the_aether.registry.achievements.AchievementsAether;
import com.gildedgames.the_aether.world.TeleporterAether;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.server.MinecraftServer;
import net.minecraft.stats.StatBase;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.Direction;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;

public class PlayerAether
implements IPlayerAether {
    private EntityPlayer player;
    private IAetherBoss focusedBoss;
    private IAccessoryInventory accessories = new InventoryAccessories(this);
    private final ArrayList<IAetherAbility> abilities = new ArrayList();
    public final ArrayList<Entity> clouds = new ArrayList(2);
    public int shardCount;
    public DonatorMoaSkin donatorMoaSkin = new DonatorMoaSkin();
    public boolean shouldRenderHalo = true;
    public boolean shouldRenderGlow = false;
    public boolean shouldRenderCape = true;
    public boolean seenSpiritDialog = false;
    private boolean isJumping;
    private boolean isMountSneaking;
    private boolean inPortal;
    private int portalCounter;
    public int teleportDirection;
    private String hammerName = StatCollector.func_74838_a((String)"item.notch_hammer.name");
    private int cooldown;
    private int cooldownMax;
    public float wingSinage;
    public float timeInPortal;
    public float prevTimeInPortal;
    public Entity riddenEntity;
    private ChunkCoordinates bedLocation;
    public boolean isPoisoned = false;
    public boolean isCured = false;
    public boolean shouldGetPortal = true;
    public int poisonTime = 0;
    public int cureTime = 0;
    private UUID uuid = UUID.fromString("df6eabe7-6947-4a56-9099-002f90370706");
    private AttributeModifier healthModifier;

    public PlayerAether() {
        this.abilities.addAll(Arrays.asList(new AbilityAccessories(this), new AbilityArmor(this), new AbilityFlight(this), new AbilityRepulsion(this)));
    }

    public static PlayerAether get(EntityPlayer player) {
        return (PlayerAether)player.getExtendedProperties("aether_legacy:player_aether");
    }

    public void init(Entity entity, World world) {
        this.player = (EntityPlayer)entity;
    }

    @Override
    public void onUpdate() {
        int i;
        if (!this.player.field_70170_p.field_72995_K) {
            AetherNetwork.sendToAll(new PacketPerkChanged(this.getEntity().func_145782_y(), EnumAetherPerkType.Halo, this.shouldRenderHalo));
            AetherNetwork.sendToAll(new PacketPerkChanged(this.getEntity().func_145782_y(), EnumAetherPerkType.Glow, this.shouldRenderGlow));
            AetherNetwork.sendToAll(new PacketCapeChanged(this.getEntity().func_145782_y(), this.shouldRenderCape));
            AetherNetwork.sendToAll(new PacketSendPoisonTime(this.getEntity(), this.poisonTime));
            AetherNetwork.sendToAll(new PacketSendSeenDialogue(this.getEntity(), this.seenSpiritDialog));
            AetherNetwork.sendToAll(new PacketPortalItem(this.getEntity(), this.shouldGetPortal));
        }
        if (this.isPoisoned) {
            if (this.poisonTime > 0) {
                --this.poisonTime;
            } else {
                this.poisonTime = 0;
                this.isPoisoned = false;
            }
        }
        if (this.isCured) {
            if (this.cureTime > 0) {
                --this.cureTime;
            } else {
                this.cureTime = 0;
                this.isCured = false;
            }
        }
        for (i = 0; i < this.getAbilities().size(); ++i) {
            IAetherAbility ability = this.getAbilities().get(i);
            if (!ability.shouldExecute()) continue;
            ability.onUpdate();
        }
        for (i = 0; i < this.clouds.size(); ++i) {
            Entity entity = this.clouds.get(i);
            if (!entity.field_70128_L) continue;
            this.clouds.remove(i);
        }
        if (this.cooldown > 0) {
            this.cooldown -= 2;
        }
        if (this.isInsideBlock(BlocksAether.aercloud)) {
            this.getEntity().field_70143_R = 0.0f;
        }
        if (this.getEntity().field_70181_x < -2.0) {
            this.activateParachute();
        }
        this.wingSinage = !this.getEntity().field_70122_E ? (this.wingSinage += 0.75f) : (this.wingSinage += 0.15f);
        this.wingSinage = this.wingSinage > 6.283186f ? (this.wingSinage -= 6.283186f) : (this.wingSinage += 0.1f);
        boolean hasJumped = (Boolean)ReflectionHelper.getPrivateValue(EntityLivingBase.class, (Object)this.getEntity(), (String[])new String[]{"isJumping", "field_70703_bu"});
        this.setJumping(hasJumped);
        this.getEntity().field_70170_p.field_72984_F.func_76320_a("portal");
        if (this.getEntity().field_71093_bK == AetherConfig.getAetherDimensionID() && this.getEntity().field_70163_u < -12.0) {
            this.teleportPlayer(false);
            if (this.riddenEntity != null) {
                this.getEntity().func_70078_a(this.riddenEntity);
                this.riddenEntity = null;
            }
        }
        if (this.inPortal) {
            if (this.getEntity().field_71088_bW <= 0) {
                int limit = this.getEntity().func_82145_z();
                if (this.getEntity().field_70154_o == null) {
                    if (this.portalCounter >= limit) {
                        this.portalCounter = 0;
                        this.getEntity().field_71088_bW = this.getEntity().func_82147_ab();
                        if (!this.getEntity().field_70170_p.field_72995_K) {
                            this.teleportPlayer(true);
                            this.getEntity().func_71029_a((StatBase)AchievementsAether.enter_aether);
                        }
                    } else {
                        ++this.portalCounter;
                    }
                }
            } else {
                this.getEntity().field_71088_bW = this.getEntity().func_82147_ab();
            }
            if (this.getEntity().field_70170_p.func_147439_a((int)this.getEntity().field_70165_t, (int)this.getEntity().field_70163_u - 1, (int)this.getEntity().field_70161_v) != Blocks.field_150350_a) {
                AxisAlignedBB playerBounding = this.getEntity().field_70121_D;
                if (this.getEntity().field_70170_p.func_147439_a((int)playerBounding.field_72340_a, (int)playerBounding.field_72338_b, (int)playerBounding.field_72339_c) != BlocksAether.aether_portal && this.getEntity().field_70170_p.func_147439_a((int)playerBounding.field_72340_a, (int)playerBounding.field_72338_b, (int)playerBounding.field_72339_c) != BlocksAether.aether_portal) {
                    this.inPortal = false;
                }
            }
        } else {
            if (this.portalCounter > 0) {
                this.portalCounter -= 4;
            }
            if (this.portalCounter < 0) {
                this.portalCounter = 0;
            }
        }
        this.getEntity().field_70170_p.field_72984_F.func_76319_b();
        if (!this.getEntity().field_70170_p.field_72995_K) {
            double distance;
            ItemStack stack = this.getEntity().func_71045_bC();
            double d = distance = this.getEntity().field_71075_bZ.field_75098_d ? 5.0 : 4.5;
            if (stack != null && stack.func_77973_b() instanceof ItemValkyrieTool) {
                distance = 8.0;
            }
            ((EntityPlayerMP)this.getEntity()).field_71134_c.setBlockReachDistance(distance);
        } else {
            this.prevTimeInPortal = this.timeInPortal;
            if (this.isInsideBlock(BlocksAether.aether_portal)) {
                this.timeInPortal += 0.0125f;
                if (this.timeInPortal >= 1.0f) {
                    this.timeInPortal = 1.0f;
                }
            } else if (this.getEntity().func_70644_a(Potion.field_76431_k) && this.getEntity().func_70660_b(Potion.field_76431_k).func_76459_b() > 60) {
                this.timeInPortal += 0.006666667f;
                if (this.timeInPortal > 1.0f) {
                    this.timeInPortal = 1.0f;
                }
            } else {
                if (this.timeInPortal > 0.0f) {
                    this.timeInPortal -= 0.05f;
                }
                if (this.timeInPortal < 0.0f) {
                    this.timeInPortal = 0.0f;
                }
            }
        }
        if (!this.player.field_70170_p.field_72995_K && this.bedLocation != null && this.player.field_71093_bK == AetherConfig.getAetherDimensionID() && this.player.field_70170_p.func_147439_a(this.bedLocation.field_71574_a, this.bedLocation.field_71572_b, this.bedLocation.field_71573_c) != BlocksAether.skyroot_bed) {
            this.setBedLocation(null);
        }
    }

    @Override
    public void setInPortal() {
        double d0 = this.getEntity().field_70169_q - this.getEntity().field_70165_t;
        double d1 = this.getEntity().field_70166_s - this.getEntity().field_70161_v;
        if (!this.getEntity().field_70170_p.field_72995_K && !this.inPortal) {
            this.teleportDirection = Direction.func_82372_a((double)d0, (double)d1);
        }
        this.inPortal = true;
    }

    private void activateParachute() {
        if (!this.player.field_71075_bZ.field_75098_d) {
            EntityParachute parachute = null;
            ItemStack itemstack = null;
            for (int i = 0; i < this.getEntity().field_71071_by.func_70302_i_(); ++i) {
                ItemStack stackInSlot = this.getEntity().field_71071_by.func_70301_a(i);
                if (stackInSlot != null && stackInSlot.func_77973_b() == ItemsAether.cloud_parachute) {
                    itemstack = stackInSlot;
                    break;
                }
                if (stackInSlot == null || stackInSlot.func_77973_b() != ItemsAether.golden_parachute) continue;
                itemstack = stackInSlot;
                break;
            }
            if (itemstack != null) {
                if (itemstack.func_77973_b() == ItemsAether.cloud_parachute) {
                    parachute = new EntityParachute(this.getEntity().field_70170_p, this.getEntity(), false);
                    parachute.func_70107_b(this.getEntity().field_70165_t, this.getEntity().field_70163_u, this.getEntity().field_70161_v);
                    this.getEntity().field_70170_p.func_72838_d((Entity)parachute);
                    this.getEntity().field_71071_by.func_146026_a(itemstack.func_77973_b());
                } else if (itemstack.func_77973_b() == ItemsAether.golden_parachute) {
                    itemstack.func_77972_a(1, (EntityLivingBase)this.getEntity());
                    parachute = new EntityParachute(this.getEntity().field_70170_p, this.getEntity(), true);
                    parachute.func_70107_b(this.getEntity().field_70165_t, this.getEntity().field_70163_u, this.getEntity().field_70161_v);
                    this.getEntity().field_70170_p.func_72838_d((Entity)parachute);
                }
            }
        }
    }

    public boolean isInsideBlock(Block block) {
        AxisAlignedBB boundingBox = this.getEntity().field_70121_D;
        int i = MathHelper.func_76128_c((double)boundingBox.field_72340_a);
        int j = MathHelper.func_76128_c((double)(boundingBox.field_72336_d + 1.0));
        int k = MathHelper.func_76128_c((double)boundingBox.field_72338_b);
        int l = MathHelper.func_76128_c((double)(boundingBox.field_72337_e + 1.0));
        int i1 = MathHelper.func_76128_c((double)boundingBox.field_72339_c);
        int j1 = MathHelper.func_76128_c((double)(boundingBox.field_72334_f + 1.0));
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    if (this.getEntity().field_70170_p.func_147439_a(k1, l1, i2) != block) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private void teleportPlayer(boolean shouldSpawnPortal) {
        if (this.getEntity() instanceof EntityPlayerMP) {
            int previousDimension = this.getEntity().field_71093_bK;
            int transferDimension = previousDimension == AetherConfig.getAetherDimensionID() ? AetherConfig.getTravelDimensionID() : AetherConfig.getAetherDimensionID();
            MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
            TeleporterAether teleporter = new TeleporterAether(shouldSpawnPortal, server.func_71218_a(transferDimension));
            if (this.getEntity().field_70154_o != null) {
                this.getEntity().field_70154_o.func_70078_a(null);
            }
            if (this.getEntity().field_70153_n != null) {
                this.getEntity().field_70153_n.func_70078_a(null);
            }
            if (server != null && server.func_71203_ab() != null) {
                server.func_71203_ab().transferPlayerToDimension((EntityPlayerMP)this.getEntity(), transferDimension, (Teleporter)teleporter);
            }
        }
    }

    public void saveNBTData(NBTTagCompound compound) {
        NBTTagCompound aetherTag = new NBTTagCompound();
        if (AetherRankings.isRankedPlayer(this.player.func_110124_au())) {
            aetherTag.func_74757_a("halo", this.shouldRenderHalo);
        }
        if (AetherRankings.isDeveloper(this.player.func_110124_au())) {
            aetherTag.func_74757_a("glow", this.shouldRenderGlow);
        }
        aetherTag.func_74757_a("poisoned", this.isPoisoned);
        aetherTag.func_74768_a("poison_time", this.poisonTime);
        aetherTag.func_74757_a("cape", this.shouldRenderCape);
        aetherTag.func_74768_a("shardCount", this.shardCount);
        aetherTag.func_74782_a("accessories", (NBTBase)this.getAccessoryInventory().writeToNBT(aetherTag));
        aetherTag.func_74757_a("seen_spirit_dialog", this.seenSpiritDialog);
        aetherTag.func_74757_a("get_portal", this.shouldGetPortal);
        if (this.bedLocation != null) {
            aetherTag.func_74768_a("bedX", this.bedLocation.field_71574_a);
            aetherTag.func_74768_a("bedY", this.bedLocation.field_71572_b);
            aetherTag.func_74768_a("bedZ", this.bedLocation.field_71573_c);
        }
        compound.func_74782_a("aetherI", (NBTBase)aetherTag);
    }

    public void loadNBTData(NBTTagCompound compound) {
        NBTTagCompound aetherTag = compound.func_74775_l("aetherI");
        if (aetherTag.func_74764_b("halo")) {
            this.shouldRenderHalo = aetherTag.func_74767_n("halo");
        }
        if (aetherTag.func_74764_b("glow")) {
            this.shouldRenderGlow = aetherTag.func_74767_n("glow");
        }
        if (aetherTag.func_74764_b("cape")) {
            this.shouldRenderCape = aetherTag.func_74767_n("cape");
        }
        if (aetherTag.func_74764_b("poisoned")) {
            this.isPoisoned = aetherTag.func_74767_n("poisoned");
        }
        if (aetherTag.func_74764_b("poison_time")) {
            this.poisonTime = aetherTag.func_74762_e("poison_time");
        }
        if (aetherTag.func_74764_b("seen_spirit_dialog")) {
            this.seenSpiritDialog = aetherTag.func_74767_n("seen_spirit_dialog");
        }
        if (aetherTag.func_74764_b("get_portal")) {
            this.shouldGetPortal = aetherTag.func_74767_n("get_portal");
        }
        if (aetherTag.func_74764_b("shardCount")) {
            this.shardCount = aetherTag.func_74762_e("shardCount");
        }
        this.getAccessoryInventory().readFromNBT(aetherTag.func_150295_c("accessories", 10));
        this.setBedLocation(new ChunkCoordinates(aetherTag.func_74762_e("bedX"), aetherTag.func_74762_e("bedY"), aetherTag.func_74762_e("bedZ")));
    }

    @Override
    public void setFocusedBoss(IAetherBoss boss) {
        this.focusedBoss = boss;
    }

    @Override
    public IAetherBoss getFocusedBoss() {
        return this.focusedBoss;
    }

    @Override
    public void setAccessoryInventory(IAccessoryInventory inventory) {
        this.accessories = inventory;
    }

    @Override
    public IAccessoryInventory getAccessoryInventory() {
        return this.accessories;
    }

    @Override
    public ArrayList<IAetherAbility> getAbilities() {
        return this.abilities;
    }

    public EntityPlayer getEntity() {
        return this.player;
    }

    @Override
    public void updateShardCount(int amount) {
        if (!this.getEntity().field_70170_p.field_72995_K) {
            if (this.getShardsUsed() < this.getMaxShardCount()) {
                this.shardCount += amount;
                AetherNetwork.sendToAll(new PacketUpdateLifeShardCount(this.player, this.shardCount));
                this.healthModifier = new AttributeModifier(this.uuid, "Aether Health Modifier", (double)this.shardCount * 2.0, 0);
                if (this.player.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111127_a(this.uuid) != null) {
                    this.player.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111124_b(this.healthModifier);
                }
                this.player.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111121_a(this.healthModifier);
            } else {
                AetherNetwork.sendToAll(new PacketUpdateLifeShardCount(this.player, this.shardCount));
            }
        }
    }

    @Override
    public int getShardsUsed() {
        return this.shardCount;
    }

    @Override
    public int getMaxShardCount() {
        return AetherConfig.getMaxLifeShards();
    }

    @Override
    public void setJumping(boolean isJumping) {
        this.isJumping = isJumping;
    }

    @Override
    public boolean isJumping() {
        return this.isJumping;
    }

    @Override
    public void setMountSneaking(boolean isSneaking) {
        this.isMountSneaking = isSneaking;
    }

    @Override
    public boolean isMountSneaking() {
        return this.isMountSneaking;
    }

    @Override
    public boolean isDonator() {
        return true;
    }

    @Override
    public boolean setHammerCooldown(int cooldown, String hammerName) {
        if (this.cooldown <= 0) {
            this.cooldown = cooldown;
            this.cooldownMax = cooldown;
            this.hammerName = hammerName;
            return true;
        }
        return false;
    }

    @Override
    public String getHammerName() {
        return this.hammerName;
    }

    @Override
    public int getHammerCooldown() {
        return this.cooldown;
    }

    @Override
    public int getHammerMaxCooldown() {
        return this.cooldownMax;
    }

    public void setBedLocation(ChunkCoordinates bedLocation) {
        this.bedLocation = bedLocation;
    }

    public ChunkCoordinates getBedLocation() {
        return this.bedLocation;
    }

    public boolean isPoisoned() {
        return this.isPoisoned;
    }

    public void setPoisoned() {
        this.isPoisoned = true;
        this.poisonTime = 500;
    }

    public boolean isCured() {
        return this.isCured;
    }

    public void setCured(int time) {
        this.isCured = true;
        this.cureTime = time;
        this.isPoisoned = false;
        this.poisonTime = 0;
    }

    public void givePortalFrame() {
        if (this.shouldGetPortal) {
            this.player.field_71071_by.func_70441_a(new ItemStack(ItemsAether.aether_portal_frame));
            this.shouldGetPortal = false;
        }
    }
}

