/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.the_aether.player.abilities;

import com.gildedgames.the_aether.api.player.IPlayerAether;
import com.gildedgames.the_aether.api.player.util.IAetherAbility;
import com.gildedgames.the_aether.items.ItemsAether;
import com.gildedgames.the_aether.player.movement.AetherLiquidMovement;
import java.util.Map;
import java.util.Random;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.WorldServer;

public class AbilityArmor
implements IAetherAbility {
    private final AetherLiquidMovement player_movement;
    private final Random random = new Random();
    private final IPlayerAether player;
    private boolean jumpBoosted;

    public AbilityArmor(IPlayerAether player) {
        this.player = player;
        this.player_movement = new AetherLiquidMovement(player);
    }

    @Override
    public boolean shouldExecute() {
        return true;
    }

    @Override
    public void onUpdate() {
        if (this.player.getAccessoryInventory().isWearingNeptuneSet()) {
            this.player_movement.onUpdate();
        }
        if (this.player.getAccessoryInventory().isWearingGravititeSet() && this.player.isJumping() && !this.jumpBoosted) {
            this.player.getEntity().field_70181_x = 1.0;
            this.jumpBoosted = true;
        }
        if (this.player.getEntity().func_70026_G()) {
            if (this.player.getAccessoryInventory().wearingArmor(new ItemStack(ItemsAether.phoenix_boots))) {
                this.damagePhoenixArmor((Entity)this.player.getEntity(), ItemsAether.obsidian_boots, 0);
            }
            if (this.player.getAccessoryInventory().wearingArmor(new ItemStack(ItemsAether.phoenix_leggings))) {
                this.damagePhoenixArmor((Entity)this.player.getEntity(), ItemsAether.obsidian_leggings, 1);
            }
            if (this.player.getAccessoryInventory().wearingArmor(new ItemStack(ItemsAether.phoenix_chestplate))) {
                this.damagePhoenixArmor((Entity)this.player.getEntity(), ItemsAether.obsidian_chestplate, 2);
            }
            if (this.player.getAccessoryInventory().wearingArmor(new ItemStack(ItemsAether.phoenix_helmet))) {
                this.damagePhoenixArmor((Entity)this.player.getEntity(), ItemsAether.obsidian_helmet, 3);
            }
        }
        if (this.player.getAccessoryInventory().isWearingPhoenixSet()) {
            this.player.getEntity().func_70066_B();
            this.player_movement.onUpdate();
            if (!this.player.getEntity().field_70170_p.field_72995_K) {
                ((WorldServer)this.player.getEntity().field_70170_p).func_147487_a("flame", this.player.getEntity().field_70165_t + this.random.nextGaussian() / 5.0, this.player.getEntity().field_70163_u + this.random.nextGaussian() / 5.0, this.player.getEntity().field_70161_v + this.random.nextGaussian() / 3.0, 0, 0.0, 0.0, 0.0, 0.0);
            }
        }
        if (!this.player.isJumping() && this.player.getEntity().field_70122_E) {
            this.jumpBoosted = false;
        }
    }

    public void damagePhoenixArmor(Entity entity, Item outcome, int slot) {
        if (entity instanceof EntityLivingBase && this.player.getEntity().field_70170_p.func_82737_E() % 5L == 0L) {
            EntityLivingBase entityLiving = (EntityLivingBase)entity;
            ItemStack stack = entityLiving.func_71124_b(slot + 1);
            stack.func_77972_a(1, entityLiving);
            if (stack.field_77994_a <= 0) {
                ItemStack outcomeStack = new ItemStack(outcome);
                EnchantmentHelper.func_82782_a((Map)EnchantmentHelper.func_82781_a((ItemStack)stack), (ItemStack)outcomeStack);
                entityLiving.func_70062_b(slot + 1, outcomeStack);
            }
        }
    }
}

