/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.the_aether.world.biome;

import com.gildedgames.the_aether.AetherConfig;
import com.gildedgames.the_aether.blocks.BlocksAether;
import com.gildedgames.the_aether.world.biome.decoration.AetherGenClouds;
import com.gildedgames.the_aether.world.biome.decoration.AetherGenDungeonOakTree;
import com.gildedgames.the_aether.world.biome.decoration.AetherGenFloatingIsland;
import com.gildedgames.the_aether.world.biome.decoration.AetherGenFoilage;
import com.gildedgames.the_aether.world.biome.decoration.AetherGenHolidayTree;
import com.gildedgames.the_aether.world.biome.decoration.AetherGenLakes;
import com.gildedgames.the_aether.world.biome.decoration.AetherGenLiquids;
import com.gildedgames.the_aether.world.biome.decoration.AetherGenMinable;
import com.gildedgames.the_aether.world.biome.decoration.AetherGenOakTree;
import com.gildedgames.the_aether.world.biome.decoration.AetherGenQuicksoil;
import com.gildedgames.the_aether.world.biome.decoration.AetherGenSkyrootTree;
import java.util.Calendar;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.feature.WorldGenDoublePlant;
import net.minecraft.world.gen.feature.WorldGenLakes;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.TerrainGen;

public class AetherBiomeDecorator
extends BiomeDecorator {
    public World world;
    public Random rand;
    public BiomeGenBase aetherBiome;
    public AetherGenFoilage foilage = new AetherGenFoilage();
    public AetherGenMinable ores = new AetherGenMinable();
    public AetherGenSkyrootTree skyroot_tree = new AetherGenSkyrootTree(false);
    public AetherGenDungeonOakTree golden_oak_tree_dungeon = new AetherGenDungeonOakTree();
    public AetherGenQuicksoil quicksoil_patches = new AetherGenQuicksoil();
    public AetherGenFloatingIsland crystal_island = new AetherGenFloatingIsland();
    public AetherGenLiquids liquid_overhang = new AetherGenLiquids();
    public AetherGenHolidayTree holiday_tree = new AetherGenHolidayTree();
    public AetherGenLakes aether_lakes = new AetherGenLakes();
    public AetherGenClouds clouds = new AetherGenClouds();
    private final WorldGenDoublePlant double_grass = new WorldGenDoublePlant();

    public void func_150512_a(World worldIn, Random random, BiomeGenBase biome, int x, int z) {
        if (this.world != null) {
            System.out.println("Already decorating");
        } else {
            this.world = worldIn;
            this.rand = random;
            this.field_76814_c = x;
            this.field_76811_d = z;
            this.aetherBiome = biome;
            this.func_150513_a(biome);
            this.world = null;
            this.rand = null;
        }
    }

    protected void func_150513_a(BiomeGenBase biome) {
        int i;
        int y;
        int z;
        int x;
        int i3;
        this.generateClouds(2, 4, 50, this.nextInt(64) + 96);
        this.generateClouds(1, 8, 26, this.nextInt(64) + 32);
        this.generateClouds(0, 16, 14, this.nextInt(64) + 64);
        if (this.shouldSpawn(37)) {
            this.crystal_island.func_76484_a(this.world, this.rand, this.field_76814_c + 8, this.nextInt(64) + 32, this.field_76811_d + 8);
        }
        if (this.shouldSpawn(3)) {
            this.spawnOre(BlocksAether.aether_dirt, 32, 20, 128);
        }
        this.generateFoilage(BlocksAether.white_flower);
        this.generateFoilage(BlocksAether.purple_flower);
        this.spawnOre(BlocksAether.icestone, 16, 10, 128);
        this.spawnOre(BlocksAether.ambrosium_ore, 16, 15, 128);
        this.spawnOre(BlocksAether.zanite_ore, 8, 12, 64);
        this.spawnOre(BlocksAether.gravitite_ore, 6, 8, 32);
        this.generateFoilage(BlocksAether.berry_bush);
        for (i3 = 0; i3 < 3; ++i3) {
            x = this.field_76814_c + this.nextInt(16) + 8;
            z = this.field_76811_d + this.nextInt(16) + 8;
            y = this.world.func_72976_f(x, z);
            this.getTree().func_76484_a(this.world, this.rand, x, y, z);
        }
        if ((AetherConfig.shouldLoadHolidayContent() || AetherConfig.allowSeasonalChristmas() && (Calendar.getInstance().get(2) + 1 == 12 || Calendar.getInstance().get(2) + 1 == 1)) && this.shouldSpawn(15)) {
            int x2 = this.field_76814_c + 8;
            int z2 = this.field_76811_d + 8;
            int y2 = this.world.func_72976_f(x2, z2);
            this.holiday_tree.func_76484_a(this.world, this.rand, x2, y2, z2);
        }
        for (i = 0; i < 25; ++i) {
            x = this.field_76814_c + this.nextInt(16);
            z = this.field_76811_d + this.nextInt(16);
            y = this.world.func_72976_f(x, z);
            this.golden_oak_tree_dungeon.func_76484_a(this.world, this.rand, x, y, z);
        }
        if (AetherConfig.tallgrassEnabled()) {
            for (i3 = 0; i3 < 10; ++i3) {
                int j7 = this.field_76814_c + this.rand.nextInt(16) + 8;
                int i11 = this.field_76811_d + this.rand.nextInt(16) + 8;
                int k14 = this.world.func_72800_K() * 2;
                if (k14 <= 0) continue;
                int l17 = this.rand.nextInt(k14);
                this.aetherBiome.func_76730_b(this.rand).func_76484_a(this.world, this.rand, j7, l17, i11);
            }
            if (TerrainGen.decorate((World)this.world, (Random)this.rand, (int)this.field_76814_c, (int)this.field_76811_d, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.GRASS)) {
                for (i = 0; i < 7; ++i) {
                    int j = this.field_76814_c + this.rand.nextInt(16) + 8;
                    int k = this.field_76811_d + this.rand.nextInt(16) + 8;
                    int l = this.rand.nextInt(this.world.func_72800_K() + 32);
                    this.double_grass.func_150548_a(2);
                    this.double_grass.func_76484_a(this.world, this.rand, j, l, k);
                }
            }
        }
        if (this.shouldSpawn(10)) {
            new WorldGenLakes(Blocks.field_150355_j).func_76484_a(this.world, this.rand, this.field_76814_c + this.rand.nextInt(16) + 8, this.rand.nextInt(256), this.field_76811_d + this.rand.nextInt(16) + 8);
        }
    }

    public int nextInt(int max) {
        return this.rand.nextInt(max);
    }

    public boolean shouldSpawn(int chance) {
        return this.nextInt(chance) == 0;
    }

    public WorldGenerator getTree() {
        return this.shouldSpawn(30) ? new AetherGenOakTree() : new AetherGenSkyrootTree(true);
    }

    public void generateFoilage(Block block) {
        this.foilage.setPlantBlock(block);
        for (int n = 0; n < 2; ++n) {
            this.foilage.func_76484_a(this.world, this.rand, this.field_76814_c + this.nextInt(16) + 8, this.nextInt(128), this.field_76811_d + this.nextInt(16) + 8);
        }
    }

    public void generateClouds(int meta, int amount, int chance, int y) {
        if (this.shouldSpawn(chance)) {
            this.clouds.setCloudMeta(meta);
            this.clouds.setCloudAmount(amount);
            this.clouds.func_76484_a(this.world, this.rand, this.field_76814_c + this.nextInt(16), this.nextInt(y), this.field_76811_d + this.nextInt(16));
        }
    }

    public void spawnOre(Block state, int size, int chance, int y) {
        this.ores.setSize(size);
        this.ores.setBlock(state);
        for (int chances = 0; chances < chance; ++chances) {
            this.ores.func_76484_a(this.world, this.rand, this.field_76814_c + this.nextInt(16), this.nextInt(y), this.field_76811_d + this.nextInt(16));
        }
    }
}

