/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.the_aether.world.gen;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;

public abstract class AetherStructure
extends StructureComponent {
    public int chance;
    public Block airState = Blocks.field_150350_a;
    public Block blockState;
    public Block extraBlockState;
    public int meta;
    public int extraMeta;
    public boolean replaceAir;
    public boolean replaceSolid;
    public Random random;
    public World worldObj;
    public StructureBoundingBox dungeonBoundingBox;
    private int startX;
    private int startY;
    private int startZ;

    public void setBlocks(Block blockState, int meta) {
        this.blockState = blockState;
        this.meta = 0;
        this.extraBlockState = null;
        this.extraMeta = 0;
        this.chance = 0;
    }

    public void setBlocks(Block blockState) {
        this.blockState = blockState;
        this.extraBlockState = null;
        this.chance = 0;
    }

    public void setBlocks(Block blockState, int meta, Block extraBlockState, int extraMeta, int chance) {
        this.blockState = blockState;
        this.meta = meta;
        this.extraBlockState = extraBlockState;
        this.extraMeta = extraMeta;
        this.chance = chance;
        if (this.chance < 1) {
            this.chance = 1;
        }
    }

    public void setBlocks(Block blockState, Block extraBlockState, int chance) {
        this.blockState = blockState;
        this.meta = 0;
        this.extraBlockState = extraBlockState;
        this.extraMeta = 0;
        this.chance = chance;
        if (this.chance < 1) {
            this.chance = 1;
        }
    }

    public void setStructureOffset(int x, int y, int z) {
        this.startX = x;
        this.startY = y;
        this.startZ = z;
    }

    public void addLineX(int x, int y, int z, int xRange) {
        for (int lineX = x; lineX < x + xRange; ++lineX) {
            Block block = this.getBlockState(lineX + this.startX, y + this.startY, z + this.startZ);
            if (!this.replaceAir && block == Blocks.field_150350_a || !this.replaceSolid && block != Blocks.field_150350_a) continue;
            this.setBlock(lineX + this.startX, y + this.startY, z + this.startZ);
        }
    }

    public void addLineY(int x, int y, int z, int yRange) {
        for (int lineY = y; lineY < y + yRange; ++lineY) {
            Block block = this.getBlockState(x + this.startX, lineY + this.startY, z + this.startZ);
            if (!this.replaceAir && block == Blocks.field_150350_a || !this.replaceSolid && block != Blocks.field_150350_a) continue;
            this.setBlock(x + this.startX, lineY + this.startY, z + this.startZ);
        }
    }

    public void addLineZ(int x, int y, int z, int zRange) {
        for (int lineZ = z; lineZ < z + zRange; ++lineZ) {
            Block block = this.getBlockState(x + this.startX, y + this.startY, lineZ + this.startZ);
            if (!this.replaceAir && block == Blocks.field_150350_a || !this.replaceSolid && block != Blocks.field_150350_a) continue;
            this.setBlock(x + this.startX, y + this.startY, lineZ + this.startZ);
        }
    }

    public void addPlaneX(int x, int y, int z, int yRange, int zRange) {
        for (int lineY = y; lineY < y + yRange; ++lineY) {
            for (int lineZ = z; lineZ < z + zRange; ++lineZ) {
                Block block = this.getBlockState(x + this.startX, lineY + this.startY, lineZ + this.startZ);
                if (!this.replaceAir && block == Blocks.field_150350_a || !this.replaceSolid && block != Blocks.field_150350_a) continue;
                this.setBlock(x + this.startX, lineY + this.startY, lineZ + this.startZ);
            }
        }
    }

    public void addPlaneY(int x, int y, int z, int xRange, int zRange) {
        for (int lineX = x; lineX < x + xRange; ++lineX) {
            for (int lineZ = z; lineZ < z + zRange; ++lineZ) {
                Block block = this.getBlockState(lineX + this.startX, y + this.startY, lineZ + this.startZ);
                if (!this.replaceAir && block == Blocks.field_150350_a || !this.replaceSolid && block != Blocks.field_150350_a) continue;
                this.setBlock(lineX + this.startX, y + this.startY, lineZ + this.startZ);
            }
        }
    }

    public void addPlaneZ(int x, int y, int z, int xRange, int yRange) {
        for (int lineX = x; lineX < x + xRange; ++lineX) {
            for (int lineY = y; lineY < y + yRange; ++lineY) {
                Block block = this.getBlockState(lineX + this.startX, lineY + this.startY, z + this.startZ);
                if (!this.replaceAir && block == Blocks.field_150350_a || !this.replaceSolid && block != Blocks.field_150350_a) continue;
                this.setBlock(lineX + this.startX, lineY + this.startY, z + this.startZ);
            }
        }
    }

    public void addHollowBox(int x, int y, int z, int xRange, int yRange, int zRange) {
        Block temp1 = this.blockState;
        Block temp2 = this.extraBlockState;
        this.setBlocks(this.airState, this.airState, this.chance);
        this.addSolidBox(x, y, z, xRange, yRange, zRange);
        this.setBlocks(temp1, temp2, this.chance);
        this.addPlaneY(x, y, z, xRange, zRange);
        this.addPlaneY(x, y + (yRange - 1), z, xRange, zRange);
        this.addPlaneX(x, y, z, yRange, zRange);
        this.addPlaneX(x + (xRange - 1), y, z, yRange, zRange);
        this.addPlaneZ(x, y, z, xRange, yRange);
        this.addPlaneZ(x, y, z + (zRange - 1), xRange, yRange);
    }

    public void addSquareTube(int x, int y, int z, int xRange, int yRange, int zRange, int angel) {
        Block temp1 = this.blockState;
        Block temp2 = this.extraBlockState;
        this.setBlocks(this.airState, this.airState, this.chance);
        this.addSolidBox(x, y, z, xRange, yRange, zRange);
        this.setBlocks(temp1, temp2, this.chance);
        if (angel == 0 || angel == 2) {
            this.addPlaneY(x, y, z, xRange, zRange);
            this.addPlaneY(x, y + (yRange - 1), z, xRange, zRange);
        }
        if (angel == 1 || angel == 2) {
            this.addPlaneX(x, y, z, yRange, zRange);
            this.addPlaneX(x + (xRange - 1), y, z, yRange, zRange);
        }
        if (angel == 0 || angel == 1) {
            this.addPlaneZ(x, y, z, xRange, yRange);
            this.addPlaneZ(x, y, z + (zRange - 1), xRange, yRange);
        }
    }

    public void addSolidBox(int x, int y, int z, int xRange, int yRange, int zRange) {
        for (int lineX = x; lineX < x + xRange; ++lineX) {
            for (int lineY = y; lineY < y + yRange; ++lineY) {
                for (int lineZ = z; lineZ < z + zRange; ++lineZ) {
                    Block block = this.getBlockState(lineX + this.startX, lineY + this.startY, lineZ + this.startZ);
                    if (!this.replaceAir && block == Blocks.field_150350_a || !this.replaceSolid && block != Blocks.field_150350_a) continue;
                    this.setBlock(lineX + this.startX, lineY + this.startY, lineZ + this.startZ);
                }
            }
        }
    }

    public boolean isBoxSolid(int x, int y, int z, int xRange, int yRange, int zRange) {
        boolean flag = true;
        for (int lineX = x; lineX < x + xRange; ++lineX) {
            for (int lineY = y; lineY < y + yRange; ++lineY) {
                for (int lineZ = z; lineZ < z + zRange; ++lineZ) {
                    if (this.getBlockState(lineX + this.startX, lineY + this.startY, lineZ + this.startZ) != Blocks.field_150350_a) continue;
                    flag = false;
                }
            }
        }
        return flag;
    }

    public boolean isBoxEmpty(int x, int y, int z, int xRange, int yRange, int zRange) {
        boolean flag = true;
        for (int lineX = x; lineX < x + xRange; ++lineX) {
            for (int lineY = y; lineY < y + yRange; ++lineY) {
                for (int lineZ = z; lineZ < z + zRange; ++lineZ) {
                    if (this.getBlockState(lineX + this.startX, lineY + this.startY, lineZ + this.startZ) == Blocks.field_150350_a) continue;
                    flag = false;
                }
            }
        }
        return flag;
    }

    public TileEntity getTileEntityFromPosWithOffset(int x, int y, int z) {
        return !this.dungeonBoundingBox.func_78890_b(this.getActualX(x, z), this.getActualY(y), this.getActualZ(x, z)) ? null : this.worldObj.func_147438_o(this.getActualX(x, z), this.getActualY(y), this.getActualZ(x, z));
    }

    public Block getBlockStateWithOffset(int x, int y, int z) {
        return this.func_151548_a(this.worldObj, x + this.startX, y + this.startY, z + this.startZ, this.dungeonBoundingBox);
    }

    public Block getBlockState(int x, int y, int z) {
        return this.func_151548_a(this.worldObj, x, y, z, this.dungeonBoundingBox);
    }

    public void setBlockWithOffset(int x, int y, int z, Block state, int meta) {
        this.func_151550_a(this.worldObj, state, meta, x + this.startX, y + this.startY, z + this.startZ, this.dungeonBoundingBox);
    }

    public void setBlock(int x, int y, int z, Block state, int meta) {
        this.func_151550_a(this.worldObj, state, meta, x, y, z, this.dungeonBoundingBox);
    }

    public void setBlockWithOffset(int x, int y, int z) {
        if (this.chance == 0) {
            this.setBlock(x + this.startX, y + this.startY, z + this.startZ, this.blockState, this.meta);
            return;
        }
        if (this.random.nextInt(this.chance) == 0) {
            this.func_151550_a(this.worldObj, this.extraBlockState, this.extraMeta, x + this.startX, y + this.startY, z + this.startZ, this.dungeonBoundingBox);
        } else {
            this.func_151550_a(this.worldObj, this.blockState, this.meta, x + this.startX, y + this.startY, z + this.startZ, this.dungeonBoundingBox);
        }
    }

    public void setBlock(int x, int y, int z) {
        if (this.chance == 0) {
            this.setBlock(x, y, z, this.blockState, this.meta);
            return;
        }
        if (this.random.nextInt(this.chance) == 0) {
            this.func_151550_a(this.worldObj, this.extraBlockState, this.extraMeta, x, y, z, this.dungeonBoundingBox);
        } else {
            this.func_151550_a(this.worldObj, this.blockState, this.meta, x, y, z, this.dungeonBoundingBox);
        }
    }

    public boolean spawnEntity(Entity entity, int structureX, int structureY, int structureZ) {
        int posZ;
        int posY;
        int posX = this.getActualX(structureX, structureZ);
        if (this.dungeonBoundingBox.func_78890_b(posX, posY = this.getActualY(structureY), posZ = this.getActualZ(structureX, structureZ))) {
            entity.func_70012_b((double)posX + 0.5, (double)posY + 0.5, (double)posZ + 0.5, 0.0f, 0.0f);
            if (entity instanceof EntityLivingBase) {
                EntityLivingBase livingEntity = (EntityLivingBase)entity;
                livingEntity.func_70691_i(livingEntity.func_110138_aP());
            }
            if (!this.worldObj.field_72995_K) {
                this.worldObj.func_72838_d(entity);
            }
            return true;
        }
        return false;
    }

    public int getActualX(int structureX, int structureZ) {
        return this.func_74865_a(structureX + this.startX, structureZ + this.startZ);
    }

    public int getActualY(int structureY) {
        return this.func_74862_a(structureY + this.startY);
    }

    public int getActualZ(int structureX, int structureZ) {
        return this.func_74873_b(structureX + this.startX, structureZ + this.startZ);
    }

    public boolean func_74875_a(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
        this.worldObj = worldIn;
        this.random = randomIn;
        this.dungeonBoundingBox = structureBoundingBoxIn;
        return this.generate();
    }

    public abstract boolean generate();

    protected void func_143012_a(NBTTagCompound tagCompound) {
    }

    protected void func_143011_b(NBTTagCompound tagCompound) {
    }
}

