/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.the_aether.world.gen;

import com.gildedgames.the_aether.world.gen.components.ComponentSilverDungeon;
import com.gildedgames.the_aether.world.util.RandomTracker;
import java.util.Random;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.StructureStart;

public class MapGenSilverDungeon
extends MapGenStructure {
    public String func_143025_a() {
        return "aether_legacy:silver_dungeon";
    }

    protected boolean func_75047_a(int chunkX, int chunkZ) {
        RandomTracker randomTracker = new RandomTracker();
        if (randomTracker.testRandom(this.field_75038_b, 110) != 0 && randomTracker.testRandom(this.field_75038_b, 150) != 0) {
            return false;
        }
        return chunkX % 6 == 0 && chunkZ % 6 == 0;
    }

    protected StructureStart func_75049_b(int chunkX, int chunkZ) {
        return new Start(this.field_75039_c, this.field_75038_b, chunkX, chunkZ);
    }

    public static class Start
    extends StructureStart {
        private int firstStaircaseZ;
        private int secondStaircaseZ;
        private int finalStaircaseZ;
        private int xTendency;
        private int zTendency;

        public Start() {
        }

        public Start(World worldIn, Random random, int chunkX, int chunkZ) {
            super(chunkX, chunkZ);
            this.create(worldIn, random, chunkX, chunkZ);
        }

        private void create(World worldIn, Random random, int chunkX, int chunkZ) {
            random.setSeed(worldIn.func_72905_C());
            long i = random.nextLong();
            long j = random.nextLong();
            long k = (long)chunkX * i;
            long l = (long)chunkZ * j;
            random.setSeed(k ^ l ^ worldIn.func_72905_C());
            ComponentSilverDungeon dungeon = new ComponentSilverDungeon((chunkX << 4) + 2, (chunkZ << 4) + 2);
            this.firstStaircaseZ = random.nextInt(3);
            this.secondStaircaseZ = random.nextInt(3);
            this.finalStaircaseZ = random.nextInt(3);
            this.xTendency = random.nextInt(3) - 1;
            this.zTendency = random.nextInt(3) - 1;
            dungeon.setStaircasePosition(this.firstStaircaseZ, this.secondStaircaseZ, this.finalStaircaseZ);
            dungeon.setCloudTendencies(this.xTendency, this.zTendency);
            dungeon.func_74874_b().func_78886_a(0, random.nextInt(64), 0);
            this.field_75075_a.add(dungeon);
            this.func_75072_c();
        }

        public void func_143022_a(NBTTagCompound tagCompound) {
            super.func_143022_a(tagCompound);
            tagCompound.func_74768_a("firstStaircaseZ", this.firstStaircaseZ);
            tagCompound.func_74768_a("secondStaircaseZ", this.secondStaircaseZ);
            tagCompound.func_74768_a("finalStaircaseZ", this.finalStaircaseZ);
            tagCompound.func_74768_a("xTendency", this.xTendency);
            tagCompound.func_74768_a("zTendency", this.zTendency);
        }

        public void func_143017_b(NBTTagCompound tagCompound) {
            super.func_143017_b(tagCompound);
            this.firstStaircaseZ = tagCompound.func_74762_e("firstStaircaseZ");
            this.secondStaircaseZ = tagCompound.func_74762_e("secondStaircaseZ");
            this.finalStaircaseZ = tagCompound.func_74762_e("finalStaircaseZ");
            this.xTendency = tagCompound.func_74762_e("zTendency");
            this.zTendency = tagCompound.func_74762_e("zTendency");
        }
    }
}

