/*
 * Decompiled with CFR 0.152.
 */
package evilcraft;

import com.google.common.collect.Sets;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLServerStoppingEvent;
import cpw.mods.fml.common.network.FMLEventChannel;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import evilcraft.Achievements;
import evilcraft.Configs;
import evilcraft.GeneralConfig;
import evilcraft.IInitListener;
import evilcraft.Recipes;
import evilcraft.VersionStats;
import evilcraft.block.EnvironmentalAccumulatorConfig;
import evilcraft.client.gui.GuiHandler;
import evilcraft.client.gui.container.GuiMainMenuEvilifier;
import evilcraft.command.CommandEvilCraft;
import evilcraft.core.Debug;
import evilcraft.core.IMCHandler;
import evilcraft.core.config.ConfigHandler;
import evilcraft.core.helper.LoggerHelper;
import evilcraft.event.ServerStatusEventHook;
import evilcraft.infobook.InfoBookRegistry;
import evilcraft.modcompat.ModCompatLoader;
import evilcraft.proxy.CommonProxy;
import evilcraft.world.gen.DarkTempleGenerator;
import evilcraft.world.gen.EvilDungeonGenerator;
import evilcraft.world.gen.OreGenerator;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.command.ICommand;
import org.apache.logging.log4j.Level;

@Mod(modid="evilcraft", name="EvilCraft", useMetadata=true, version="0.9.13", dependencies="required-after:Forge@[10.13.3.1360,);after:ThermalExpansion", guiFactory="evilcraft.core.client.gui.config.ExtendedConfigGuiFactory")
public class EvilCraft {
    @SidedProxy(clientSide="evilcraft.proxy.ClientProxy", serverSide="evilcraft.proxy.CommonProxy")
    public static CommonProxy proxy;
    @Mod.Instance(value="evilcraft")
    public static EvilCraft _instance;
    public static File CONFIG_FOLDER;
    public static FMLEventChannel channel;
    private static final Set<IInitListener> initListeners;
    public static final IMCHandler IMC_HANDLER;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        LoggerHelper.init();
        LoggerHelper.log(Level.INFO, "preInit()");
        String rootFolderName = event.getModConfigurationDirectory() + "/" + "evilcraft";
        CONFIG_FOLDER = new File(rootFolderName);
        if (!CONFIG_FOLDER.exists()) {
            CONFIG_FOLDER.mkdir();
        }
        Configs.getInstance().registerGeneralConfigs();
        ConfigHandler.getInstance().handle(event);
        Configs.getInstance().registerVanillaDictionary();
        Configs.getInstance().registerConfigs();
        EvilCraft.callInitStepListeners(IInitListener.Step.PREINIT);
        if (GeneralConfig.debug) {
            Debug.checkPreConfigurables(Configs.getInstance().configs);
        }
        ConfigHandler.getInstance().handle(event);
        if (GeneralConfig.debug) {
            Debug.checkPostConfigurables();
        }
        proxy.registerEventHooks();
        VersionStats.load();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        LoggerHelper.log(Level.INFO, "init()");
        GameRegistry.registerWorldGenerator((IWorldGenerator)new OreGenerator(), (int)5);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new EvilDungeonGenerator(), (int)2);
        if (Configs.isEnabled(EnvironmentalAccumulatorConfig.class)) {
            GameRegistry.registerWorldGenerator((IWorldGenerator)new DarkTempleGenerator(), (int)1);
        }
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new GuiHandler());
        if (event.getSide() == Side.CLIENT) {
            GuiMainMenuEvilifier.evilifyMainMenu();
        }
        proxy.registerRenderers();
        proxy.registerKeyBindings();
        proxy.registerPacketHandlers();
        proxy.registerTickHandlers();
        Recipes.registerRecipes(CONFIG_FOLDER);
        Achievements.registerAchievements();
        EvilCraft.callInitStepListeners(IInitListener.Step.INIT);
        InfoBookRegistry.getInstance();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        LoggerHelper.log(Level.INFO, "postInit()");
        EvilCraft.callInitStepListeners(IInitListener.Step.POSTINIT);
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandEvilCraft());
    }

    @Mod.EventHandler
    public void onServerStarted(FMLServerStartedEvent event) {
        ServerStatusEventHook.getInstance().onStartedEvent(event);
    }

    @Mod.EventHandler
    public void onServerStopping(FMLServerStoppingEvent event) {
        ServerStatusEventHook.getInstance().onStoppingEvent(event);
    }

    @Mod.EventHandler
    public void onIMC(FMLInterModComms.IMCEvent event) {
        IMC_HANDLER.handle(event);
    }

    public static void log(String message) {
        EvilCraft.log(message, Level.INFO);
    }

    public static void log(String message, Level level) {
        LoggerHelper.log(level, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addInitListeners(IInitListener initListener) {
        Set<IInitListener> set = initListeners;
        synchronized (set) {
            initListeners.add(initListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<IInitListener> getSafeInitListeners() {
        HashSet clonedInitListeners;
        Set<IInitListener> set = initListeners;
        synchronized (set) {
            clonedInitListeners = Sets.newHashSet(initListeners);
        }
        return clonedInitListeners;
    }

    private static void callInitStepListeners(IInitListener.Step step) {
        for (IInitListener initListener : EvilCraft.getSafeInitListeners()) {
            initListener.onInit(step);
        }
    }

    static {
        CONFIG_FOLDER = null;
        initListeners = Sets.newHashSet();
        EvilCraft.addInitListeners(new ModCompatLoader());
        IMC_HANDLER = new IMCHandler();
    }
}

