/*
 * Decompiled with CFR 0.152.
 */
package evilcraft;

import evilcraft.core.config.ConfigurableProperty;
import evilcraft.core.config.ConfigurableType;
import evilcraft.core.config.ConfigurableTypeCategory;
import evilcraft.core.config.extendedconfig.DummyConfig;
import evilcraft.core.fluid.BloodFluidConverter;

public class GeneralConfig
extends DummyConfig {
    @ConfigurableProperty(category=ConfigurableTypeCategory.CORE, comment="Config version for EvilCraft.\nDO NOT EDIT MANUALLY!")
    public static String version = "0.9.13";
    @ConfigurableProperty(category=ConfigurableTypeCategory.CORE, comment="Set 'true' to enable development debug mode. This will result in a lower performance!", requiresMcRestart=true)
    public static boolean debug = false;
    @ConfigurableProperty(category=ConfigurableTypeCategory.CORE, comment="If the recipe loader should crash when finding invalid recipes.", requiresMcRestart=true)
    public static boolean crashOnInvalidRecipe = true;
    @ConfigurableProperty(category=ConfigurableTypeCategory.CORE, comment="If mod compatibility loader should crash hard if errors occur in that process.", requiresMcRestart=true)
    public static boolean crashOnModCompatCrash = false;
    @ConfigurableProperty(category=ConfigurableTypeCategory.GENERAL, comment="Evil stuff...", isCommandable=true)
    public static boolean dieWithoutAnyReason = false;
    @ConfigurableProperty(category=ConfigurableTypeCategory.CORE, comment="If the version checker should be enabled.")
    public static boolean versionChecker = true;
    @ConfigurableProperty(category=ConfigurableTypeCategory.GENERAL, comment="Server-side: If farting is enabled on this server; Client-side: If farting can be seen at your client.", isCommandable=true)
    public static boolean farting = true;
    @ConfigurableProperty(category=ConfigurableTypeCategory.FLUID, comment="The allowed blood conversions with their ratio. (ratio 2 means that this fluid is 1mB of this fluid can be converted into 2mB of EvilCraft Blood.", changedCallback=BloodFluidConverter.BloodConvertersChanged.class)
    public static String[] bloodConverters = new String[]{"blood:1.0", "life essence:1.0", "hell_blood:1.0"};
    @ConfigurableProperty(category=ConfigurableTypeCategory.GENERAL, comment="If retro-generation of ores should be enabled. WARNING: This could cause lag if permanently enabled.", isCommandable=true)
    public static boolean retrogen = false;
    public static ConfigurableType TYPE = ConfigurableType.DUMMY;
    @ConfigurableProperty(category=ConfigurableTypeCategory.WORLDGENERATION, comment="Spawn extra netherfish blocks in all biomes.")
    public static boolean extraSilverfish = false;
    @ConfigurableProperty(category=ConfigurableTypeCategory.WORLDGENERATION, comment="Minimum block height at which a dark temple can spawn.")
    public static int darkTempleMinHeight = 60;
    @ConfigurableProperty(category=ConfigurableTypeCategory.WORLDGENERATION, comment="Maximum block height at which a dark temple can spawn.")
    public static int darkTempleMaxHeight = 256;
    @ConfigurableProperty(category=ConfigurableTypeCategory.WORLDGENERATION, comment="Frequency at which dark temples should occur. 1 means every chunk, 100 means every 100th chunk.")
    public static int darkTempleFrequency = 250;
    @ConfigurableProperty(category=ConfigurableTypeCategory.WORLDGENERATION, comment="Maximal length of the pillars of a dark temple.")
    public static int darkTempleMaxPillarLength = 20;
    @ConfigurableProperty(category=ConfigurableTypeCategory.WORLDGENERATION, comment="Whitelisted dimensions in which dark temples can generate.")
    public static int[] darkTempleDimensions = new int[]{0};
    @ConfigurableProperty(category=ConfigurableTypeCategory.GENERAL, comment="The amount of mB that can flow per tick out of machines and items.", requiresMcRestart=true)
    public static int mbFlowRate = 100;
    @ConfigurableProperty(category=ConfigurableTypeCategory.CORE, comment="The minimum array size of potion types, increase to allow for more potion types.", requiresMcRestart=true)
    public static int minimumPotionTypesArraySize = 256;
    @ConfigurableProperty(category=ConfigurableTypeCategory.GENERAL, comment="[Thaumcraft] If temporary warp should be added when hit by a Vengeance Spirit.", requiresMcRestart=true)
    public static boolean thaumcraftVengeanceSpiritWarp = true;
    public static int silverfish_BlocksPerVein = 4;
    public static int silverfish_VeinsPerChunk = 10;
    public static int silverfish_StartY = 6;
    public static int silverfish_EndY = 66;

    public GeneralConfig() {
        super(true, "general", null, GeneralConfig.class);
    }

    @Override
    public void onRegistered() {
        if (!version.equals("0.9.13")) {
            System.err.println("The config file of EvilCraft is out of date and might cause problems, please remove it so it can be regenerated.");
        }
    }

    @Override
    public boolean isEnabled() {
        return true;
    }
}

