/*
 * Decompiled with CFR 0.152.
 */
package evilcraft;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import cpw.mods.fml.common.registry.GameRegistry;
import evilcraft.Configs;
import evilcraft.GeneralConfig;
import evilcraft.block.BoxOfEternalClosure;
import evilcraft.block.BoxOfEternalClosureConfig;
import evilcraft.block.DarkTank;
import evilcraft.block.DarkTankConfig;
import evilcraft.block.EntangledChalice;
import evilcraft.block.EntangledChaliceConfig;
import evilcraft.block.EntangledChaliceItem;
import evilcraft.block.EnvironmentalAccumulator;
import evilcraft.block.EnvironmentalAccumulatorConfig;
import evilcraft.core.config.extendedconfig.ExtendedConfig;
import evilcraft.core.item.ItemBlockFluidContainer;
import evilcraft.core.recipe.ItemBlockFluidContainerCombinationRecipe;
import evilcraft.core.recipe.custom.EnvironmentalAccumulatorRecipeComponent;
import evilcraft.core.recipe.custom.EnvironmentalAccumulatorRecipeProperties;
import evilcraft.core.recipe.event.IRecipeOutputObserver;
import evilcraft.core.recipe.event.ObservableShapedRecipe;
import evilcraft.core.recipe.event.ObservableShapelessRecipe;
import evilcraft.core.recipe.xml.XmlRecipeLoader;
import evilcraft.core.weather.WeatherType;
import evilcraft.enchantment.EnchantmentPoisonTip;
import evilcraft.enchantment.EnchantmentPoisonTipConfig;
import evilcraft.item.BiomeExtract;
import evilcraft.item.BiomeExtractConfig;
import evilcraft.item.BloodContainer;
import evilcraft.item.BloodContainerConfig;
import evilcraft.item.BloodExtractorConfig;
import evilcraft.item.CorruptedTearConfig;
import evilcraft.item.DarkGem;
import evilcraft.item.DarkGemConfig;
import evilcraft.item.InvertedPotentia;
import evilcraft.item.InvertedPotentiaConfig;
import evilcraft.item.PotentiaSphereConfig;
import evilcraft.item.VeinSword;
import evilcraft.item.VeinSwordConfig;
import evilcraft.item.VengeancePickaxe;
import evilcraft.item.VengeancePickaxeConfig;
import evilcraft.item.WeatherContainer;
import evilcraft.item.WeatherContainerConfig;
import evilcraft.recipe.BloodExtractorCombinationRecipe;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.RecipeSorter;

public class Recipes {
    private static final String[] RECIPES_FILES = new String[]{"shaped.xml", "shapeless.xml", "smelting.xml", "bloodinfuser.xml", "bloodinfuser_convenience.xml", "bloodinfuser_mods.xml", "environmentalaccumulator.xml"};
    private static final String RECIPES_BASE_PATH = "/assets/evilcraft/recipes/";
    private static final String RECIPES_XSD_PATH = "/assets/evilcraft/recipes/recipes.xsd";
    private static final Pattern EXTERNAL_RECIPES_PATTERN = Pattern.compile("^[^_].*\\.xml");
    private static final String EXTERNAL_OVERRIDE_RECIPES = "_override";
    public static final Multimap<String, ItemStack> taggedOutput = LinkedListMultimap.create();
    public static final Multimap<String, ExtendedConfig<?>> taggedConfigurablesOutput = LinkedListMultimap.create();
    public static Map<Item, FluidStack> BUCKETS = new HashMap<Item, FluidStack>();

    private static void loadPredefineds() {
        if (Configs.isEnabled(EnchantmentPoisonTipConfig.class)) {
            ItemStack poisonTipEnchant = new ItemStack((Item)Items.field_151134_bR);
            EnchantmentPoisonTip enchant = EnchantmentPoisonTip.getInstance();
            Items.field_151134_bR.func_92115_a(poisonTipEnchant, new EnchantmentData((Enchantment)enchant, enchant.func_77319_d()));
            XmlRecipeLoader.registerPredefinedItem("evilcraft:enchanted_book_poisonTip", poisonTipEnchant);
        }
        if (Configs.isEnabled(WeatherContainerConfig.class)) {
            ItemStack lightningWeatherContainer = new ItemStack((Item)WeatherContainer.getInstance(), 1, WeatherContainer.WeatherContainerTypes.LIGHTNING.ordinal());
            XmlRecipeLoader.registerPredefinedItem("evilcraft:lightningWeatherContainer", lightningWeatherContainer);
        }
        if (Configs.isEnabled(InvertedPotentiaConfig.class)) {
            ItemStack invertedPotentiaEmpowered = new ItemStack((Item)InvertedPotentia.getInstance(), 1, 1);
            XmlRecipeLoader.registerPredefinedItem("evilcraft:invertedPotentiaEmpowered", invertedPotentiaEmpowered);
        }
        if (Configs.isEnabled(VengeancePickaxeConfig.class)) {
            ItemStack vengeancePickaxeFortune = VengeancePickaxe.createCraftingResult();
            XmlRecipeLoader.registerPredefinedItem("evilcraft:vengeancePickaxeFortune", vengeancePickaxeFortune);
        }
        if (Configs.isEnabled(BoxOfEternalClosureConfig.class)) {
            ItemStack boxOfEternalClosureFilled = new ItemStack((Block)BoxOfEternalClosure.getInstance());
            BoxOfEternalClosure.setVengeanceSwarmContent(boxOfEternalClosureFilled);
            XmlRecipeLoader.registerPredefinedItem("evilcraft:boxOfEternalClosureFilled", boxOfEternalClosureFilled);
        }
        if (Configs.isEnabled(InvertedPotentiaConfig.class)) {
            ItemStack empoweredInvertedPotentia = new ItemStack((Item)InvertedPotentia.getInstance());
            InvertedPotentia.getInstance().empower(empoweredInvertedPotentia);
            XmlRecipeLoader.registerPredefinedItem("evilcraft:empoweredInvertedPotentia", empoweredInvertedPotentia);
        }
        if (Configs.isEnabled(DarkTankConfig.class)) {
            ItemStack darkTankx9 = new ItemStack((Block)DarkTank.getInstance());
            ItemBlockFluidContainer item = (ItemBlockFluidContainer)darkTankx9.func_77973_b();
            item.setCapacity(darkTankx9, item.getCapacity(darkTankx9) * 9);
            XmlRecipeLoader.registerPredefinedItem("evilcraft:darkTankx9", darkTankx9);
        }
        if (PotentiaSphereConfig.enderPearlRecipe) {
            XmlRecipeLoader.registerPredefinedValue("evilcraft:enderPearlRecipe");
        }
        if (Configs.isEnabled(VeinSwordConfig.class)) {
            ItemStack veinSwordLooting = VeinSword.createCraftingResult();
            XmlRecipeLoader.registerPredefinedItem("evilcraft:veinSwordLooting", veinSwordLooting);
        }
        if (WeatherContainerConfig.shapelessRecipes) {
            XmlRecipeLoader.registerPredefinedValue("evilcraft:shapelessRecipes");
        }
    }

    private static XmlRecipeLoader registerRecipesForFile(InputStream is, String fileName, boolean canOverride) throws XmlRecipeLoader.XmlRecipeException {
        return new XmlRecipeLoader(is, fileName);
    }

    private static List<XmlRecipeLoader> registerRecipesForFiles(File file, Map<String, XmlRecipeLoader> internalLoaders, boolean canOverride) throws XmlRecipeLoader.XmlRecipeException {
        File[] childFiles;
        if (file.isFile() && EXTERNAL_RECIPES_PATTERN.matcher(file.getName()).matches()) {
            try {
                XmlRecipeLoader loader = Recipes.registerRecipesForFile(new FileInputStream(file), file.getName(), canOverride);
                if (!internalLoaders.containsKey(file.getName()) || !canOverride) {
                    return Lists.newArrayList((Object[])new XmlRecipeLoader[]{loader});
                }
                internalLoaders.put(file.getName(), loader);
            }
            catch (FileNotFoundException loader) {}
        } else if (file.isDirectory() && (childFiles = file.listFiles()) != null) {
            LinkedList loaders = Lists.newLinkedList();
            for (File childFile : childFiles) {
                loaders.addAll(Recipes.registerRecipesForFiles(childFile, internalLoaders, EXTERNAL_OVERRIDE_RECIPES.equals(file.getName())));
            }
        }
        return Collections.emptyList();
    }

    private static void loadAllRecipes(Collection<XmlRecipeLoader> loaders) {
        for (XmlRecipeLoader loader : loaders) {
            InputStream xsdIs = Recipes.class.getResourceAsStream(RECIPES_XSD_PATH);
            loader.setValidator(xsdIs);
            loader.loadRecipes(GeneralConfig.crashOnInvalidRecipe);
        }
    }

    public static void registerRecipes(File rootConfigFolder) throws XmlRecipeLoader.XmlRecipeException {
        RecipeSorter.register((String)"evilcraftobservableshapeless", ObservableShapelessRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:forge:shapelessore");
        RecipeSorter.register((String)"evilcraftobservableshaped", ObservableShapedRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:forge:shapedore");
        RecipeSorter.register((String)"evilcraftcontainercombination", ItemBlockFluidContainerCombinationRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:forge:shapedore");
        RecipeSorter.register((String)"evilcraftbloodextractorcombination", BloodExtractorCombinationRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:forge:shapedore");
        Recipes.loadPredefineds();
        HashMap internalLoaders = Maps.newHashMapWithExpectedSize((int)RECIPES_FILES.length);
        for (String file : RECIPES_FILES) {
            InputStream is = Recipes.class.getResourceAsStream(RECIPES_BASE_PATH + file);
            internalLoaders.put(file, Recipes.registerRecipesForFile(is, file, true));
        }
        List<XmlRecipeLoader> externalLoaders = Recipes.registerRecipesForFiles(rootConfigFolder, internalLoaders, false);
        Recipes.loadAllRecipes(internalLoaders.values());
        Recipes.loadAllRecipes(externalLoaders);
        Recipes.registerCustomRecipes();
    }

    private static void registerCustomRecipes() {
        int i;
        if (Configs.isEnabled(BloodContainerConfig.class) && Configs.isEnabled(DarkTankConfig.class)) {
            for (i = 0; i < BloodContainerConfig.getContainerLevels(); ++i) {
                ItemStack input = new ItemStack((Item)BloodContainer.getInstance(), 1, i);
                if (BloodContainer.getInstance().isCreativeItem(input)) continue;
                final int capacity = BloodContainer.getInstance().getCapacity(input);
                ItemStack result = new ItemStack((Block)DarkTank.getInstance());
                GameRegistry.addRecipe((IRecipe)new ObservableShapelessRecipe(result, new Object[]{input}, new IRecipeOutputObserver(){

                    @Override
                    public ItemStack getRecipeOutput(InventoryCrafting grid, ItemStack output) {
                        ItemBlockFluidContainer container = (ItemBlockFluidContainer)output.func_77973_b();
                        container.setCapacity(output, capacity);
                        ItemStack input = null;
                        for (int j = 0; j < grid.func_70302_i_(); ++j) {
                            ItemStack element = grid.func_70301_a(j);
                            if (element == null || element.func_77973_b() != BloodContainer.getInstance()) continue;
                            input = element;
                        }
                        if (input == null) {
                            return null;
                        }
                        FluidStack resource = BloodContainer.getInstance().getFluid(input);
                        if (resource != null && resource.amount > 0) {
                            container.fill(output, resource, true);
                        }
                        return output;
                    }
                }));
            }
        }
        if (Configs.isEnabled(EntangledChaliceConfig.class) && Configs.isEnabled(DarkGemConfig.class) && Configs.isEnabled(CorruptedTearConfig.class)) {
            Item tear = CorruptedTearConfig._instance.getItemInstance();
            GameRegistry.addRecipe((IRecipe)new ObservableShapedRecipe(3, 3, new ItemStack[]{new ItemStack(Items.field_151043_k), new ItemStack(tear), new ItemStack(Items.field_151043_k), new ItemStack((Item)DarkGem.getInstance()), new ItemStack(Items.field_151043_k), new ItemStack((Item)DarkGem.getInstance()), new ItemStack(Items.field_151043_k), new ItemStack(Items.field_151043_k), new ItemStack(Items.field_151043_k)}, new ItemStack(Item.func_150898_a((Block)EntangledChalice.getInstance()), 2), new IRecipeOutputObserver(){

                @Override
                public ItemStack getRecipeOutput(InventoryCrafting craftingGrid, ItemStack output) {
                    ItemStack newStack = output.func_77946_l();
                    EntangledChaliceItem item = (EntangledChaliceItem)Item.func_150898_a((Block)EntangledChalice.getInstance());
                    item.setNextTankID(newStack);
                    return newStack;
                }
            }));
            GameRegistry.addRecipe((IRecipe)new ObservableShapedRecipe(3, 3, new ItemStack[]{new ItemStack(Items.field_151043_k), new ItemStack(tear), new ItemStack(Items.field_151043_k), new ItemStack((Item)DarkGem.getInstance()), new ItemStack(Item.func_150898_a((Block)EntangledChalice.getInstance()), 1, Short.MAX_VALUE), new ItemStack((Item)DarkGem.getInstance()), new ItemStack(Items.field_151043_k), new ItemStack(Items.field_151043_k), new ItemStack(Items.field_151043_k)}, new ItemStack(Item.func_150898_a((Block)EntangledChalice.getInstance()), 2), new IRecipeOutputObserver(){

                @Override
                public ItemStack getRecipeOutput(InventoryCrafting craftingGrid, ItemStack output) {
                    ItemStack newStack = output.func_77946_l();
                    EntangledChaliceItem item = (EntangledChaliceItem)Item.func_150898_a((Block)EntangledChalice.getInstance());
                    String tankID = item.getTankID(craftingGrid.func_70301_a(4));
                    item.setTankID(newStack, tankID);
                    return newStack;
                }
            }));
        }
        if (Configs.isEnabled(DarkTankConfig.class)) {
            for (i = 1; i < 9; ++i) {
                ItemBlockFluidContainer tankItem = (ItemBlockFluidContainer)Item.func_150898_a((Block)DarkTank.getInstance());
                GameRegistry.addRecipe((IRecipe)new ItemBlockFluidContainerCombinationRecipe(i, tankItem));
            }
        }
        if (Configs.isEnabled(BloodExtractorConfig.class) && Configs.isEnabled(DarkTankConfig.class)) {
            for (i = 1; i < 9; ++i) {
                GameRegistry.addRecipe((IRecipe)new BloodExtractorCombinationRecipe(i));
            }
        }
        if (Configs.isEnabled(EnvironmentalAccumulatorConfig.class)) {
            ItemStack outputStack = null;
            String recipeName = null;
            if (Configs.isEnabled(WeatherContainerConfig.class)) {
                ItemStack emptyContainer = WeatherContainer.createItemStack(WeatherContainer.WeatherContainerTypes.EMPTY, 1);
                WeatherType[] weatherInputs = new WeatherType[]{WeatherType.CLEAR, WeatherType.LIGHTNING, WeatherType.RAIN};
                WeatherType[] weatherOutputs = new WeatherType[]{WeatherType.RAIN, WeatherType.RAIN, WeatherType.CLEAR};
                for (int i2 = 0; i2 < weatherInputs.length; ++i2) {
                    recipeName = "WeatherContainer" + weatherInputs[i2].getClass().getSimpleName();
                    outputStack = WeatherContainer.createItemStack(WeatherContainer.WeatherContainerTypes.getWeatherContainerType(weatherInputs[i2]), 1);
                    EnvironmentalAccumulator.getInstance().getRecipeRegistry().registerRecipe(recipeName, new EnvironmentalAccumulatorRecipeComponent(emptyContainer, weatherInputs[i2]), new EnvironmentalAccumulatorRecipeComponent(outputStack, weatherOutputs[i2]), new EnvironmentalAccumulatorRecipeProperties());
                }
            }
            if (Configs.isEnabled(BiomeExtractConfig.class) && BiomeExtractConfig.hasRecipes) {
                ItemStack emptyContainer = new ItemStack((Item)BiomeExtract.getInstance());
                ItemStack filledContainer = BiomeExtract.getInstance().createItemStack(null, 1);
                filledContainer.func_77964_b(Short.MAX_VALUE);
                EnvironmentalAccumulator.getInstance().getRecipeRegistry().registerRecipe(recipeName, new EnvironmentalAccumulatorRecipeComponent(emptyContainer, WeatherType.ANY), new EnvironmentalAccumulatorRecipeComponent(filledContainer, WeatherType.ANY), new EnvironmentalAccumulatorRecipeProperties(1000, BiomeExtractConfig.envirAccCooldownTime, -1.0, null, new EnvironmentalAccumulatorRecipeProperties.IEAResultOverride(){

                    @Override
                    public ItemStack getResult(IBlockAccess world, int x, int y, int z, ItemStack originalResult) {
                        World worldSafe = (World)world;
                        BiomeGenBase biome = worldSafe.func_72807_a(x, z);
                        if (BiomeExtractConfig._instance.isCraftingBlacklisted(biome.field_76756_M)) {
                            return BiomeExtract.getInstance().createItemStack(null, 1);
                        }
                        return BiomeExtract.getInstance().createItemStack(biome, 1);
                    }
                }));
            }
        }
    }
}

