/*
 * Decompiled with CFR 0.152.
 */
package evilcraft;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import cpw.mods.fml.common.gameevent.TickEvent;
import evilcraft.EvilCraft;
import evilcraft.GeneralConfig;
import evilcraft.core.helper.L10NHelpers;
import evilcraft.modcompat.versionchecker.VersionCheckerModCompat;
import java.io.IOException;
import java.net.URL;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import org.apache.commons.io.IOUtils;

public class VersionStats {
    private static final Object LOCK = new Object();
    private static VersionStats VERSION_STATS = null;
    private static boolean CHECKED = false;
    public String mod_version;
    public String update_link;

    private VersionStats() {
    }

    public static String getVersion() {
        return L10NHelpers.localize("general.versionCurrent", "0.9.13", "1.7.10");
    }

    public static void load() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                VersionStats versionStats = VersionStats.getVersionStats();
                if (VersionStats.needsUpdate(versionStats)) {
                    VersionCheckerModCompat.sendIMCOutdatedMessage(versionStats);
                }
            }
        }).start();
    }

    public static void check(final TickEvent.PlayerTickEvent event) {
        if (!CHECKED) {
            CHECKED = true;
            new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    VersionStats versionStats;
                    EntityPlayer player = event.player;
                    Object object = LOCK;
                    synchronized (object) {
                        versionStats = VERSION_STATS;
                    }
                    while (versionStats == null) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        object = LOCK;
                        synchronized (object) {
                            versionStats = VERSION_STATS;
                        }
                    }
                    if (GeneralConfig.versionChecker && VersionStats.needsUpdate(versionStats)) {
                        VersionStats.sendMessage(player, L10NHelpers.localize("general.versionUpdate", versionStats.mod_version, "EvilCraft", "0.9.13", versionStats.update_link));
                    }
                }
            }).start();
        }
    }

    private static boolean needsUpdate(VersionStats versionStats) {
        return versionStats != null && !"0.9.13".equals(versionStats.mod_version);
    }

    private static void sendMessage(EntityPlayer player, String message) {
        player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + message));
    }

    private static VersionStats fetchVersionStats() {
        VersionStats versionStats = null;
        try {
            Gson gson = new Gson();
            String location = "http://rubensworks.net/evilcraft-versionstats/?mc_version=1.7.10&mod_version=0.9.13";
            versionStats = (VersionStats)gson.fromJson(IOUtils.toString((URL)new URL(location)), VersionStats.class);
        }
        catch (JsonSyntaxException e) {
            EvilCraft.log("The version stats server returned an invalid answer.");
        }
        catch (IOException e) {
            EvilCraft.log("Can't connect to version stats server");
        }
        return versionStats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized VersionStats getVersionStats() {
        if (VERSION_STATS == null) {
            VersionStats temp = VersionStats.fetchVersionStats();
            Object object = LOCK;
            synchronized (object) {
                VERSION_STATS = temp;
            }
        }
        return VERSION_STATS;
    }
}

