/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.api;

import com.google.common.collect.Maps;
import evilcraft.api.IRegistry;
import evilcraft.api.degradation.IDegradationRegistry;
import evilcraft.api.recipes.custom.ISuperRecipeRegistry;
import evilcraft.api.tileentity.bloodchest.IBloodChestRepairActionRegistry;
import evilcraft.api.tileentity.purifier.IPurifierActionRegistry;
import evilcraft.core.degradation.DegradationRegistry;
import evilcraft.core.recipe.custom.SuperRecipeRegistry;
import evilcraft.tileentity.tickaction.bloodchest.BloodChestRepairActionRegistry;
import evilcraft.tileentity.tickaction.purifier.PurifierActionRegistry;
import java.util.Map;

public class RegistryManager {
    private static RegistryManager _instance = null;
    private Map<Class<? extends IRegistry>, IRegistry> registries = Maps.newHashMap();

    private RegistryManager() {
        this.addRegistry(IDegradationRegistry.class, new DegradationRegistry());
        this.addRegistry(ISuperRecipeRegistry.class, new SuperRecipeRegistry());
        this.addRegistry(IBloodChestRepairActionRegistry.class, new BloodChestRepairActionRegistry());
        this.addRegistry(IPurifierActionRegistry.class, new PurifierActionRegistry());
    }

    private void addRegistry(Class<? extends IRegistry> clazz, IRegistry registry) {
        this.registries.put(clazz, registry);
    }

    public static <T extends IRegistry> T getRegistry(Class<T> clazz) {
        return (T)RegistryManager.getInstance().registries.get(clazz);
    }

    public static RegistryManager getInstance() {
        if (_instance == null) {
            _instance = new RegistryManager();
        }
        return _instance;
    }
}

