/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import evilcraft.api.RegistryManager;
import evilcraft.api.recipes.custom.IMachine;
import evilcraft.api.recipes.custom.IRecipeRegistry;
import evilcraft.api.recipes.custom.ISuperRecipeRegistry;
import evilcraft.client.gui.container.GuiBloodInfuser;
import evilcraft.client.particle.EntityBloodBubbleFX;
import evilcraft.core.config.configurable.ConfigurableBlockContainerGuiTankInfo;
import evilcraft.core.config.extendedconfig.BlockConfig;
import evilcraft.core.config.extendedconfig.ExtendedConfig;
import evilcraft.core.helper.DirectionHelpers;
import evilcraft.core.helper.MinecraftHelpers;
import evilcraft.core.recipe.custom.DurationXpRecipeProperties;
import evilcraft.core.recipe.custom.ItemFluidStackAndTierRecipeComponent;
import evilcraft.core.recipe.custom.ItemStackRecipeComponent;
import evilcraft.core.tileentity.TankInventoryTileEntity;
import evilcraft.core.tileentity.WorkingTileEntity;
import evilcraft.inventory.container.ContainerBloodInfuser;
import evilcraft.tileentity.TileBloodInfuser;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.Item;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BloodInfuser
extends ConfigurableBlockContainerGuiTankInfo
implements IMachine<BloodInfuser, ItemFluidStackAndTierRecipeComponent, ItemStackRecipeComponent, DurationXpRecipeProperties> {
    private static BloodInfuser _instance = null;
    @SideOnly(value=Side.CLIENT)
    private IIcon sideIcon;
    @SideOnly(value=Side.CLIENT)
    private IIcon topIcon;
    @SideOnly(value=Side.CLIENT)
    private IIcon frontIconOn;
    @SideOnly(value=Side.CLIENT)
    private IIcon frontIconOff;

    public static void initInstance(ExtendedConfig<BlockConfig> eConfig) {
        if (_instance == null) {
            _instance = new BloodInfuser(eConfig);
        } else {
            eConfig.showDoubleInitError();
        }
    }

    public static BloodInfuser getInstance() {
        return _instance;
    }

    private BloodInfuser(ExtendedConfig<BlockConfig> eConfig) {
        super((ExtendedConfig)eConfig, Material.field_151576_e, (Class<? extends TankInventoryTileEntity>)TileBloodInfuser.class);
        this.func_149672_a(field_149769_e);
        this.setRotatable(true);
        if (MinecraftHelpers.isClientSide()) {
            this.setGUI(GuiBloodInfuser.class);
        }
        this.setContainer(ContainerBloodInfuser.class);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.topIcon = iconRegister.func_94245_a(this.func_149641_N() + "_" + ForgeDirection.UP.name());
        this.sideIcon = iconRegister.func_94245_a(this.func_149641_N() + "_" + "side");
        this.frontIconOn = iconRegister.func_94245_a(this.func_149641_N() + "_" + ForgeDirection.NORTH.name() + "_on");
        this.frontIconOff = iconRegister.func_94245_a(this.func_149641_N() + "_" + ForgeDirection.NORTH.name() + "_off");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        TileBloodInfuser tile = (TileBloodInfuser)world.func_147438_o(x, y, z);
        ForgeDirection rotatedDirection = DirectionHelpers.TEXTURESIDE_ORIENTATION[tile.getRotation().ordinal()][side];
        return this.func_149691_a(rotatedDirection.ordinal(), tile.isVisuallyWorking() ? 1 : 0);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (side == ForgeDirection.UP.ordinal() || side == ForgeDirection.DOWN.ordinal()) {
            return this.topIcon;
        }
        if (side == ForgeDirection.SOUTH.ordinal()) {
            if (meta == 1) {
                return this.frontIconOn;
            }
            return this.frontIconOff;
        }
        return this.sideIcon;
    }

    public Item func_149650_a(int par1, Random random, int zero) {
        return Item.func_150898_a((Block)this);
    }

    @Override
    public String getTankNBTName() {
        return TileBloodInfuser.TANKNAME;
    }

    @Override
    public int getMaxCapacity() {
        return 10000;
    }

    @Override
    public IRecipeRegistry<BloodInfuser, ItemFluidStackAndTierRecipeComponent, ItemStackRecipeComponent, DurationXpRecipeProperties> getRecipeRegistry() {
        return RegistryManager.getRegistry(ISuperRecipeRegistry.class).getRecipeRegistry(this);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random random) {
        EntityBloodBubbleFX.randomDisplayTick((WorkingTileEntity)world.func_147438_o(x, y, z), world, x, y, z, random);
        super.func_149734_b(world, x, y, z, random);
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        TileBloodInfuser tile = (TileBloodInfuser)world.func_147438_o(x, y, z);
        return tile.isVisuallyWorking() ? 4 : super.getLightValue(world, x, y, z);
    }
}

