/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import evilcraft.api.ILocation;
import evilcraft.client.gui.container.GuiColossalBloodChest;
import evilcraft.core.algorithm.Location;
import evilcraft.core.algorithm.Size;
import evilcraft.core.block.CubeDetector;
import evilcraft.core.config.configurable.ConfigurableBlockContainerGuiTankInfo;
import evilcraft.core.config.extendedconfig.BlockConfig;
import evilcraft.core.config.extendedconfig.ExtendedConfig;
import evilcraft.core.helper.LocationHelpers;
import evilcraft.core.helper.MinecraftHelpers;
import evilcraft.core.helper.RenderHelpers;
import evilcraft.core.tileentity.TankInventoryTileEntity;
import evilcraft.inventory.container.ContainerColossalBloodChest;
import evilcraft.tileentity.TileColossalBloodChest;
import evilcraft.tileentity.TileSpiritFurnace;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ColossalBloodChest
extends ConfigurableBlockContainerGuiTankInfo
implements CubeDetector.IDetectionListener {
    private static ColossalBloodChest _instance = null;

    public static void initInstance(ExtendedConfig<BlockConfig> eConfig) {
        if (_instance == null) {
            _instance = new ColossalBloodChest(eConfig);
        } else {
            eConfig.showDoubleInitError();
        }
    }

    public static ColossalBloodChest getInstance() {
        return _instance;
    }

    private ColossalBloodChest(ExtendedConfig<BlockConfig> eConfig) {
        super((ExtendedConfig)eConfig, Material.field_151576_e, (Class<? extends TankInventoryTileEntity>)TileColossalBloodChest.class);
        this.func_149711_c(5.0f);
        this.func_149672_a(field_149766_f);
        this.setHarvestLevel("axe", 2);
        this.setRotatable(false);
        if (MinecraftHelpers.isClientSide()) {
            this.setGUI(GuiColossalBloodChest.class);
        }
        this.setContainer(ContainerColossalBloodChest.class);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return meta == 1 ? RenderHelpers.EMPTYICON : super.func_149691_a(side, meta);
    }

    @Override
    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer entityplayer, int par6, float par7, float par8, float par9) {
        return !TileColossalBloodChest.canWork(world, new Location(x, y, z)) || super.func_149727_a(world, x, y, z, entityplayer, par6, par7, par8, par9);
    }

    public Item func_149650_a(int par1, Random random, int zero) {
        return Item.func_150898_a((Block)this);
    }

    @Override
    public String getTankNBTName() {
        return TileSpiritFurnace.TANKNAME;
    }

    @Override
    public int getMaxCapacity() {
        return 10000;
    }

    private void triggerDetector(World world, int x, int y, int z, boolean valid) {
        TileColossalBloodChest.detector.detect(world, new Location(x, y, z), valid, true);
    }

    public void func_149726_b(World world, int x, int y, int z) {
        this.triggerDetector(world, x, y, z, true);
    }

    public void func_149725_f(World world, int x, int y, int z, int meta) {
        this.triggerDetector(world, x, y, z, false);
        super.func_149725_f(world, x, y, z, meta);
    }

    @Override
    public void onDetect(World world, ILocation location, Size size, boolean valid, ILocation originCorner) {
        Block block = LocationHelpers.getBlock(world, location);
        if (block == this) {
            TileColossalBloodChest.detectStructure(world, location, size, valid);
            TileEntity tile = LocationHelpers.getTile((IBlockAccess)world, location);
            if (tile != null) {
                ((TileColossalBloodChest)tile).setSize(valid ? size : Size.NULL_SIZE);
                ((TileColossalBloodChest)tile).setCenter(originCorner.copy().subtract(new Location(-1, -1, -1)));
            }
        }
    }
}

