/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.block;

import evilcraft.core.PlayerExtendedInventoryIterator;
import evilcraft.core.fluid.WorldSharedTankCache;
import evilcraft.core.helper.ItemHelpers;
import evilcraft.core.item.ItemBlockFluidContainer;
import evilcraft.core.world.GlobalCounter;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public class EntangledChaliceItem
extends ItemBlockFluidContainer {
    public EntangledChaliceItem(Block block) {
        super(block);
    }

    public String getTankID(ItemStack container) {
        String key = this.getBlockTank().getTankNBTName();
        if (container.field_77990_d == null || !container.field_77990_d.func_74764_b(key)) {
            container.field_77990_d = new NBTTagCompound();
            container.field_77990_d.func_74782_a(key, (NBTBase)new NBTTagCompound());
            container.field_77990_d.func_74775_l(key).func_74778_a("tankID", "invalid");
        }
        return container.field_77990_d.func_74775_l(key).func_74779_i("tankID");
    }

    public void setTankID(ItemStack container, String tankID) {
        String key = this.getBlockTank().getTankNBTName();
        if (container.field_77990_d == null) {
            container.field_77990_d = new NBTTagCompound();
        }
        if (!container.field_77990_d.func_74764_b(key)) {
            container.field_77990_d.func_74782_a(key, (NBTBase)new NBTTagCompound());
        }
        container.field_77990_d.func_74775_l(key).func_74778_a("tankID", tankID);
    }

    public void setNextTankID(ItemStack container) {
        this.setTankID(container, Integer.toString(GlobalCounter.getInstance().getNext("EntangledChalice")));
    }

    @Override
    public FluidStack getFluid(ItemStack container) {
        return WorldSharedTankCache.getInstance().getTankContent(this.getTankID(container));
    }

    @Override
    protected void setFluid(ItemStack container, FluidStack fluidStack) {
        WorldSharedTankCache.getInstance().setTankContent(this.getTankID(container), fluidStack);
    }

    @Override
    protected void autofill(IFluidContainerItem item, ItemStack itemStack, World world, Entity entity) {
        if (entity instanceof EntityPlayer && !world.field_72995_K) {
            FluidStack tickFluid;
            EntityPlayer player = (EntityPlayer)entity;
            PlayerExtendedInventoryIterator it = new PlayerExtendedInventoryIterator(player);
            do {
                tickFluid = item.getFluid(itemStack);
                ItemStack toFill = (ItemStack)it.next();
                if (tickFluid == null || toFill == null || toFill.field_77994_a != 1) continue;
                ItemHelpers.tryFillContainerForPlayer(item, itemStack, toFill, tickFluid, player);
            } while (tickFluid != null && tickFluid.amount > 0 && it.hasNext());
        }
    }
}

