/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import evilcraft.client.gui.container.GuiSanguinaryEnvironmentalAccumulator;
import evilcraft.core.config.configurable.ConfigurableBlockContainerGui;
import evilcraft.core.config.extendedconfig.BlockConfig;
import evilcraft.core.config.extendedconfig.ExtendedConfig;
import evilcraft.core.helper.DirectionHelpers;
import evilcraft.core.helper.MinecraftHelpers;
import evilcraft.inventory.container.ContainerSanguinaryEnvironmentalAccumulator;
import evilcraft.tileentity.TileSanguinaryEnvironmentalAccumulator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.Item;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class SanguinaryEnvironmentalAccumulator
extends ConfigurableBlockContainerGui {
    private static SanguinaryEnvironmentalAccumulator _instance = null;
    @SideOnly(value=Side.CLIENT)
    private IIcon sideIcon;
    @SideOnly(value=Side.CLIENT)
    private IIcon topIconOn;
    @SideOnly(value=Side.CLIENT)
    private IIcon topIconOff;
    @SideOnly(value=Side.CLIENT)
    private IIcon downIcon;

    public static void initInstance(ExtendedConfig<BlockConfig> eConfig) {
        if (_instance == null) {
            _instance = new SanguinaryEnvironmentalAccumulator(eConfig);
        } else {
            eConfig.showDoubleInitError();
        }
    }

    public static SanguinaryEnvironmentalAccumulator getInstance() {
        return _instance;
    }

    private SanguinaryEnvironmentalAccumulator(ExtendedConfig<BlockConfig> eConfig) {
        super(eConfig, Material.field_151576_e, TileSanguinaryEnvironmentalAccumulator.class);
        this.func_149672_a(field_149769_e);
        this.setRotatable(true);
        if (MinecraftHelpers.isClientSide()) {
            this.setGUI(GuiSanguinaryEnvironmentalAccumulator.class);
        }
        this.setContainer(ContainerSanguinaryEnvironmentalAccumulator.class);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.topIconOn = iconRegister.func_94245_a(this.func_149641_N() + "_" + ForgeDirection.UP.name() + "_on");
        this.topIconOff = iconRegister.func_94245_a(this.func_149641_N() + "_" + ForgeDirection.UP.name() + "_off");
        this.sideIcon = iconRegister.func_94245_a(this.func_149641_N() + "_" + "side");
        this.downIcon = iconRegister.func_94245_a(this.func_149641_N() + "_" + ForgeDirection.DOWN.name());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        TileSanguinaryEnvironmentalAccumulator tile = (TileSanguinaryEnvironmentalAccumulator)world.func_147438_o(x, y, z);
        ForgeDirection rotatedDirection = DirectionHelpers.TEXTURESIDE_ORIENTATION[tile.getRotation().ordinal()][side];
        return this.func_149691_a(rotatedDirection.ordinal(), tile.isVisuallyWorking() ? 1 : 0);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (side == ForgeDirection.DOWN.ordinal()) {
            return this.downIcon;
        }
        if (side == ForgeDirection.UP.ordinal()) {
            if (meta == 1) {
                return this.topIconOn;
            }
            return this.topIconOff;
        }
        return this.sideIcon;
    }

    public Item func_149650_a(int par1, Random random, int zero) {
        return Item.func_150898_a((Block)this);
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        TileSanguinaryEnvironmentalAccumulator tile = (TileSanguinaryEnvironmentalAccumulator)world.func_147438_o(x, y, z);
        return tile.isVisuallyWorking() ? 4 : super.getLightValue(world, x, y, z);
    }
}

