/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import evilcraft.ExtendedDamageSource;
import evilcraft.block.SanguinaryPedestal;
import evilcraft.block.SpikedPlateConfig;
import evilcraft.core.config.configurable.ConfigurableBlockBasePressurePlate;
import evilcraft.core.config.extendedconfig.BlockConfig;
import evilcraft.core.config.extendedconfig.ExtendedConfig;
import evilcraft.core.helper.obfuscation.ObfuscationHelpers;
import evilcraft.tileentity.TileSanguinaryPedestal;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public class SpikedPlate
extends ConfigurableBlockBasePressurePlate {
    private static SpikedPlate _instance = null;
    @SideOnly(value=Side.CLIENT)
    protected IIcon blockIconSide;

    public static void initInstance(ExtendedConfig<BlockConfig> eConfig) {
        if (_instance == null) {
            _instance = new SpikedPlate(eConfig);
        } else {
            eConfig.showDoubleInitError();
        }
    }

    public static SpikedPlate getInstance() {
        return _instance;
    }

    private SpikedPlate(ExtendedConfig<BlockConfig> eConfig) {
        super(eConfig, Material.field_151576_e);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.blockIconSide = iconRegister.func_94245_a(this.func_149641_N() + "_side");
        super.func_149651_a(iconRegister);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (ForgeDirection.getOrientation((int)side) == ForgeDirection.UP) {
            return super.func_149691_a(side, meta);
        }
        return this.blockIconSide;
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        return super.func_149742_c(world, x, y, z) || world.func_147439_a(x, y - 1, z) == SanguinaryPedestal.getInstance();
    }

    protected boolean damageEntity(World world, Entity entity, int x, int y, int z) {
        if (!(entity instanceof EntityPlayer) && entity instanceof EntityLivingBase) {
            float damage = (float)SpikedPlateConfig.damage;
            ObfuscationHelpers.setRecentlyHit((EntityLivingBase)entity, 100);
            if (entity.func_70097_a((DamageSource)ExtendedDamageSource.spiked, damage)) {
                TileEntity tile = world.func_147438_o(x, y - 1, z);
                if (tile != null && tile instanceof TileSanguinaryPedestal) {
                    int amount = MathHelper.func_76141_d((float)(damage * (float)SpikedPlateConfig.mobMultiplier));
                    ((TileSanguinaryPedestal)tile).fillWithPotentialBonus(new FluidStack(TileSanguinaryPedestal.FLUID, amount));
                }
                return true;
            }
        }
        return false;
    }

    protected int func_150065_e(World world, int x, int y, int z) {
        List list = world.func_72839_b(null, this.func_150061_a(x, y, z));
        int ret = 0;
        if (list != null && !list.isEmpty()) {
            for (Entity entity : list) {
                if (entity.func_145773_az() || !this.damageEntity(world, entity, x, y, z)) continue;
                ret = 15;
            }
        }
        return ret;
    }

    protected int func_150060_c(int meta) {
        return meta == 1 ? 15 : 0;
    }

    protected int func_150066_d(int meta) {
        return meta > 0 ? 1 : 0;
    }

    @Override
    protected void setMetaBlockBounds(IBlockAccess world, int x, int y, int z, int meta) {
        boolean flag = this.func_150060_c(meta) > 0;
        float offset = 0.0f;
        float f = 0.0775f;
        TileEntity tile = world.func_147438_o(x, y - 1, z);
        if (tile != null && tile instanceof TileSanguinaryPedestal) {
            offset = -0.025f;
        }
        if (flag) {
            this.func_149676_a(f, offset, f, 1.0f - f, 0.03125f + offset, 1.0f - f);
        } else {
            this.func_149676_a(f, offset, f, 1.0f - f, 0.0625f + offset, 1.0f - f);
        }
    }

    public boolean canCreatureSpawn(EnumCreatureType type, IBlockAccess world, int x, int y, int z) {
        return true;
    }
}

