/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.block;

import evilcraft.api.ILocation;
import evilcraft.core.algorithm.Location;
import evilcraft.core.algorithm.RegionIterator;
import evilcraft.core.config.configurable.ConfigurableBlockContainer;
import evilcraft.core.config.extendedconfig.BlockConfig;
import evilcraft.core.config.extendedconfig.ExtendedConfig;
import evilcraft.core.helper.LocationHelpers;
import evilcraft.tileentity.TileSpiritPortal;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class SpiritPortal
extends ConfigurableBlockContainer {
    private static SpiritPortal _instance = null;

    public static void initInstance(ExtendedConfig<BlockConfig> eConfig) {
        if (_instance == null) {
            _instance = new SpiritPortal(eConfig);
        } else {
            eConfig.showDoubleInitError();
        }
    }

    public static SpiritPortal getInstance() {
        return _instance;
    }

    private SpiritPortal(ExtendedConfig<BlockConfig> eConfig) {
        super(eConfig, Material.field_151573_f, TileSpiritPortal.class);
        this.setRotatable(true);
        this.func_149672_a(field_149775_l);
        this.func_149711_c(50.0f);
        this.func_149752_b(6000000.0f);
        this.func_149676_a(0.4f, 0.4f, 0.4f, 0.6f, 0.6f, 0.6f);
        this.func_149715_a(0.5f);
        this.setRotatable(false);
    }

    @Override
    public boolean func_149662_c() {
        return false;
    }

    @Override
    public int func_149645_b() {
        return -1;
    }

    public boolean func_149686_d() {
        return false;
    }

    public void func_149681_a(World world, int x, int y, int z, int metadata, EntityPlayer player) {
        world.func_147468_f(x, y, z);
    }

    protected static boolean canReplaceBlock(Block block) {
        return block != null && (block == Blocks.field_150350_a || block.func_149688_o().func_76222_j());
    }

    public static boolean tryPlacePortal(World world, int x, int y, int z) {
        RegionIterator it = new RegionIterator(new Location(x, y, z), 1, true);
        for (int attempts = 9; it.hasNext() && attempts >= 0; --attempts) {
            ILocation location = it.next();
            if (!SpiritPortal.canReplaceBlock(LocationHelpers.getBlock(world, location))) continue;
            world.func_147465_d(location.getCoordinates()[0], location.getCoordinates()[1], location.getCoordinates()[2], (Block)SpiritPortal.getInstance(), 0, 3);
            return true;
        }
        return false;
    }
}

