/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import evilcraft.client.gui.container.GuiSpiritReanimator;
import evilcraft.client.particle.EntityBloodBubbleFX;
import evilcraft.core.config.configurable.ConfigurableBlockContainerGuiTankInfo;
import evilcraft.core.config.extendedconfig.BlockConfig;
import evilcraft.core.config.extendedconfig.ExtendedConfig;
import evilcraft.core.helper.DirectionHelpers;
import evilcraft.core.helper.MinecraftHelpers;
import evilcraft.core.tileentity.TankInventoryTileEntity;
import evilcraft.core.tileentity.WorkingTileEntity;
import evilcraft.inventory.container.ContainerSpiritReanimator;
import evilcraft.tileentity.TileSpiritReanimator;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class SpiritReanimator
extends ConfigurableBlockContainerGuiTankInfo {
    private static SpiritReanimator _instance = null;
    @SideOnly(value=Side.CLIENT)
    private IIcon sideIcon;
    @SideOnly(value=Side.CLIENT)
    private IIcon topIcon;
    @SideOnly(value=Side.CLIENT)
    private IIcon frontIconOn;
    @SideOnly(value=Side.CLIENT)
    private IIcon frontIconOff;

    public static void initInstance(ExtendedConfig<BlockConfig> eConfig) {
        if (_instance == null) {
            _instance = new SpiritReanimator(eConfig);
        } else {
            eConfig.showDoubleInitError();
        }
    }

    public static SpiritReanimator getInstance() {
        return _instance;
    }

    private SpiritReanimator(ExtendedConfig<BlockConfig> eConfig) {
        super((ExtendedConfig)eConfig, Material.field_151576_e, (Class<? extends TankInventoryTileEntity>)TileSpiritReanimator.class);
        this.func_149711_c(5.0f);
        this.func_149672_a(field_149769_e);
        this.setHarvestLevel("pickaxe", 2);
        this.setRotatable(true);
        if (MinecraftHelpers.isClientSide()) {
            this.setGUI(GuiSpiritReanimator.class);
        }
        this.setContainer(ContainerSpiritReanimator.class);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        TileSpiritReanimator tile = (TileSpiritReanimator)world.func_147438_o(x, y, z);
        ForgeDirection rotatedDirection = DirectionHelpers.TEXTURESIDE_ORIENTATION[tile.getRotation().ordinal()][side];
        return this.func_149691_a(rotatedDirection.ordinal(), tile.isVisuallyWorking() ? 1 : 0);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.topIcon = iconRegister.func_94245_a(this.func_149641_N() + "_" + ForgeDirection.UP.name());
        this.sideIcon = iconRegister.func_94245_a(this.func_149641_N() + "_" + "side");
        this.frontIconOn = iconRegister.func_94245_a(this.func_149641_N() + "_" + ForgeDirection.NORTH.name() + "_on");
        this.frontIconOff = iconRegister.func_94245_a(this.func_149641_N() + "_" + ForgeDirection.NORTH.name() + "_off");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (side == ForgeDirection.UP.ordinal() || side == ForgeDirection.DOWN.ordinal()) {
            return this.topIcon;
        }
        if (side == ForgeDirection.SOUTH.ordinal()) {
            return meta == 1 ? this.frontIconOn : this.frontIconOff;
        }
        return this.sideIcon;
    }

    @Override
    public String getTankNBTName() {
        return TileSpiritReanimator.TANKNAME;
    }

    @Override
    public int getMaxCapacity() {
        return 10000;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random random) {
        EntityBloodBubbleFX.randomDisplayTick((WorkingTileEntity)world.func_147438_o(x, y, z), world, x, y, z, random);
        super.func_149734_b(world, x, y, z, random);
    }
}

