/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.client.gui;

import com.google.common.collect.Maps;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import evilcraft.core.helper.MinecraftHelpers;
import evilcraft.core.inventory.IGuiContainerProvider;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class GuiHandler
implements IGuiHandler {
    private static Map<Integer, Class<? extends Container>> CONTAINERS = Maps.newHashMap();
    private static Map<Integer, Class<? extends GuiScreen>> GUIS = Maps.newHashMap();
    private static Map<Integer, GuiType> TYPES = Maps.newHashMap();
    private static int TEMP_ITEM_GUI_INDEX_OVERRIDE_CLIENT = -1;
    private static int TEMP_ITEM_GUI_INDEX_OVERRIDE_SERVER = -1;

    public static void registerGUI(IGuiContainerProvider guiProvider, GuiType type) {
        CONTAINERS.put(guiProvider.getGuiID(), guiProvider.getContainer());
        if (MinecraftHelpers.isClientSide()) {
            GUIS.put(guiProvider.getGuiID(), guiProvider.getGUI());
        }
        TYPES.put(guiProvider.getGuiID(), type);
    }

    public static void setTemporaryItemIndex(int index) {
        if (MinecraftHelpers.isClientSide()) {
            TEMP_ITEM_GUI_INDEX_OVERRIDE_CLIENT = index;
        } else {
            TEMP_ITEM_GUI_INDEX_OVERRIDE_SERVER = index;
        }
    }

    private static void clearTemporaryItemIndex() {
        GuiHandler.setTemporaryItemIndex(-1);
    }

    private static int getItemIndex(EntityPlayer player) throws IllegalArgumentException {
        int index;
        int n = index = MinecraftHelpers.isClientSide() ? TEMP_ITEM_GUI_INDEX_OVERRIDE_CLIENT : TEMP_ITEM_GUI_INDEX_OVERRIDE_SERVER;
        if (index == -1) {
            index = player.field_71071_by.field_70461_c;
        }
        GuiHandler.clearTemporaryItemIndex();
        if (index == -1) {
            throw new IllegalArgumentException("Invalid GUI item.");
        }
        return index;
    }

    public Object getServerGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        try {
            Class<? extends Container> containerClass = CONTAINERS.get(id);
            if (containerClass == null) {
                return null;
            }
            if (TYPES.get(id) == GuiType.BLOCK) {
                TileEntity tileEntity = world.func_147438_o(x, y, z);
                Constructor<? extends Container> containerConstructor = containerClass.getConstructor(InventoryPlayer.class, tileEntity.getClass());
                return containerConstructor.newInstance(player.field_71071_by, tileEntity);
            }
            Constructor<? extends Container> containerConstructor = containerClass.getConstructor(EntityPlayer.class, Integer.TYPE);
            return containerConstructor.newInstance(player, GuiHandler.getItemIndex(player));
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public Object getClientGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        try {
            Class<? extends GuiScreen> guiClass = GUIS.get(id);
            if (TYPES.get(id) == GuiType.BLOCK) {
                TileEntity tileEntity = world.func_147438_o(x, y, z);
                Constructor<? extends GuiScreen> guiConstructor = guiClass.getConstructor(InventoryPlayer.class, tileEntity.getClass());
                return guiConstructor.newInstance(player.field_71071_by, tileEntity);
            }
            Constructor<? extends GuiScreen> guiConstructor = guiClass.getConstructor(EntityPlayer.class, Integer.TYPE);
            return guiConstructor.newInstance(player, GuiHandler.getItemIndex(player));
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static enum GuiType {
        BLOCK,
        ITEM;

    }
}

