/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.client.render.tileentity;

import evilcraft.client.render.model.ModelBoxOfEternalClosure;
import evilcraft.core.client.render.tileentity.RenderTileEntityModel;
import evilcraft.core.tileentity.EvilCraftTileEntity;
import evilcraft.entity.monster.VengeanceSpirit;
import evilcraft.tileentity.TileBoxOfEternalClosure;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class RenderTileEntityBoxOfEternalClosure
extends RenderTileEntityModel {
    private static final ResourceLocation beamTexture = new ResourceLocation("evilcraft", "textures/entities/beam.png");

    public RenderTileEntityBoxOfEternalClosure(ModelBase model, ResourceLocation texture) {
        super(model, texture);
    }

    @Override
    protected void renderTileEntityAt(EvilCraftTileEntity tile, double x, double y, double z, float partialTick) {
        super.renderTileEntityAt(tile, x, y, z, partialTick);
        x += 0.5;
        y -= 0.5;
        z += 0.5;
        TileBoxOfEternalClosure box = (TileBoxOfEternalClosure)tile;
        VengeanceSpirit target = box.getTargetSpirit();
        if (target != null) {
            float innerRotation = (float)box.innerRotation + partialTick;
            float yOffset = MathHelper.func_76126_a((float)(innerRotation * 0.2f)) / 4.0f + 0.5f;
            yOffset = (yOffset * yOffset + yOffset) * 0.2f;
            float rotateX = -(target.field_70130_N / 2.0f) - (float)((double)box.field_145851_c - target.field_70165_t - (target.field_70169_q - target.field_70165_t) * (double)(1.0f - partialTick));
            float rotateY = target.field_70131_O / 2.0f - (float)((double)yOffset + (double)box.field_145848_d - target.field_70163_u - (target.field_70167_r - target.field_70163_u) * (double)(1.0f - partialTick));
            float rotateZ = -(target.field_70130_N / 2.0f) - (float)((double)box.field_145849_e - target.field_70161_v - (target.field_70166_s - target.field_70161_v) * (double)(1.0f - partialTick));
            float distance = MathHelper.func_76129_c((float)(rotateX * rotateX + rotateZ * rotateZ));
            GL11.glPushMatrix();
            GL11.glTranslatef((float)((float)x), (float)((float)y + 1.0f), (float)((float)z));
            GL11.glRotatef((float)((float)(-Math.atan2(rotateZ, rotateX)) * 180.0f / (float)Math.PI - 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)((float)(-Math.atan2(distance, rotateY)) * 180.0f / (float)Math.PI - 90.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            Tessellator tessellator = Tessellator.field_78398_a;
            RenderHelper.func_74518_a();
            GL11.glDisable((int)2884);
            this.func_147499_a(beamTexture);
            GL11.glShadeModel((int)7425);
            tessellator.func_78371_b(5);
            float zuv = MathHelper.func_76129_c((float)(rotateX * rotateX + rotateY * rotateY + rotateZ * rotateZ));
            float v1 = MathHelper.func_76129_c((float)(rotateX * rotateX + rotateY * rotateY + rotateZ * rotateZ)) / 32.0f - ((float)target.field_70173_aa + partialTick) * 0.01f;
            float v2 = 0.0f - ((float)target.field_70173_aa + partialTick) * 0.01f;
            int amount = 8;
            for (int i = 0; i <= amount; ++i) {
                float xuv = MathHelper.func_76126_a((float)((float)(i % amount) * (float)Math.PI * 2.0f / (float)amount)) * 0.75f;
                float yuv = MathHelper.func_76134_b((float)((float)(i % amount) * (float)Math.PI * 2.0f / (float)amount)) * 0.75f;
                float u = (float)(i % amount) * 1.0f / (float)amount;
                tessellator.func_78378_d(0);
                tessellator.func_78374_a((double)(xuv * 0.2f), (double)(yuv * 0.2f), 0.0, (double)u, (double)v1);
                tessellator.func_78378_d(0xFFFFFF);
                tessellator.func_78374_a((double)xuv, (double)yuv, (double)zuv, (double)u, (double)v2);
            }
            tessellator.func_78381_a();
            GL11.glEnable((int)2884);
            GL11.glShadeModel((int)7424);
            RenderHelper.func_74519_b();
            GL11.glPopMatrix();
        }
    }

    @Override
    protected void renderModel(EvilCraftTileEntity tile, ModelBase model, float partialTick) {
        TileBoxOfEternalClosure box = (TileBoxOfEternalClosure)tile;
        ModelBoxOfEternalClosure boxModel = (ModelBoxOfEternalClosure)model;
        float angle = box.getPreviousLidAngle() + (box.getLidAngle() - box.getPreviousLidAngle()) * partialTick;
        boxModel.setCoverAngle(angle);
        ((ModelBoxOfEternalClosure)model).renderAll();
    }
}

