/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.client.render.tileentity;

import evilcraft.core.helper.DirectionHelpers;
import evilcraft.core.helper.RenderHelpers;
import evilcraft.tileentity.TileDarkTank;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public class RenderTileEntityDarkTank
extends TileEntitySpecialRenderer {
    private static final double OFFSET = 0.01;
    private static final double MINY = 0.002;
    private static final double MIN = 0.135;
    private static final double MAX = 0.865;
    private static double[][][] coordinates = new double[][][]{new double[][]{{0.135, 0.002, 0.135}, {0.135, 0.002, 0.865}, {0.865, 0.002, 0.865}, {0.865, 0.002, 0.135}}, new double[][]{{0.135, 0.865, 0.135}, {0.135, 0.865, 0.865}, {0.865, 0.865, 0.865}, {0.865, 0.865, 0.135}}, new double[][]{{0.135, 0.002, 0.135}, {0.135, 0.865, 0.135}, {0.865, 0.865, 0.135}, {0.865, 0.002, 0.135}}, new double[][]{{0.135, 0.002, 0.865}, {0.135, 0.865, 0.865}, {0.865, 0.865, 0.865}, {0.865, 0.002, 0.865}}, new double[][]{{0.135, 0.002, 0.135}, {0.135, 0.865, 0.135}, {0.135, 0.865, 0.865}, {0.135, 0.002, 0.865}}, new double[][]{{0.865, 0.002, 0.135}, {0.865, 0.865, 0.135}, {0.865, 0.865, 0.865}, {0.865, 0.002, 0.865}}};

    public void func_147500_a(TileEntity tileEntity, double x, double y, double z, float f) {
        if (tileEntity instanceof TileDarkTank) {
            final TileDarkTank tank = (TileDarkTank)tileEntity;
            FluidStack fluid = tank.getTank().getFluid();
            RenderHelpers.renderTileFluidContext(fluid, x, y, z, tileEntity, new RenderHelpers.IFluidContextRender(){

                @Override
                public void renderFluid(FluidStack fluid) {
                    double height = tank.getFillRatio() * 0.99;
                    RenderTileEntityDarkTank.renderFluidSides(height, fluid);
                }
            });
        }
    }

    public static void renderFluidSides(double height, FluidStack fluid) {
        for (ForgeDirection side : DirectionHelpers.DIRECTIONS) {
            IIcon icon = RenderHelpers.getFluidIcon(fluid, side);
            Tessellator t = Tessellator.field_78398_a;
            t.func_78382_b();
            double[][] c = coordinates[side.ordinal()];
            double replacedMaxV = side == ForgeDirection.UP || side == ForgeDirection.DOWN ? (double)icon.func_94210_h() : (double)(icon.func_94210_h() - icon.func_94206_g()) * height + (double)icon.func_94206_g();
            t.func_78374_a(c[0][0], RenderTileEntityDarkTank.getHeight(side, c[0][1], height), c[0][2], (double)icon.func_94209_e(), replacedMaxV);
            t.func_78374_a(c[1][0], RenderTileEntityDarkTank.getHeight(side, c[1][1], height), c[1][2], (double)icon.func_94209_e(), (double)icon.func_94206_g());
            t.func_78374_a(c[2][0], RenderTileEntityDarkTank.getHeight(side, c[2][1], height), c[2][2], (double)icon.func_94212_f(), (double)icon.func_94206_g());
            t.func_78374_a(c[3][0], RenderTileEntityDarkTank.getHeight(side, c[3][1], height), c[3][2], (double)icon.func_94212_f(), replacedMaxV);
            t.func_78381_a();
        }
    }

    private static double getHeight(ForgeDirection side, double height, double replaceHeight) {
        if (height == 0.865) {
            return replaceHeight;
        }
        return height;
    }
}

