/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.core;

public enum DirectionCorner {
    UPPER_NORTH(0, 1, -1),
    UPPER_SOUTH(0, 1, 1),
    UPPER_WEST(-1, 1, 0),
    UPPER_EAST(1, 1, 0),
    MIDDLE_NORTHWEST(-1, 0, -1),
    MIDDLE_NORTHEAST(1, 0, -1),
    MIDDLE_SOUTHEAST(1, 0, 1),
    MIDDLE_SOUTHWEST(-1, 0, 1),
    LOWER_NORTH(0, -1, -1),
    LOWER_SOUTH(0, -1, 1),
    LOWER_WEST(-1, -1, 0),
    LOWER_EAST(1, -1, 0),
    UNKNOWN(0, 0, 0);

    public final int offsetX;
    public final int offsetY;
    public final int offsetZ;
    public final int flag;
    public static final DirectionCorner[] VALID_DIRECTIONS;

    private DirectionCorner(int x, int y, int z) {
        this.offsetX = x;
        this.offsetY = y;
        this.offsetZ = z;
        this.flag = 1 << this.ordinal();
    }

    public static DirectionCorner getOrientation(int id) {
        if (id >= 0 && id < VALID_DIRECTIONS.length) {
            return VALID_DIRECTIONS[id];
        }
        return UNKNOWN;
    }

    static {
        VALID_DIRECTIONS = new DirectionCorner[]{UPPER_NORTH, UPPER_SOUTH, UPPER_WEST, UPPER_EAST, MIDDLE_NORTHWEST, MIDDLE_NORTHEAST, MIDDLE_SOUTHEAST, MIDDLE_SOUTHWEST, LOWER_NORTH, LOWER_SOUTH, LOWER_WEST, LOWER_EAST};
    }
}

