/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.core.algorithm;

import evilcraft.api.ILocation;
import java.util.Random;
import net.minecraft.world.World;

public class OrganicSpread {
    private static Random random = new Random();
    private World world;
    private int dimensions;
    private int radius;
    private IOrganicSpreadable spreadable;

    public OrganicSpread(World world, int dimensions, int radius, IOrganicSpreadable spreadable) {
        this.world = world;
        this.setDimensions(dimensions);
        this.setRadius(radius);
        this.setSpreadable(spreadable);
    }

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        this.radius = radius;
    }

    public int getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(int dimensions) {
        this.dimensions = dimensions;
    }

    public IOrganicSpreadable getSpreadable() {
        return this.spreadable;
    }

    public void setSpreadable(IOrganicSpreadable spreadable) {
        this.spreadable = spreadable;
    }

    public void spreadTick(ILocation startLocation) {
        if (startLocation.getDimensions() != this.getDimensions()) {
            throw new RuntimeException("The dimensions of the given location(" + startLocation.getDimensions() + ") do not equal " + "this spreading dimensions(" + this.getDimensions() + ").");
        }
        ILocation newLocation = startLocation.copy();
        float[] direction = this.getRandomDirection();
        for (int attempts = 10; !this.isBigEnough(direction) && attempts > 0; --attempts) {
            direction = this.getRandomDirection();
        }
        float[] oldCoordinates = new float[newLocation.getDimensions()];
        for (int i = 0; i < newLocation.getDimensions(); ++i) {
            oldCoordinates[i] = newLocation.getCoordinates()[i];
        }
        while (this.getSpreadable().isDone(this.world, newLocation) && this.isInArea(startLocation, oldCoordinates)) {
            float[] newCoordinates = new float[direction.length];
            for (int i = 0; i < newCoordinates.length; ++i) {
                newCoordinates[i] = oldCoordinates[i] + direction[i];
            }
            int[] finalCoordinates = new int[newLocation.getDimensions()];
            for (int i = 0; i < newLocation.getDimensions(); ++i) {
                finalCoordinates[i] = (int)newCoordinates[i];
            }
            newLocation.setCoordinates(finalCoordinates);
            oldCoordinates = newCoordinates;
        }
        if (!this.getSpreadable().isDone(this.world, newLocation)) {
            this.getSpreadable().spreadTo(this.world, newLocation);
        }
    }

    protected boolean isInArea(ILocation center, float[] location) {
        int distance = 0;
        for (int i = 0; i < center.getDimensions(); ++i) {
            float d = (float)center.getCoordinates()[i] - location[i];
            distance = (int)((float)distance + d * d);
        }
        return Math.sqrt(distance) <= (double)this.getRadius();
    }

    protected boolean isBigEnough(float[] direction) {
        float MIN = 0.3f;
        for (float directionElement : direction) {
            if (!(directionElement > MIN) && !(directionElement < MIN)) continue;
            return true;
        }
        return false;
    }

    protected float[] getRandomDirection() {
        float[] direction = new float[this.getDimensions()];
        for (int i = 0; i < direction.length; ++i) {
            direction[i] = (random.nextFloat() * 2.0f - 1.0f) / 2.0f;
        }
        return direction;
    }

    public static interface IOrganicSpreadable {
        public boolean isDone(World var1, ILocation var2);

        public void spreadTo(World var1, ILocation var2);
    }
}

