/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.core.algorithm;

import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import evilcraft.api.ILocation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Random;

public class RegionIterator
implements Iterator<ILocation> {
    private ILocation center;
    private int offset;
    private boolean shuffle;
    private int loopBlockTick;
    private int maxTick;
    private ArrayList<Integer> shuffledTicks;

    public RegionIterator(ILocation center, int offset, boolean shuffle) {
        this.center = center;
        this.offset = offset;
        this.shuffle = shuffle;
        this.maxTick = (int)Math.pow(this.getArea(), 3.0);
        this.shuffledTicks = Lists.newArrayList((Iterable)ContiguousSet.create((Range)Range.closed((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(this.maxTick)), (DiscreteDomain)DiscreteDomain.integers()).asList());
        if (this.shuffle) {
            Random random = new Random();
            random.setSeed(this.getShuffleSeed());
            Collections.shuffle(this.shuffledTicks, random);
        }
    }

    private long getShuffleSeed() {
        long seed = 0L;
        for (int c : this.center.getCoordinates()) {
            seed += (long)c;
        }
        return seed;
    }

    public RegionIterator(ILocation center, int offset) {
        this(center, offset, false);
    }

    private int getArea() {
        return 2 * this.offset + 1;
    }

    private void addTickOffset(ILocation center) {
        int tick = this.shuffledTicks.get(this.loopBlockTick);
        int i = 0;
        while (i < center.getDimensions()) {
            int mod = (int)Math.pow(this.getArea(), i + 1);
            int prevMod = (int)Math.pow(this.getArea(), i);
            int[] nArray = center.getCoordinates();
            int n = i++;
            nArray[n] = nArray[n] + (-this.offset + (tick % mod - tick % prevMod) / prevMod);
        }
    }

    @Override
    public boolean hasNext() {
        return true;
    }

    @Override
    public ILocation next() {
        this.loopBlockTick = (this.loopBlockTick + 1) % this.maxTick;
        ILocation next = this.center.copy();
        this.addTickOffset(next);
        return next;
    }

    @Override
    public void remove() {
    }
}

