/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.core.client.render;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import evilcraft.core.entity.item.EntityThrowable;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderThrowable
extends Render {
    private Item item;

    public RenderThrowable(Item item) {
        this.item = item;
    }

    public void func_76986_a(Entity entity, double x, double y, double z, float yaw, float partialTickTime) {
        this.renderThrowable((EntityThrowable)entity, x, y, z, yaw, partialTickTime);
    }

    private void renderThrowable(EntityThrowable entity, double x, double y, double z, float yaw, float partialTickTime) {
        ItemStack stack = entity.getItemStack();
        int damage = stack != null ? stack.func_77960_j() : 0;
        int renderPass = 0;
        int numberOfPasses = this.item.getRenderPasses(damage);
        IIcon icon = this.item.func_77618_c(damage, renderPass);
        if (icon != null) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
            GL11.glEnable((int)32826);
            GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
            this.func_110777_b((Entity)entity);
            Tessellator tessellator = Tessellator.field_78398_a;
            this.setColor(stack, renderPass);
            GL11.glPushMatrix();
            this.renderIcon(tessellator, icon);
            GL11.glPopMatrix();
            ++renderPass;
            while (renderPass < numberOfPasses && (icon = this.item.func_77618_c(damage, renderPass)) != null) {
                this.setColor(stack, renderPass);
                GL11.glPushMatrix();
                this.renderIcon(tessellator, icon);
                GL11.glPopMatrix();
                GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                ++renderPass;
            }
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)32826);
            GL11.glPopMatrix();
        }
    }

    private void setColor(ItemStack stack, int renderPass) {
        if (stack == null) {
            return;
        }
        int color = stack.func_77973_b().func_82790_a(stack, renderPass);
        float red = (float)(color >> 16) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        GL11.glColor3f((float)red, (float)green, (float)blue);
    }

    private void renderIcon(Tessellator tessellator, IIcon icon) {
        float f = icon.func_94209_e();
        float f1 = icon.func_94212_f();
        float f2 = icon.func_94206_g();
        float f3 = icon.func_94210_h();
        float f4 = 1.0f;
        float f5 = 0.5f;
        float f6 = 0.25f;
        GL11.glRotatef((float)(180.0f - this.field_76990_c.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-this.field_76990_c.field_78732_j), (float)1.0f, (float)0.0f, (float)0.0f);
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        tessellator.func_78374_a((double)(0.0f - f5), (double)(0.0f - f6), 0.0, (double)f, (double)f3);
        tessellator.func_78374_a((double)(f4 - f5), (double)(0.0f - f6), 0.0, (double)f1, (double)f3);
        tessellator.func_78374_a((double)(f4 - f5), (double)(f4 - f6), 0.0, (double)f1, (double)f2);
        tessellator.func_78374_a((double)(0.0f - f5), (double)(f4 - f6), 0.0, (double)f, (double)f2);
        tessellator.func_78381_a();
    }

    protected ResourceLocation func_110775_a(Entity entity) {
        return TextureMap.field_110576_c;
    }
}

