/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.core.client.render.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import evilcraft.core.DirectionCorner;
import evilcraft.core.helper.DirectionHelpers;
import evilcraft.core.helper.RenderHelpers;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

public class ConnectableIcon
implements IIcon {
    protected static final int LAYERS = 4;
    protected static final int EDGES = 4;
    protected static final int SIDES = DirectionHelpers.DIRECTIONS.size();
    protected IIcon[] icons = new IIcon[4];
    protected IIcon inventoryBlockIcon;
    protected int renderPass = 0;
    protected int side = 0;
    protected boolean isInventoryBlock = false;
    protected static final ForgeDirection[][] CONNECT_MATRIX = new ForgeDirection[][]{{ForgeDirection.NORTH, ForgeDirection.WEST, ForgeDirection.SOUTH, ForgeDirection.EAST}, {ForgeDirection.NORTH, ForgeDirection.EAST, ForgeDirection.SOUTH, ForgeDirection.WEST}, {ForgeDirection.UP, ForgeDirection.WEST, ForgeDirection.DOWN, ForgeDirection.EAST}, {ForgeDirection.UP, ForgeDirection.EAST, ForgeDirection.DOWN, ForgeDirection.WEST}, {ForgeDirection.UP, ForgeDirection.SOUTH, ForgeDirection.DOWN, ForgeDirection.NORTH}, {ForgeDirection.UP, ForgeDirection.NORTH, ForgeDirection.DOWN, ForgeDirection.SOUTH}};
    protected static final DirectionCorner[][] CONNECT_CORNER_MATRIX = new DirectionCorner[][]{{DirectionCorner.MIDDLE_NORTHWEST, DirectionCorner.MIDDLE_SOUTHWEST, DirectionCorner.MIDDLE_SOUTHEAST, DirectionCorner.MIDDLE_NORTHEAST}, {DirectionCorner.MIDDLE_NORTHWEST, DirectionCorner.MIDDLE_NORTHEAST, DirectionCorner.MIDDLE_SOUTHEAST, DirectionCorner.MIDDLE_SOUTHWEST}, {DirectionCorner.UPPER_EAST, DirectionCorner.UPPER_WEST, DirectionCorner.LOWER_WEST, DirectionCorner.LOWER_EAST}, {DirectionCorner.UPPER_WEST, DirectionCorner.UPPER_EAST, DirectionCorner.LOWER_EAST, DirectionCorner.LOWER_WEST}, {DirectionCorner.UPPER_NORTH, DirectionCorner.UPPER_SOUTH, DirectionCorner.LOWER_SOUTH, DirectionCorner.LOWER_NORTH}, {DirectionCorner.UPPER_SOUTH, DirectionCorner.UPPER_NORTH, DirectionCorner.LOWER_NORTH, DirectionCorner.LOWER_SOUTH}};
    protected boolean[] connectWithSides = new boolean[DirectionHelpers.DIRECTIONS.size()];
    protected boolean[] connectWithSidesCorner = new boolean[DirectionHelpers.DIRECTIONS_CORNERS.size()];

    public ConnectableIcon(IIcon background, IIcon borders, IIcon corners, IIcon innerCorners, IIcon inventoryBlockIcon) {
        this.icons[0] = background;
        this.icons[1] = borders;
        this.icons[2] = corners;
        this.icons[3] = innerCorners;
        this.inventoryBlockIcon = inventoryBlockIcon;
    }

    protected void setRenderPass(int renderPass) {
        this.renderPass = renderPass >= 0 && renderPass < this.getRequiredPasses() ? renderPass : 0;
    }

    protected void setSide(int side) {
        this.side = side >= 0 && side < SIDES ? side : 0;
    }

    protected IIcon getInnerIcon() {
        if (this.isInventoryBlock) {
            return this.inventoryBlockIcon;
        }
        if (this.shouldRender(this.getCurrentLayer())) {
            return this.icons[this.getCurrentLayer()];
        }
        return RenderHelpers.EMPTYICON;
    }

    protected boolean shouldConnect(int side, int rotation) {
        return this.getConnectWithSides()[CONNECT_MATRIX[side][rotation].ordinal()];
    }

    protected boolean shouldConnectCorner(int side, int rotation) {
        return this.getConnectWithSidesCorner()[CONNECT_CORNER_MATRIX[side][rotation].ordinal()];
    }

    protected boolean shouldRender(int layer) {
        if (layer == Layer.BACKGROUND.ordinal()) {
            return true;
        }
        if (layer == Layer.BORDERS.ordinal()) {
            return !this.shouldConnect(this.getCurrentSide(), this.getCurrentRotation());
        }
        if (layer == Layer.CORNERS.ordinal()) {
            int incr = -1;
            if (this.getCurrentSide() == ForgeDirection.DOWN.ordinal()) {
                incr = 1;
            }
            return !this.shouldConnect(this.getCurrentSide(), this.getCurrentRotation()) && !this.shouldConnect(this.getCurrentSide(), (this.getCurrentRotation() + 4 + incr) % 4);
        }
        int incr = -1;
        if (this.getCurrentSide() == ForgeDirection.DOWN.ordinal()) {
            incr = 1;
        }
        return this.shouldConnect(this.getCurrentSide(), this.getCurrentRotation()) && this.shouldConnect(this.getCurrentSide(), (this.getCurrentRotation() + 4 + incr) % 4) && !this.shouldConnectCorner(this.getCurrentSide(), this.getCurrentRotation());
    }

    @SideOnly(value=Side.CLIENT)
    public int func_94211_a() {
        return this.getInnerIcon().func_94211_a();
    }

    @SideOnly(value=Side.CLIENT)
    public int func_94216_b() {
        return this.getInnerIcon().func_94216_b();
    }

    @SideOnly(value=Side.CLIENT)
    public float func_94209_e() {
        return this.getInnerIcon().func_94209_e();
    }

    @SideOnly(value=Side.CLIENT)
    public float func_94212_f() {
        return this.getInnerIcon().func_94212_f();
    }

    @SideOnly(value=Side.CLIENT)
    public float func_94214_a(double d0) {
        return this.getInnerIcon().func_94214_a(d0);
    }

    @SideOnly(value=Side.CLIENT)
    public float func_94206_g() {
        return this.getInnerIcon().func_94206_g();
    }

    @SideOnly(value=Side.CLIENT)
    public float func_94210_h() {
        return this.getInnerIcon().func_94210_h();
    }

    @SideOnly(value=Side.CLIENT)
    public float func_94207_b(double d0) {
        return this.getInnerIcon().func_94207_b(d0);
    }

    @SideOnly(value=Side.CLIENT)
    public String func_94215_i() {
        return this.getInnerIcon().func_94215_i();
    }

    protected int getCurrentLayer() {
        return (this.renderPass - this.getCurrentRotation()) / 4;
    }

    protected int getCurrentRotation() {
        return this.renderPass % 4;
    }

    protected int getCurrentSide() {
        return this.side;
    }

    public int getRequiredPasses() {
        if (this.isInventoryBlock) {
            return 1;
        }
        return 16;
    }

    public void prepareIcon(int side, int renderPass, RenderBlocks renderBlocks) {
        this.setRenderPass(renderPass);
        this.setSide(side);
        int rotation = this.getCurrentRotation();
        ForgeDirection renderSide = ForgeDirection.getOrientation((int)side);
        RenderHelpers.setRenderBlocksUVRotation(renderBlocks, renderSide, rotation);
    }

    public void setInventoryBlock(boolean isInventoryBlock) {
        this.isInventoryBlock = isInventoryBlock;
    }

    public boolean[] getConnectWithSides() {
        return this.connectWithSides;
    }

    public boolean[] getConnectWithSidesCorner() {
        return this.connectWithSidesCorner;
    }

    public void connect(ForgeDirection direction, boolean connect) {
        this.connectWithSides[direction.ordinal()] = connect;
    }

    public void connectCorner(DirectionCorner direction, boolean connect) {
        this.connectWithSidesCorner[direction.ordinal()] = connect;
    }

    static enum Layer {
        BACKGROUND,
        BORDERS,
        CORNERS,
        INNERCORNERS;

    }
}

