/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.core.config.configurable;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import evilcraft.core.IInformationProvider;
import evilcraft.core.config.configurable.ConfigurableBlock;
import evilcraft.core.config.extendedconfig.ExtendedConfig;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class ConfigurableBlockWithInnerBlocks
extends ConfigurableBlock
implements IInformationProvider {
    protected final Block[] INNER_BLOCKS = this.makeInnerBlockList();

    public ConfigurableBlockWithInnerBlocks(ExtendedConfig eConfig, Material material) {
        super(eConfig, material);
    }

    protected abstract Block[] makeInnerBlockList();

    public void func_149666_a(Item item, CreativeTabs creativeTabs, List list) {
        for (int j = 0; j < this.INNER_BLOCKS.length; ++j) {
            list.add(new ItemStack(item, 1, j));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return this.getBlockFromMetadata(meta).func_149733_h(side);
    }

    public Item func_149650_a(int meta, Random random, int zero) {
        return this.getBlockFromMetadata(meta).func_149650_a(meta, random, zero);
    }

    protected ItemStack func_149644_j(int meta) {
        return new ItemStack(this.getBlockFromMetadata(meta));
    }

    @Override
    public String getInfo(ItemStack itemStack) {
        return "Block: " + EnumChatFormatting.ITALIC + this.getBlockFromMetadata(itemStack.func_77960_j()).func_149732_F();
    }

    @Override
    public void provideInformation(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
    }

    public int getMetadataFromBlock(Block block) {
        for (int i = 0; i < this.INNER_BLOCKS.length; ++i) {
            if (this.INNER_BLOCKS[i] != block) continue;
            return i;
        }
        return -1;
    }

    public Block getBlockFromMetadata(int blockMetadata) {
        return this.INNER_BLOCKS[Math.min(this.INNER_BLOCKS.length - 1, blockMetadata)];
    }

    public int getInnerBlocks() {
        return this.INNER_BLOCKS.length;
    }

    public float func_149712_f(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        return this.getBlockFromMetadata(meta).func_149712_f(world, x, y, z);
    }

    public int func_149692_a(int meta) {
        return meta;
    }

    public boolean canHarvestBlock(EntityPlayer player, int meta) {
        return this.getBlockFromMetadata(meta).canHarvestBlock(player, 0);
    }

    public float func_149737_a(EntityPlayer player, World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        return this.getBlockFromMetadata(meta).func_149737_a(player, world, x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149720_d(IBlockAccess world, int x, int y, int z) {
        return this.getBlockFromMetadata(world.func_72805_g(x, y, z)).func_149720_d(world, x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149741_i(int meta) {
        return this.getBlockFromMetadata(meta).func_149741_i(0);
    }
}

