/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.core.config.configurable;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import evilcraft.api.ILocation;
import evilcraft.core.config.configurable.ConfigurableBlockContainer;
import evilcraft.core.config.extendedconfig.ExtendedConfig;
import evilcraft.core.tileentity.InnerBlocksTileEntity;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class ConfigurableBlockWithInnerBlocksExtended
extends ConfigurableBlockContainer {
    public ConfigurableBlockWithInnerBlocksExtended(ExtendedConfig eConfig, Material material, Class<? extends InnerBlocksTileEntity> tileEntity) {
        super(eConfig, material, tileEntity);
        this.setRotatable(false);
    }

    public void func_149666_a(Item item, CreativeTabs creativeTabs, List list) {
    }

    @Override
    public boolean saveNBTToDroppedItem() {
        return false;
    }

    public InnerBlocksTileEntity getTile(IBlockAccess world, int x, int y, int z) throws InvalidInnerBlocksTileException {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile == null || !(tile instanceof InnerBlocksTileEntity)) {
            throw new InvalidInnerBlocksTileException();
        }
        return (InnerBlocksTileEntity)tile;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        try {
            return this.getTile(world, x, y, z).getInnerBlock().func_149691_a(side, world.func_72805_g(x, y, z));
        }
        catch (InvalidInnerBlocksTileException e) {
            return Blocks.field_150348_b.func_149673_e(world, x, y, z, side);
        }
        catch (NullPointerException e) {
            return Blocks.field_150348_b.func_149673_e(world, x, y, z, side);
        }
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean willHarvest) {
        this.unwrapInnerBlock(world, x, y, z);
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149720_d(IBlockAccess world, int x, int y, int z) {
        try {
            return this.getTile(world, x, y, z).getInnerBlock().func_149720_d(world, x, y, z);
        }
        catch (InvalidInnerBlocksTileException e) {
            return Blocks.field_150348_b.func_149720_d(world, x, y, z);
        }
        catch (NullPointerException e) {
            return Blocks.field_150348_b.func_149720_d(world, x, y, z);
        }
    }

    @Override
    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        Block block;
        try {
            block = this.getTile((IBlockAccess)world, x, y, z).getInnerBlock();
            if (block == null) {
                block = Blocks.field_150348_b;
            }
        }
        catch (InvalidInnerBlocksTileException e) {
            block = Blocks.field_150348_b;
        }
        return new ItemStack(block, 1, block.func_149643_k(world, x, y, z));
    }

    public float func_149712_f(World world, int x, int y, int z) {
        try {
            return this.getTile((IBlockAccess)world, x, y, z).getInnerBlock().func_149712_f(world, x, y, z);
        }
        catch (InvalidInnerBlocksTileException e) {
            return Blocks.field_150348_b.func_149712_f(world, x, y, z);
        }
        catch (NullPointerException e) {
            return Blocks.field_150348_b.func_149712_f(world, x, y, z);
        }
    }

    @Override
    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        try {
            return this.getTile((IBlockAccess)world, x, y, z).getInnerBlock().getDrops(world, x, y, z, metadata, fortune);
        }
        catch (InvalidInnerBlocksTileException e) {
            return Blocks.field_150348_b.getDrops(world, x, y, z, metadata, fortune);
        }
        catch (NullPointerException e) {
            return Blocks.field_150348_b.getDrops(world, x, y, z, metadata, fortune);
        }
    }

    public boolean setInnerBlock(World world, ILocation location) {
        int[] c = location.getCoordinates();
        return this.setInnerBlock(world, c[0], c[1], c[2]);
    }

    public boolean setInnerBlock(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        if (this.canSetInnerBlock(block, (IBlockAccess)world, x, y, z)) {
            int meta = world.func_72805_g(x, y, z);
            world.func_147449_b(x, y, z, (Block)this);
            try {
                this.getTile((IBlockAccess)world, x, y, z).setInnerBlock(block);
            }
            catch (InvalidInnerBlocksTileException e) {
                e.printStackTrace();
            }
            world.func_72921_c(x, y, z, meta, 2);
            return true;
        }
        return false;
    }

    public Block unwrapInnerBlock(World world, ILocation location) {
        int[] c = location.getCoordinates();
        return this.unwrapInnerBlock(world, c[0], c[1], c[2]);
    }

    public Block unwrapInnerBlock(World world, int x, int y, int z) {
        InnerBlocksTileEntity tile = null;
        try {
            tile = this.getTile((IBlockAccess)world, x, y, z);
        }
        catch (InvalidInnerBlocksTileException e) {
            e.printStackTrace();
        }
        if (tile == null) {
            return null;
        }
        Block block = tile.getInnerBlock();
        if (block == null) {
            return null;
        }
        int meta = world.func_72805_g(x, y, z);
        world.func_147449_b(x, y, z, block);
        world.func_72921_c(x, y, z, meta, 2);
        return block;
    }

    public boolean canSetInnerBlock(Block block, IBlockAccess world, int x, int y, int z) {
        return block != null && !block.isAir(world, x, y, z) && block.func_149662_c() && !block.hasTileEntity(world.func_72805_g(x, y, z)) && block.func_149645_b() == 0;
    }

    public static class InvalidInnerBlocksTileException
    extends Exception {
    }
}

