/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.core.config.extendedconfig;

import evilcraft.EvilCraft;
import evilcraft.IInitListener;
import evilcraft.core.config.ConfigProperty;
import evilcraft.core.config.ConfigPropertyCallback;
import evilcraft.core.config.ConfigurableProperty;
import evilcraft.core.config.ConfigurableType;
import evilcraft.core.config.EvilCraftConfigException;
import evilcraft.core.config.IChangedCallback;
import evilcraft.core.config.configurable.IConfigurable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.Level;

public abstract class ExtendedConfig<C extends ExtendedConfig<C>>
implements Comparable<ExtendedConfig<C>>,
IInitListener {
    private boolean enabled;
    private String namedId;
    private String comment;
    private Class element;
    private IConfigurable overriddenSubInstance;
    public List<ConfigProperty> configProperties = new LinkedList<ConfigProperty>();

    public ExtendedConfig(boolean enabled, String namedId, String comment, Class<?> element) {
        this.enabled = enabled;
        this.namedId = namedId;
        this.comment = comment;
        this.element = element;
        try {
            this.generateConfigProperties();
        }
        catch (IllegalArgumentException e1) {
            e1.printStackTrace();
        }
        catch (IllegalAccessException e2) {
            e2.printStackTrace();
        }
    }

    public String getNamedId() {
        return this.namedId;
    }

    public String getComment() {
        return this.comment;
    }

    public Class getElement() {
        return this.element;
    }

    private void generateConfigProperties() throws IllegalArgumentException, IllegalAccessException {
        for (Field field : this.getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(ConfigurableProperty.class)) continue;
            ConfigurableProperty annotation = field.getAnnotation(ConfigurableProperty.class);
            IChangedCallback changedCallback = null;
            if (annotation.changedCallback() != IChangedCallback.class) {
                try {
                    changedCallback = annotation.changedCallback().newInstance();
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
            }
            String category = annotation.categoryRaw().equals("") ? annotation.category().toString() : annotation.categoryRaw();
            ConfigProperty configProperty = new ConfigProperty(category, this.getConfigPropertyPrefix() + "." + field.getName(), field.get(null), annotation.comment(), new ConfigPropertyCallback(changedCallback), annotation.isCommandable(), field);
            configProperty.setRequiresWorldRestart(annotation.requiresWorldRestart());
            configProperty.setRequiresMcRestart(annotation.requiresMcRestart());
            this.configProperties.add(configProperty);
        }
    }

    protected String getConfigPropertyPrefix() {
        return this.getNamedId();
    }

    public void save() {
        String errorMessage = "Registering " + this.getNamedId() + " caused an issue.";
        try {
            this.getClass().getField("_instance").set(null, this);
            this.overriddenSubInstance = this.initSubInstance();
            if (this.getOverriddenSubInstance() == null && this.getHolderType().hasUniqueInstance()) {
                this.getElement().getMethod("initInstance", ExtendedConfig.class).invoke(null, this);
            }
        }
        catch (InvocationTargetException e) {
            EvilCraft.log("Registering " + this.getNamedId() + " caused the issue " + "(skipping registration): " + e.getCause().getMessage(), Level.ERROR);
            e.getCause().printStackTrace();
            if (!this.isDisableable()) {
                throw new EvilCraftConfigException("Registering " + this.getNamedId() + " caused the issue: " + e.getCause().getMessage() + ". Since this is a required element of this mod, we can not continue, " + "there might be ID conflicts with other mods.");
            }
            this.setEnabled(false);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new EvilCraftConfigException(errorMessage);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new EvilCraftConfigException(errorMessage);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new EvilCraftConfigException(errorMessage);
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new EvilCraftConfigException(errorMessage);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
            throw new EvilCraftConfigException(errorMessage);
        }
    }

    public abstract ConfigurableType getHolderType();

    public abstract String getUnlocalizedName();

    public String getFullUnlocalizedName() {
        return this.getUnlocalizedName();
    }

    protected IConfigurable initSubInstance() {
        return null;
    }

    private IConfigurable getOverriddenSubInstance() {
        return this.overriddenSubInstance;
    }

    public IConfigurable getSubInstance() {
        if (this.getOverriddenSubInstance() != null) {
            return this.getOverriddenSubInstance();
        }
        if (!this.getHolderType().hasUniqueInstance()) {
            throw new EvilCraftConfigException("There exists no unique instance for " + this);
        }
        try {
            return (IConfigurable)this.getElement().getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
        }
        catch (NoSuchMethodException e1) {
            e1.printStackTrace();
        }
        catch (SecurityException e2) {
            e2.printStackTrace();
        }
        catch (IllegalAccessException e3) {
            e3.printStackTrace();
        }
        catch (IllegalArgumentException e4) {
            e4.printStackTrace();
        }
        catch (InvocationTargetException e5) {
            e5.printStackTrace();
        }
        return null;
    }

    public String getSubUniqueName() {
        return this.getNamedId();
    }

    public void onRegistered() {
    }

    @Override
    public void onInit(IInitListener.Step step) {
    }

    @Override
    public int compareTo(ExtendedConfig<C> o) {
        return this.getNamedId().compareTo(o.getNamedId());
    }

    public boolean isEnabled() {
        return this.enabled && !this.isHardDisabled();
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isHardDisabled() {
        return false;
    }

    public boolean isDisableable() {
        return true;
    }

    public void showDoubleInitError() {
        String message = this.getClass() + " caused a double registration of " + this.getSubInstance() + ". This is an error in the mod code.";
        EvilCraft.log(message, Level.FATAL);
        throw new EvilCraftConfigException(message);
    }

    public C downCast() {
        ExtendedConfig c = this;
        return (C)c;
    }
}

