/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.core.degradation;

import evilcraft.api.RegistryManager;
import evilcraft.api.degradation.IDegradable;
import evilcraft.api.degradation.IDegradationEffect;
import evilcraft.api.degradation.IDegradationRegistry;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class DegradationExecutor {
    private static final String ROOT_TAG = "degradationExecutor";
    private static final int DEFAULT_TICK_INTERVAL = 1;
    private int tickInterval = 1;
    private int currentTick = 0;
    private IDegradable degradable;

    public DegradationExecutor(IDegradable degradable) {
        this.degradable = degradable;
    }

    public boolean runRandomEffect(boolean isRemote) {
        ++this.currentTick;
        if (this.currentTick >= this.tickInterval) {
            this.currentTick = 0;
            IDegradationEffect effect = RegistryManager.getRegistry(IDegradationRegistry.class).getRandomDegradationEffect();
            if (effect.canRun(this.degradable)) {
                if (isRemote) {
                    effect.runClientSide(this.degradable);
                } else {
                    effect.runServerSide(this.degradable);
                }
                return true;
            }
        }
        return false;
    }

    public void readFromNBT(NBTTagCompound compound) {
        this.tickInterval = compound.func_74775_l(ROOT_TAG).func_74762_e("tickInterval");
        this.currentTick = compound.func_74775_l(ROOT_TAG).func_74762_e("currentTick");
    }

    public void writeToNBT(NBTTagCompound compound) {
        NBTTagCompound content = new NBTTagCompound();
        content.func_74768_a("tickInterval", this.tickInterval);
        content.func_74768_a("currentTick", this.currentTick);
        compound.func_74782_a(ROOT_TAG, (NBTBase)content);
    }

    public int getTickInterval() {
        return this.tickInterval;
    }

    public void setTickInterval(int tickInterval) {
        this.tickInterval = tickInterval;
    }
}

