/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.core.degradation.effect;

import evilcraft.api.degradation.IDegradable;
import evilcraft.core.config.configurable.ConfigurableDegradationEffect;
import evilcraft.core.config.extendedconfig.DegradationEffectConfig;
import evilcraft.core.config.extendedconfig.ExtendedConfig;
import evilcraft.potion.PotionPalingConfig;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.potion.PotionEffect;

public class PalingDegradation
extends ConfigurableDegradationEffect {
    private static PalingDegradation _instance = null;
    private static final int MINIMUM_DEGRADATION = 10;
    private static final int PALING_DURATION_MULTIPLIER = 100;

    public static void initInstance(ExtendedConfig<DegradationEffectConfig> eConfig) {
        if (_instance == null) {
            _instance = new PalingDegradation(eConfig);
        } else {
            eConfig.showDoubleInitError();
        }
    }

    public static PalingDegradation getInstance() {
        return _instance;
    }

    private PalingDegradation(ExtendedConfig<DegradationEffectConfig> eConfig) {
        super(eConfig);
    }

    @Override
    public boolean canRun(IDegradable degradable) {
        return degradable.getDegradation() >= 10.0;
    }

    @Override
    public void runClientSide(IDegradable degradable) {
    }

    @Override
    public void runServerSide(IDegradable degradable) {
        List<Entity> entities = degradable.getAreaEntities();
        for (Entity entity : entities) {
            if (!(entity instanceof EntityLivingBase)) continue;
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(PotionPalingConfig._instance.ID, (int)degradable.getDegradation() * 100, Math.min(10, (int)degradable.getDegradation() / 10)));
        }
    }
}

