/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.core.degradation.effect;

import evilcraft.Configs;
import evilcraft.api.ILocation;
import evilcraft.api.degradation.IDegradable;
import evilcraft.block.NetherfishSpawn;
import evilcraft.block.NetherfishSpawnConfig;
import evilcraft.core.block.BlockTypeHolder;
import evilcraft.core.config.extendedconfig.DegradationEffectConfig;
import evilcraft.core.config.extendedconfig.ExtendedConfig;
import evilcraft.core.degradation.StochasticDegradationEffect;
import evilcraft.core.helper.LocationHelpers;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class TerraformDegradation
extends StochasticDegradationEffect {
    private static TerraformDegradation _instance = null;
    private static Map<Block, Map<BlockTypeHolder, Integer>> TERRAFORMATIONS = new HashMap<Block, Map<BlockTypeHolder, Integer>>();
    private static final double CHANCE = 0.1;
    private static Random random = new Random();

    public static void initInstance(ExtendedConfig<DegradationEffectConfig> eConfig) {
        if (_instance == null) {
            _instance = new TerraformDegradation(eConfig);
        } else {
            eConfig.showDoubleInitError();
        }
    }

    public static TerraformDegradation getInstance() {
        return _instance;
    }

    private static final void putReplacement(Block key, BlockTypeHolder value) {
        TerraformDegradation.putReplacement(key, value, 0);
    }

    private static final void putReplacement(Block key, BlockTypeHolder value, int chance) {
        Map<BlockTypeHolder, Integer> mapValue = TERRAFORMATIONS.get(key);
        if (mapValue == null) {
            mapValue = new HashMap<BlockTypeHolder, Integer>();
            TERRAFORMATIONS.put(key, mapValue);
        }
        mapValue.put(value, chance);
    }

    private TerraformDegradation(ExtendedConfig<DegradationEffectConfig> eConfig) {
        super(eConfig, 0.1);
    }

    @Override
    public void runClientSide(IDegradable degradable) {
    }

    protected BlockTypeHolder getReplacement(Block block) {
        Object[] keys;
        BlockTypeHolder holder;
        Integer chance;
        Map<BlockTypeHolder, Integer> mapValue = TERRAFORMATIONS.get(block);
        if (mapValue == null) {
            mapValue = TERRAFORMATIONS.get(null);
        }
        if (mapValue != null && ((chance = mapValue.get(holder = (BlockTypeHolder)(keys = mapValue.keySet().toArray())[random.nextInt(keys.length)])) == null || chance == 0 || random.nextInt(chance) == 0)) {
            return holder;
        }
        return null;
    }

    @Override
    public void runServerSide(IDegradable degradable) {
        int z;
        int y;
        ILocation blockPoint;
        int x;
        World world = degradable.getWorld();
        Block block = world.func_147439_a(x = (blockPoint = LocationHelpers.getRandomPointInSphere(degradable.getLocation(), degradable.getRadius())).getCoordinates()[0], y = blockPoint.getCoordinates()[1], z = blockPoint.getCoordinates()[2]);
        BlockTypeHolder replace = this.getReplacement(block);
        if (replace != null && !degradable.getLocation().equals(blockPoint) && world.func_147438_o(x, y, z) == null) {
            if (replace.getBlock() == null) {
                world.func_147468_f(x, y, z);
            } else if (replace.getBlock().func_149712_f(world, x, y, z) > 0.0f) {
                world.func_147465_d(x, y, z, replace.getBlock(), replace.getMeta(), 3);
            }
        }
    }

    static {
        TerraformDegradation.putReplacement(null, new BlockTypeHolder(Blocks.field_150347_e), 30);
        TerraformDegradation.putReplacement(Blocks.field_150348_b, new BlockTypeHolder(Blocks.field_150347_e));
        TerraformDegradation.putReplacement(Blocks.field_150347_e, new BlockTypeHolder(Blocks.field_150346_d), 10);
        TerraformDegradation.putReplacement(Blocks.field_150347_e, new BlockTypeHolder(Blocks.field_150353_l), 30);
        TerraformDegradation.putReplacement(Blocks.field_150402_ci, new BlockTypeHolder(Blocks.field_150484_ah), 10000);
        TerraformDegradation.putReplacement(Blocks.field_150346_d, new BlockTypeHolder(Blocks.field_150424_aL), 30);
        TerraformDegradation.putReplacement((Block)Blocks.field_150349_c, new BlockTypeHolder(Blocks.field_150424_aL), 20);
        TerraformDegradation.putReplacement((Block)Blocks.field_150391_bh, new BlockTypeHolder(Blocks.field_150424_aL), 5);
        TerraformDegradation.putReplacement(Blocks.field_150346_d, new BlockTypeHolder((Block)Blocks.field_150354_m));
        TerraformDegradation.putReplacement((Block)Blocks.field_150349_c, new BlockTypeHolder((Block)Blocks.field_150354_m));
        TerraformDegradation.putReplacement((Block)Blocks.field_150391_bh, new BlockTypeHolder((Block)Blocks.field_150354_m));
        TerraformDegradation.putReplacement(Blocks.field_150346_d, new BlockTypeHolder(Blocks.field_150435_aG), 20);
        TerraformDegradation.putReplacement((Block)Blocks.field_150349_c, new BlockTypeHolder((Block)Blocks.field_150354_m), 20);
        TerraformDegradation.putReplacement((Block)Blocks.field_150391_bh, new BlockTypeHolder((Block)Blocks.field_150354_m), 20);
        if (Configs.isEnabled(NetherfishSpawnConfig.class)) {
            TerraformDegradation.putReplacement(Blocks.field_150424_aL, new BlockTypeHolder(NetherfishSpawn.getInstance(), NetherfishSpawn.getInstance().getMetadataFromBlock(Blocks.field_150424_aL)), 50);
        }
        TerraformDegradation.putReplacement((Block)Blocks.field_150354_m, new BlockTypeHolder(null));
        TerraformDegradation.putReplacement(Blocks.field_150355_j, new BlockTypeHolder(null));
    }
}

