/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.core.fluid;

import evilcraft.core.config.IChangedCallback;
import evilcraft.core.fluid.ImplicitFluidConverter;
import evilcraft.fluid.Blood;

public class BloodFluidConverter
extends ImplicitFluidConverter {
    private static BloodFluidConverter _instance = new BloodFluidConverter();

    public static BloodFluidConverter getInstance() {
        if (_instance == null) {
            _instance = new BloodFluidConverter();
        }
        if (_instance.getTarget() == null) {
            _instance.resetTarget();
        }
        return _instance;
    }

    private BloodFluidConverter() {
        super(Blood.getInstance());
    }

    protected void resetTarget() {
        this.setTarget(Blood.getInstance());
    }

    public static class BloodConvertersChanged
    implements IChangedCallback {
        private static boolean calledOnce = false;

        @Override
        public void onChanged(Object value) {
            if (calledOnce) {
                BloodFluidConverter.getInstance().registerFromConfig((String[])value);
            }
            calledOnce = true;
        }

        @Override
        public void onRegisteredPostInit(Object value) {
            this.onChanged(value);
        }
    }
}

