/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.core.fluid;

import evilcraft.core.fluid.ImplicitFluidConverter;
import evilcraft.core.fluid.SingleUseTank;
import evilcraft.core.tileentity.EvilCraftTileEntity;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class ImplicitFluidConversionTank
extends SingleUseTank {
    private ImplicitFluidConverter converter;

    public ImplicitFluidConversionTank(String name, int capacity, EvilCraftTileEntity tile, ImplicitFluidConverter converter) {
        super(name, capacity, tile);
        this.converter = converter;
    }

    @Override
    public int fill(FluidStack resource, boolean doFill) {
        FluidStack converted = this.converter.convert(resource);
        if (converted == null) {
            return 0;
        }
        double ratio = resource != null ? this.converter.getRatio(resource.getFluid()) : 1.0;
        return (int)Math.ceil((double)super.fill(converted, doFill) / ratio);
    }

    @Override
    public boolean canTankAccept(Fluid fluid) {
        return super.canTankAccept(fluid) || this.converter.canConvert(fluid);
    }

    @Override
    public boolean canCompletelyFill(FluidStack fluidStack) {
        FluidStack converted = this.converter.convert(fluidStack);
        return super.canCompletelyFill(converted);
    }
}

