/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.core.fluid;

import evilcraft.core.fluid.Tank;
import evilcraft.core.tileentity.EvilCraftTileEntity;
import evilcraft.core.tileentity.TankInventoryTileEntity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class SingleUseTank
extends Tank {
    public static final String NBT_ACCEPTED_FLUID = "acceptedFluid";
    private Fluid acceptedFluid;
    protected EvilCraftTileEntity tile;

    public SingleUseTank(String name, int capacity, EvilCraftTileEntity tile) {
        super(name, capacity, tile);
        this.tile = tile;
    }

    public int fill(FluidStack resource, boolean doFill) {
        Fluid acceptedFluid = this.getAcceptedFluid();
        if (this.getFluid() == null && acceptedFluid != null) {
            acceptedFluid = null;
        }
        int filled = 0;
        if (resource == null) {
            filled = 0;
        } else {
            if (doFill && acceptedFluid == null) {
                acceptedFluid = resource.getFluid();
            }
            if (acceptedFluid == null || acceptedFluid == resource.getFluid()) {
                filled = super.fill(resource, doFill);
            }
        }
        if (filled > 0) {
            this.sendUpdate();
        }
        return filled;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        FluidStack drained = super.drain(maxDrain, doDrain);
        if (drained != null) {
            this.sendUpdate();
        }
        return drained;
    }

    protected void sendUpdate() {
        if (!(this.tile instanceof TankInventoryTileEntity) || ((TankInventoryTileEntity)this.tile).isSendUpdateOnTankChanged()) {
            this.tile.sendUpdate();
        }
    }

    public void reset() {
        this.acceptedFluid = null;
    }

    public void setAcceptedFluid(Fluid fluid) {
        this.acceptedFluid = fluid;
    }

    public Fluid getAcceptedFluid() {
        return this.acceptedFluid;
    }

    @Override
    public void writeTankToNBT(NBTTagCompound nbt) {
        super.writeTankToNBT(nbt);
        if (this.acceptedFluid != null) {
            nbt.func_74778_a(NBT_ACCEPTED_FLUID, this.acceptedFluid.getName());
        }
    }

    @Override
    public void readTankFromNBT(NBTTagCompound nbt) {
        super.readTankFromNBT(nbt);
        this.acceptedFluid = FluidRegistry.getFluid((String)nbt.func_74779_i(NBT_ACCEPTED_FLUID));
    }

    public boolean canTankAccept(Fluid fluid) {
        return this.getAcceptedFluid().equals(fluid);
    }

    public boolean canCompletelyFill(FluidStack fluidStack) {
        int amount = fluidStack != null ? fluidStack.amount : 0;
        return this.getFluidAmount() + amount <= this.getCapacity();
    }
}

