/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.core.fluid;

import evilcraft.core.fluid.SingleUseTank;
import evilcraft.core.fluid.WorldSharedTankCache;
import evilcraft.core.helper.MinecraftHelpers;
import evilcraft.core.tileentity.EvilCraftTileEntity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.WorldSavedData;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class WorldSharedTank
extends SingleUseTank {
    public static final String NBT_TANKID = "tankID";
    protected String tankID = "";
    private int previousAmount = 0;

    public WorldSharedTank(String name, int capacity, EvilCraftTileEntity tile) {
        super(name, capacity, tile);
        this.tile = tile;
    }

    public void resetPreviousFluid() {
        this.previousAmount = this.getFluidAmount();
    }

    public int getPreviousAmount() {
        return this.previousAmount;
    }

    @Override
    public void writeTankToNBT(NBTTagCompound nbt) {
        super.writeTankToNBT(nbt);
        nbt.func_74778_a(NBT_TANKID, this.tankID);
    }

    @Override
    public void readTankFromNBT(NBTTagCompound nbt) {
        super.readTankFromNBT(nbt);
        this.tankID = nbt.func_74779_i(NBT_TANKID);
    }

    protected void readWorldFluid() {
        this.fluid = WorldSharedTankCache.getInstance().getTankContent(this.tankID);
    }

    protected void writeWorldFluid() {
        if (!MinecraftHelpers.isClientSide()) {
            WorldSharedTankCache.getInstance().setTankContent(this.tankID, this.fluid);
        }
    }

    public void setFluid(FluidStack fluid) {
        super.setFluid(fluid);
        this.writeWorldFluid();
    }

    public FluidStack getFluid() {
        this.readWorldFluid();
        return super.getFluid();
    }

    public int getFluidAmount() {
        this.readWorldFluid();
        return super.getFluidAmount();
    }

    @Override
    public int fill(FluidStack resource, boolean doFill) {
        this.readWorldFluid();
        int ret = super.fill(resource, doFill);
        if (ret > 0 && doFill) {
            this.writeWorldFluid();
        }
        return ret;
    }

    @Override
    public FluidStack drain(int maxDrain, boolean doDrain) {
        this.readWorldFluid();
        FluidStack ret = super.drain(maxDrain, doDrain);
        if (ret != null && doDrain) {
            this.writeWorldFluid();
        }
        return ret;
    }

    public String getTankID() {
        return this.tankID;
    }

    @Override
    public Fluid getAcceptedFluid() {
        return this.getFluidType();
    }

    @Override
    protected boolean replaceInnerFluid() {
        return false;
    }

    public static class TankData
    extends WorldSavedData {
        public static final String KEY = "WorldSharedTanks";
        private NBTTagCompound tankTag = new NBTTagCompound();

        public TankData(String key) {
            super(key);
        }

        public NBTTagCompound getTankTag() {
            return this.tankTag;
        }

        public void func_76184_a(NBTTagCompound tag) {
            this.tankTag = tag.func_74775_l("Tank");
        }

        public void func_76187_b(NBTTagCompound tag) {
            tag.func_74782_a("Tank", (NBTBase)this.tankTag);
        }
    }
}

